/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.xiaomi.youpin.docean.Aop;
import com.xiaomi.youpin.docean.anno.Component;
import com.xiaomi.youpin.docean.anno.Controller;
import com.xiaomi.youpin.docean.anno.IocConfiguration;
import com.xiaomi.youpin.docean.anno.Service;
import com.xiaomi.youpin.docean.bo.Bean;
import com.xiaomi.youpin.docean.common.ClassDeserializer;
import com.xiaomi.youpin.docean.common.ClassFinder;
import com.xiaomi.youpin.docean.common.ClassSerializer;
import com.xiaomi.youpin.docean.common.FileUtils;
import com.xiaomi.youpin.docean.common.MutableObject;
import com.xiaomi.youpin.docean.common.ReflectUtils;
import com.xiaomi.youpin.docean.common.Safe;
import com.xiaomi.youpin.docean.common.StringUtils;
import com.xiaomi.youpin.docean.listener.IocListener;
import com.xiaomi.youpin.docean.listener.Listener;
import com.xiaomi.youpin.docean.listener.event.Event;
import com.xiaomi.youpin.docean.listener.event.EventType;
import com.xiaomi.youpin.docean.notify.DoceanNotify;
import com.xiaomi.youpin.docean.plugin.Plugin;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ioc {
    private static final Logger log = LoggerFactory.getLogger(Ioc.class);
    private final ConcurrentHashMap<String, Bean> beans = new ConcurrentHashMap();
    private final List<Class<? extends Annotation>> scanAnno = Lists.newArrayList((Object[])new Class[]{Component.class, Service.class, Controller.class});
    private final List<Class<? extends Annotation>> resourceAnno = Lists.newArrayList((Object[])new Class[]{Resource.class});
    private String[] scanPackages;
    private Class<?> primarySource;
    private Function<String, Object> contextFunction = new Function<String, Object>(this){

        public @Nullable Object apply(@Nullable String s) {
            return null;
        }
    };
    private IocListener iocListener = new IocListener();
    private Predicate<Class> classFilter = o -> true;
    private ClassLoader classLoader;
    private String name = "";
    private static final String TYPE_METHOD_NAME = "type";

    public Ioc name(String name) {
        this.name = name;
        return this;
    }

    public Ioc setContextFunction(Function<String, Object> function) {
        this.contextFunction = function;
        return this;
    }

    public Ioc classFilter(Predicate<Class> classFilter) {
        this.classFilter = classFilter;
        return this;
    }

    public Ioc setAnnos(Class<? extends Annotation> ... annotations) {
        this.scanAnno.addAll(Arrays.asList(annotations));
        return this;
    }

    public Ioc cleanAnnos() {
        this.scanAnno.clear();
        return this;
    }

    public Function<String, Object> contextFunction() {
        return this.contextFunction;
    }

    private Ioc() {
        this.iocListener.regListener(new DoceanNotify());
    }

    private Ioc(ClassLoader classLoader) {
        this();
        this.classLoader = classLoader;
    }

    public static boolean filterClass(Ioc ioc, Class<?> it, List<Class<? extends Annotation>> scanAnnoList) {
        return Optional.ofNullable(it).map(it2 -> {
            Optional optional = ReflectUtils.getAnno((Class)it2, (List)scanAnnoList);
            if (optional.isPresent()) {
                ioc.publishEvent(new Event(EventType.addBean, it.getName()));
                return it2;
            }
            return null;
        }).isPresent();
    }

    private static Class<?> classForName(String name, ClassLoader classLoader) {
        Class clazz = ReflectUtils.classForName((String)name, (ClassLoader)classLoader);
        return clazz;
    }

    private int getType(Class<?> clazz) {
        Optional opt;
        Optional optional = ReflectUtils.getAnno(clazz, this.scanAnno);
        if (optional.isPresent() && (opt = ReflectUtils.getMethod(((Annotation)optional.get()).getClass(), (String)TYPE_METHOD_NAME)).isPresent()) {
            return Safe.callAndLog(() -> ReflectUtils.invokeMethod(optional.get(), (String)TYPE_METHOD_NAME, (Object[])new Object[0]), -1);
        }
        return -1;
    }

    private Bean initBean(Class<?> it, boolean beans) {
        String name = this.getName(it);
        Bean bean = new Bean();
        bean.setName(name);
        bean.setClazz(it);
        bean.setType(this.getType(it));
        Object obj = Aop.ins().enhance(it);
        bean.setObj(obj);
        if (beans) {
            this.beans.put(name, bean);
            Plugin.ins().putBean(name, bean);
        }
        Plugin.ins().initBean(this, bean);
        return bean;
    }

    private String getName(Class<?> clazz) {
        String name = this.getName0(clazz);
        if (StringUtils.isEmpty(name)) {
            return clazz.getName();
        }
        return name;
    }

    private String getName0(Class<?> clazz) {
        List<Class<? extends Annotation>> annoList = this.scanAnno;
        return annoList.stream().map(it -> {
            Object obj = clazz.getAnnotation(it);
            if (Optional.ofNullable(obj).isPresent()) {
                Optional<String> optional = Lists.newArrayList((Object[])new String[]{"name", "value"}).stream().map(v -> this.getAnnoValue(obj, (String)v)).filter(v -> null != v).findAny();
                return optional.orElse("");
            }
            return "";
        }).filter(it -> StringUtils.isNotEmpty(it)).findFirst().orElse("");
    }

    private String getAnnoValue(Object obj, String method) {
        try {
            String value = obj.getClass().getMethod(method, new Class[0]).invoke(obj, new Object[0]).toString();
            if (StringUtils.isNotEmpty(value)) {
                return value;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private Annotation getResourceAnno(Field f) {
        Optional<Class> optional = this.resourceAnno.stream().filter(it -> f.getAnnotation(it) != null).findAny();
        if (optional.isPresent()) {
            return f.getAnnotation(optional.get());
        }
        return null;
    }

    private String getResourceName(Annotation annotation, Field f) {
        if (annotation instanceof Resource) {
            Resource f2 = (Resource)annotation;
            String name = f2.name();
            if (name.equals("")) {
                name = f.getType().getName();
            }
            if (!f2.lookup().equals("")) {
                name = Joiner.on((String)":").join((Object)name, (Object)f2.lookup(), new Object[0]);
            }
            return name;
        }
        return f.getType().getName();
    }

    public void initIoc(Bean it) {
        Field[] fields = ReflectUtils.fields(it.getClazz());
        Arrays.stream(fields).forEach(f -> {
            Annotation[] ans = f.getAnnotations();
            String o = Plugin.ins().initIoc(this, f.getType(), ans, () -> {
                MutableObject res = new MutableObject();
                Optional.ofNullable(this.getResourceAnno((Field)f)).ifPresent(f2 -> {
                    String name = this.getResourceName((Annotation)f2, (Field)f);
                    res.setObj(name);
                });
                return Optional.ofNullable(res.getObj()).map(ob -> ob.toString()).orElse(null);
            });
            Optional.ofNullable(o).ifPresent(obj -> this.initIoc0(o, it, (Field)f));
        });
    }

    public void addBean(String name, Object obj, Map<String, Field> dependenceMap) {
        this.putBean(name, obj);
        Bean bean = this.getBeanInfo(name);
        this.callInit(bean);
        this.initIoc(bean);
        this.callDependenceIoc(bean, dependenceMap);
    }

    private void callDependenceIoc(Bean bean, Map<String, Field> dependenceMap) {
        dependenceMap.entrySet().stream().forEach(it -> {
            Bean b = this.getBeanInfo((String)it.getKey());
            ReflectUtils.setField((Object)b.getObj(), (Field)((Field)it.getValue()), (Object)bean.getObj());
        });
    }

    public void removeBean(String name) {
        Bean bean = this.getBeanInfo(name);
        bean.getDependenceFieldMap().entrySet().forEach(it -> {
            Bean b = this.getBeanInfo((String)it.getKey());
            ReflectUtils.setField((Object)b.getObj(), (Field)((Field)it.getValue()), null);
        });
        this.beans.remove(name);
        this.destoryBean(bean);
        this.publishEvent(new Event(EventType.removeBean, name, (Map<String, Object>)ImmutableMap.of((Object)"name", (Object)name)));
    }

    private void initIoc0(String name, Bean bean, Field field) {
        Set<Bean> set;
        Class<?> clazz;
        String realName = this.getRealName(name);
        Bean b = this.beans.get(realName);
        if (!Optional.ofNullable(b).isPresent() && this.getBean("$autoFindImpl", "false").equals("true") && (clazz = field.getType()).isInterface() && (set = this.getBeanSet(clazz)).size() == 1) {
            b = set.toArray(new Bean[0])[0];
        }
        Optional.ofNullable(b).ifPresent(o -> {
            o.incrReferenceCnt();
            o.getDependenceList().add(bean.getName());
            o.getDependenceFieldMap().put(bean.getName(), field);
            ReflectUtils.setField((Object)bean.getObj(), (Field)field, (Object)o.getObj());
        });
        if (!Optional.ofNullable(b).isPresent()) {
            Object obj = Safe.callAndLog(() -> this.contextFunction.apply((Object)realName), null);
            Optional.ofNullable(obj).ifPresent(o -> ReflectUtils.setField((Object)bean.getObj(), (Field)field, (Object)o));
        }
    }

    private String getRealName(String name) {
        Bean bean;
        if (((String)name).startsWith("^") && null != (bean = this.beans.get(name = "$" + ((String)name).substring(1)))) {
            return bean.getObj().toString();
        }
        return name;
    }

    private void callInit(Bean it) {
        Stopwatch sw = Stopwatch.createStarted();
        String methodName = Plugin.ins().getInitMethodName(it.getObj(), it.getClazz());
        ReflectUtils.invokeMethod((Object)it.getObj(), it.getClazz(), (String)methodName, (Object[])new Object[0]);
        this.publishEvent(new Event(EventType.initBean, it, (Map<String, Object>)ImmutableMap.of((Object)"useTime", (Object)sw.elapsed(TimeUnit.MILLISECONDS))));
    }

    public Ioc classLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public static Ioc run(Class<?> primarySource, String ... args) {
        IocConfiguration configuration = primarySource.getAnnotation(IocConfiguration.class);
        Ioc ioc = Ioc.ins();
        ioc.primarySource = primarySource;
        Ioc.parseArgumentsAndPopulateIoc(args, ioc);
        return ioc.init(configuration.basePackage());
    }

    private static void parseArgumentsAndPopulateIoc(String[] args, Ioc ioc) {
        HashMap<String, String> argsMap = new HashMap<String, String>();
        if (args.length % 2 == 0) {
            for (int i = 0; i < args.length; i += 2) {
                argsMap.put(args[i], args[i + 1]);
            }
        }
        argsMap.entrySet().forEach(entry -> ioc.putBean("$" + (String)entry.getKey(), entry.getValue()));
    }

    public Ioc init(String ... scanPackages) {
        this.scanPackages = scanPackages;
        this.publishEvent(new Event(EventType.initBegin));
        Stopwatch sw = Stopwatch.createStarted();
        Set<String> classNameSet = this.getClassNameSet(this.scanPackages);
        Set classSet = classNameSet.stream().map(it -> Ioc.classForName(it, this.classLoader)).filter(it -> Optional.ofNullable(it).isPresent()).collect(Collectors.toSet());
        Plugin.ins().init(classSet, this);
        this.initAnnoList();
        classSet.stream().filter(it -> Ioc.filterClass(this, it, this.scanAnno)).filter(this.classFilter).forEach(it -> this.initBean((Class<?>)it, true));
        this.beans.values().stream().forEach(it -> this.initIoc((Bean)it));
        this.beans.values().stream().forEach(it -> this.callInit((Bean)it));
        Plugin.ins().after(this);
        Plugin.ins().start(this);
        this.publishEvent(new Event(EventType.initFinish, sw.elapsed(TimeUnit.MILLISECONDS), (Map<String, Object>)ImmutableMap.of((Object)"name", (Object)this.name)));
        return this;
    }

    private Set<String> getClassNameSet(String[] scanPackages) {
        return Arrays.stream(scanPackages).map(scanPackage -> {
            Set<String> set = new ClassFinder().findClassSet((String)scanPackage, this.classLoader);
            return set;
        }).flatMap(it -> it.stream()).collect(Collectors.toSet());
    }

    private void initAnnoList() {
        List<Class<? extends Annotation>> filterResourceAnnotationList;
        List<Class<? extends Annotation>> filterAnnotationList = Plugin.ins().filterAnnotationList();
        if (filterAnnotationList.size() > 0) {
            filterAnnotationList.addAll(this.scanAnno);
            this.scanAnno.clear();
            this.scanAnno.addAll(filterAnnotationList);
        }
        if ((filterResourceAnnotationList = Plugin.ins().filterResourceAnnotationList()).size() > 0) {
            filterResourceAnnotationList.addAll(this.resourceAnno);
            this.resourceAnno.clear();
            this.resourceAnno.addAll(filterResourceAnnotationList);
        }
    }

    public static final Ioc ins() {
        return LazyHolder.ins;
    }

    public static Ioc create(ClassLoader classLoader) {
        return new Ioc(classLoader);
    }

    public Map<String, Object> getBeansWithAnnotation(Class<? extends Annotation> annotationType) {
        return this.beans.entrySet().stream().filter(entry -> ((Bean)entry.getValue()).getClazz().isAnnotationPresent(annotationType)).collect(Collectors.toMap(Map.Entry::getKey, v -> ((Bean)v.getValue()).getObj()));
    }

    public <T> T getBean(String name) {
        return this.getBean(name, null);
    }

    public <T> T getBean(String name, Object defalutValue) {
        Bean bean = this.beans.get(name);
        return (T)Optional.ofNullable(bean).map(it -> it.getObj()).orElse(defalutValue);
    }

    public <T> T getBean(Class clazz) {
        return this.getBean(clazz.getName(), null);
    }

    public Bean getBeanInfo(String name) {
        return this.beans.get(name);
    }

    public boolean containsBean(String name) {
        return this.beans.containsKey(name);
    }

    public Ioc putBean(Object obj) {
        return this.putBean(obj.getClass().getName(), obj);
    }

    public Ioc regListener(Listener listener) {
        this.iocListener.regListener(listener);
        return this;
    }

    public Ioc putBeanInfo(Bean bean) {
        this.beans.put(bean.getName(), bean);
        return this;
    }

    public Ioc putBean(String name, Object obj) {
        return this.putBean(name, name, obj, "", false);
    }

    public Ioc putBean(String name, Object obj, int type) {
        return this.putBean(name, name, obj, "", false, type);
    }

    public Ioc putBean(String name, String alias, Object obj, String lookup, boolean objMap) {
        return this.putBean(name, alias, obj, lookup, objMap, Bean.Type.component.ordinal());
    }

    public Ioc putBean(String name, String alias, Object obj, String lookup, boolean objMap, int type) {
        Bean bean = new Bean();
        bean.setObj(obj);
        bean.setAlias(alias);
        bean.setClazz(obj.getClass());
        bean.setName(obj.getClass().getName());
        bean.setLookup(lookup);
        bean.setType(type);
        if (StringUtils.isNotEmpty(lookup)) {
            name = Joiner.on((String)":").join((Object)name, (Object)lookup, new Object[0]);
        }
        if (objMap) {
            this.beans.put(obj.toString(), bean);
        }
        this.beans.put(name, bean);
        this.publishEvent(new Event(EventType.putBean, bean));
        return this;
    }

    public Ioc remove(String name) {
        this.beans.remove(name);
        return this;
    }

    public <T> T createBean(Class<T> clazz) {
        log.info("create bean:{}", clazz);
        Bean bean = this.initBean(clazz, false);
        this.initIoc(bean);
        return (T)bean.getObj();
    }

    public Set<Object> getBeans() {
        return new HashSet<Object>(this.beans.values());
    }

    public ConcurrentHashMap<String, Bean> getBeanInfos() {
        return this.beans;
    }

    public <T> Set<T> getBeans(Class<T> clazz) {
        return this.beans.values().stream().filter(it -> clazz.isAssignableFrom(it.getClazz())).map(it -> it.getObj()).collect(Collectors.toSet());
    }

    public Set<Bean> getBeanSet(Class<?> clazz) {
        return this.beans.values().stream().filter(it -> clazz.isAssignableFrom(it.getClazz())).collect(Collectors.toSet());
    }

    public Set<Bean> getBeans(Bean.Type type) {
        return this.beans.values().stream().filter(it -> it.getType() == type.ordinal()).collect(Collectors.toSet());
    }

    public Map<String, Bean> beans() {
        return this.beans;
    }

    public void destory() {
        log.info("ioc destory");
        Plugin.ins().destory(this);
        this.beans.values().stream().sorted(Bean::compareTo).forEach(b -> {
            if (Optional.ofNullable(b.getObj()).isPresent()) {
                if (b.getObj() instanceof Ioc) {
                    return;
                }
                this.destoryBean((Bean)b);
            }
        });
        this.beans.clear();
    }

    private void destoryBean(Bean b) {
        String destroyMethodName = Plugin.ins().getDestoryMethodName(b.getObj(), b.getObj().getClass());
        ReflectUtils.invokeMethod((Object)b.getObj(), b.getObj().getClass(), (String)destroyMethodName, (Object[])new Object[0]);
    }

    public void saveSnapshot() {
        Gson gson = new GsonBuilder().registerTypeAdapter(Class.class, (Object)new ClassDeserializer()).registerTypeAdapter(Class.class, (Object)new ClassSerializer()).create();
        List list = this.beans.entrySet().stream().map(it -> (Bean)it.getValue()).collect(Collectors.toList());
        Files.write(Paths.get(this.savePath(), new String[0]), gson.toJson(list).getBytes(), new OpenOption[0]);
    }

    private String savePath() {
        return FileUtils.home() + File.separator + "docean.cache";
    }

    public void loadSnapshot() {
        Gson gson = new GsonBuilder().registerTypeAdapter(Class.class, (Object)new ClassDeserializer()).registerTypeAdapter(Class.class, (Object)new ClassSerializer()).create();
        byte[] data = Files.readAllBytes(Paths.get(this.savePath(), new String[0]));
        Type typeOfT = new TypeToken<List<Bean>>(this){}.getType();
        List list = (List)gson.fromJson(new String(data), typeOfT);
        list.stream().forEach(it -> {
            log.info("{} {}", it, it.getClazz());
            Object obj = Aop.ins().enhance(it.getClazz());
            it.setObj(obj);
            this.putBeanInfo((Bean)it);
        });
        this.beans.values().stream().forEach(it -> this.initIoc((Bean)it));
    }

    public void publishEvent(Event event) {
        event.setIocName(this.name);
        this.iocListener.multicastEvent(event);
    }

    public String[] getScanPackages() {
        return this.scanPackages;
    }

    public Class<?> getPrimarySource() {
        return this.primarySource;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String getName() {
        return this.name;
    }

    private static class LazyHolder {
        private static final Ioc ins = new Ioc();

        private LazyHolder() {
        }
    }
}

