/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.service.impl;

import com.google.gson.Gson;
import com.xiaomi.youpin.docean.plugin.dubbo.anno.Service;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.app.api.response.AppBaseInfo;
import org.apache.ozhera.log.api.enums.DeployWayEnum;
import org.apache.ozhera.log.api.enums.ProjectTypeEnum;
import org.apache.ozhera.log.api.model.bo.MiLogMoneTransfer;
import org.apache.ozhera.log.api.model.dto.MontorAppDTO;
import org.apache.ozhera.log.api.model.vo.MiLogMoneEnv;
import org.apache.ozhera.log.api.service.MilogOpenService;
import org.apache.ozhera.log.manager.common.exception.MilogManageException;
import org.apache.ozhera.log.manager.common.validation.OpenSourceValid;
import org.apache.ozhera.log.manager.dao.MilogLogTailDao;
import org.apache.ozhera.log.manager.model.pojo.MilogLogTailDo;
import org.apache.ozhera.log.manager.service.impl.HeraAppServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service(interfaceClass=MilogOpenService.class, group="$dubbo.group")
public class MilogOpenServiceImpl
implements MilogOpenService {
    private static final Logger log = LoggerFactory.getLogger(MilogOpenServiceImpl.class);
    @Resource
    private MilogLogTailDao milogLogtailDao;
    @Resource
    private OpenSourceValid openSourceValid;
    @Resource
    private HeraAppServiceImpl heraAppService;
    @Resource
    private Gson gson;

    public MontorAppDTO queryHaveAccessMilog(Long iamTreeId, String bingId, Integer platformType) {
        MontorAppDTO montorAppDTO = new MontorAppDTO();
        if (null == iamTreeId) {
            return montorAppDTO;
        }
        AppBaseInfo appBaseInfo = this.heraAppService.queryByIamTreeId(iamTreeId, bingId, platformType);
        if (null == appBaseInfo) {
            return montorAppDTO;
        }
        List<MilogLogTailDo> logTailDos = this.milogLogtailDao.getLogTailByMilogAppId(appBaseInfo.getId().longValue());
        if (CollectionUtils.isNotEmpty(logTailDos)) {
            montorAppDTO.setAppId(Long.valueOf(appBaseInfo.getBindId()));
            montorAppDTO.setAppName(appBaseInfo.getAppName());
            montorAppDTO.setSource(appBaseInfo.getPlatformName());
            montorAppDTO.setIsAccess(Boolean.valueOf(true));
        }
        return montorAppDTO;
    }

    public Long querySpaceIdByIamTreeId(Long iamTreeId) {
        AppBaseInfo appBaseInfo = this.heraAppService.queryByIamTreeId(iamTreeId, "", null);
        if (null == appBaseInfo) {
            return null;
        }
        List<MilogLogTailDo> milogLogtailDos = this.milogLogtailDao.getLogTailByMilogAppId(appBaseInfo.getId().longValue());
        if (CollectionUtils.isEmpty(milogLogtailDos)) {
            return null;
        }
        List spaceIds = milogLogtailDos.stream().map(MilogLogTailDo::getSpaceId).distinct().collect(Collectors.toList());
        return (Long)spaceIds.get(spaceIds.size() - 1);
    }

    public MiLogMoneTransfer ypMoneEnvTransfer(MiLogMoneEnv logMoneEnv) {
        String errors = this.openSourceValid.validMiLogMoneEnv(logMoneEnv);
        if (StringUtils.isNotBlank((CharSequence)errors)) {
            throw new MilogManageException(errors);
        }
        log.info("youpin mione transfer milie,data:{}", (Object)this.gson.toJson((Object)logMoneEnv));
        MiLogMoneTransfer miLogMoneTransfer = new MiLogMoneTransfer();
        this.handleMilogAppInfo(logMoneEnv, miLogMoneTransfer);
        this.handleMilogAppTail(logMoneEnv, miLogMoneTransfer);
        return miLogMoneTransfer;
    }

    private void handleMilogAppTail(MiLogMoneEnv logMoneEnv, MiLogMoneTransfer miLogMoneTransfer) {
        List<MilogLogTailDo> milogLogtailDos = this.milogLogtailDao.queryByMilogAppAndEnv(miLogMoneTransfer.getMilogAppId(), logMoneEnv.getOldEnvId());
        if (CollectionUtils.isEmpty(milogLogtailDos)) {
            return;
        }
        for (MilogLogTailDo milogLogtailDo : milogLogtailDos) {
            milogLogtailDo.setAppName(logMoneEnv.getNewAppName());
            milogLogtailDo.setEnvId(logMoneEnv.getNewEnvId());
            milogLogtailDo.setEnvName(logMoneEnv.getNewEnvName());
            if (Objects.equals(1, logMoneEnv.getRollback())) {
                milogLogtailDo.setDeployWay(DeployWayEnum.MIONE.getCode());
            }
            this.milogLogtailDao.update(milogLogtailDo);
        }
        miLogMoneTransfer.setEnvId(logMoneEnv.getNewEnvId());
        miLogMoneTransfer.setEnvName(logMoneEnv.getNewEnvName());
        miLogMoneTransfer.setTailNames(milogLogtailDos.stream().map(MilogLogTailDo::getTail).collect(Collectors.toList()));
    }

    private void handleMilogAppInfo(MiLogMoneEnv logMoneEnv, MiLogMoneTransfer miLogMoneTransfer) {
        AppBaseInfo appBaseInfo = this.heraAppService.queryByAppId(logMoneEnv.getNewAppId(), ProjectTypeEnum.MIONE_TYPE.getCode());
        if (null == appBaseInfo && null == (appBaseInfo = this.heraAppService.queryByAppId(logMoneEnv.getNewAppId(), 20))) {
            throw new MilogManageException("The app does not exist");
        }
        miLogMoneTransfer.setMilogAppId(Long.valueOf(appBaseInfo.getId().longValue()));
        miLogMoneTransfer.setAppId(logMoneEnv.getNewAppId());
        miLogMoneTransfer.setAppName(logMoneEnv.getNewAppName());
    }
}

