/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.domain;

import com.xiaomi.youpin.docean.anno.Service;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.manager.dao.MilogLogstoreDao;
import org.apache.ozhera.log.manager.dao.MilogStoreSpaceAuthDao;
import org.apache.ozhera.log.manager.model.pojo.MilogLogStoreDO;
import org.apache.ozhera.log.manager.model.pojo.MilogStoreSpaceAuth;

@Service
public class Store {
    @Resource
    private MilogLogstoreDao logstoreDao;
    @Resource
    private MilogStoreSpaceAuthDao storeSpaceAuthDao;

    public List<MilogLogStoreDO> getStoreList(List<Long> spaceIdList, String keyword) {
        List<MilogLogStoreDO> storeList = this.logstoreDao.getMilogLogstoreBySpaceId(spaceIdList);
        Set storeIdSet = storeList.stream().filter(store -> {
            if (StringUtils.isNotEmpty((CharSequence)keyword)) {
                return store.getLogstoreName().contains(keyword);
            }
            return true;
        }).map(MilogLogStoreDO::getId).collect(Collectors.toSet());
        List<MilogStoreSpaceAuth> storeAuthList = this.storeSpaceAuthDao.queryBySpaceId(spaceIdList);
        if (storeAuthList != null && !storeAuthList.isEmpty()) {
            List<Long> authStoreIdList = storeAuthList.stream().filter(auth -> !storeIdSet.contains(auth.getStoreId())).map(MilogStoreSpaceAuth::getStoreId).collect(Collectors.toList());
            List<MilogLogStoreDO> authStoreList = this.logstoreDao.queryByIds(authStoreIdList);
            storeList.addAll(authStoreList);
        }
        return storeList;
    }
}

