/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.adaptor.injector;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nutz.castor.Castors;
import org.nutz.lang.Lang;
import org.nutz.mvc.adaptor.injector.NameInjector;

public class ArrayInjector
extends NameInjector {
    private boolean auto_split;

    public ArrayInjector(String name, String datefmt, Type type, Type[] paramTypes, String defaultValue, boolean auto_split) {
        super(name, datefmt, type, paramTypes, defaultValue);
        this.auto_split = auto_split;
    }

    @Override
    public Object get(ServletContext sc, HttpServletRequest req, HttpServletResponse resp, Object refer) {
        String[] values;
        Object value = null;
        if (null != refer) {
            if (refer instanceof Map && (value = (Object)((Map)refer).get(this.name)) != null && value.getClass().isArray()) {
                return Lang.array2array(value, this.klass.getComponentType());
            }
            if (value != null) {
                return this.convertMe(value);
            }
        }
        if (null == (values = req.getParameterValues(this.name)) || values.length == 0) {
            return null;
        }
        if (values.length == 1 && this.auto_split) {
            return this.convertMe(values[0]);
        }
        return Lang.array2array(values, this.klass.getComponentType());
    }

    protected Object convertMe(Object value) {
        try {
            return Castors.me().castTo(value, this.klass);
        }
        catch (Exception e) {
            Object re = Array.newInstance(this.klass.getComponentType(), 1);
            Object v = Castors.me().castTo(value, this.klass.getComponentType());
            Array.set(re, 0, v);
            return re;
        }
    }
}

