/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.adaptor;

import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.lang.Xmls;
import org.nutz.mvc.adaptor.PairAdaptor;
import org.nutz.mvc.adaptor.ParamInjector;
import org.nutz.mvc.adaptor.injector.VoidInjector;
import org.nutz.mvc.adaptor.injector.XmlInjector;
import org.nutz.mvc.annotation.Param;
import org.nutz.mvc.impl.AdaptorErrorContext;

public class XmlAdaptor
extends PairAdaptor {
    protected boolean lowerFirst;
    protected boolean dupAsList;
    protected List<String> alwaysAsList;

    public XmlAdaptor() {
    }

    public XmlAdaptor(boolean lowerFirst, boolean dupAsList, String alwaysAsList) {
        this.lowerFirst = lowerFirst;
        this.dupAsList = dupAsList;
        this.alwaysAsList = Arrays.asList(Strings.splitIgnoreBlank(alwaysAsList));
    }

    @Override
    protected ParamInjector evalInjector(Type type, Param param) {
        if (param == null || "..".equals(param.value())) {
            Class<?> clazz = Lang.getTypeClass(type);
            if (clazz != null && AdaptorErrorContext.class.isAssignableFrom(clazz)) {
                return new VoidInjector();
            }
            return new XmlInjector(type, null);
        }
        return super.evalInjector(type, param);
    }

    @Override
    public Object getReferObject(ServletContext sc, HttpServletRequest req, HttpServletResponse resp, String[] pathArgs) {
        try {
            return Xmls.xmlToMap((InputStream)req.getInputStream(), this.lowerFirst, this.dupAsList, this.alwaysAsList);
        }
        catch (Exception e) {
            throw Lang.wrapThrow(e);
        }
    }
}

