/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.el.opt.custom;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nutz.conf.NutConf;
import org.nutz.el.ElException;
import org.nutz.el.opt.RunMethod;
import org.nutz.lang.Mirror;
import org.nutz.plugin.SimplePluginManager;

public class CustomMake {
    protected Map<String, RunMethod> runms = new HashMap<String, RunMethod>();
    protected static CustomMake me = new CustomMake();

    public CustomMake init() {
        List plug = (List)((Map)NutConf.get("EL")).get("custom");
        String[] t = plug.toArray(new String[0]);
        SimplePluginManager rm = new SimplePluginManager(t);
        for (RunMethod r : rm.gets()) {
            CustomMake.me().runms.put(r.fetchSelf(), r);
        }
        return this;
    }

    public RunMethod make(String val) {
        return this.runms.get(val);
    }

    public static CustomMake me() {
        return me;
    }

    public void register(String name, RunMethod run) {
        this.runms.put(name, run);
    }

    public void register(String name, Method method) {
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new ElException("must be static method");
        }
        this.runms.put(name, new StaticMethodRunMethod(method));
    }

    static {
        me.init();
    }

    public static class StaticMethodRunMethod
    implements RunMethod {
        protected Method method;

        public StaticMethodRunMethod(Method method) {
            this.method = method;
        }

        @Override
        public Object run(List<Object> fetchParam) {
            return Mirror.me(this.method.getDeclaringClass()).invoke(null, this.method.getName(), fetchParam.toArray());
        }

        @Override
        public String fetchSelf() {
            return "custom method invoke";
        }
    }
}

