/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.aop;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.nutz.aop.AopCallback;
import org.nutz.aop.MethodInterceptor;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class InterceptorChain {
    protected Method callingMethod;
    protected int methodIndex;
    protected Object[] args;
    protected AopCallback callingObj;
    protected Object returnValue;
    protected List<MethodInterceptor> miList;
    private static Log log = Logs.get();
    private boolean invoked = false;
    private int currentMI = 0;

    public InterceptorChain(int methodIndex, Object obj, Method method, List<MethodInterceptor> miList, Object[] args) {
        this.methodIndex = methodIndex;
        this.callingObj = (AopCallback)obj;
        this.callingMethod = method;
        this.args = args;
        this.miList = miList;
    }

    public InterceptorChain doChain() throws Throwable {
        if (this.currentMI == this.miList.size()) {
            this.invoke();
        } else {
            ++this.currentMI;
            this.miList.get(this.currentMI - 1).filter(this);
        }
        return this;
    }

    public void invoke() throws Throwable {
        if (this.invoked) {
            log.warnf("!! Calling Method more than once! Method --> %s", this.callingMethod.toString());
        } else {
            this.invoked = true;
        }
        this.returnValue = this.callingObj._aop_invoke(this.methodIndex, this.args);
    }

    public Object getReturn() {
        return this.returnValue;
    }

    public Method getCallingMethod() {
        return this.callingMethod;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public void setReturnValue(Object returnValue) {
        this.returnValue = returnValue;
    }

    public AopCallback getCallingObj() {
        return this.callingObj;
    }

    public boolean isInvoked() {
        return this.invoked;
    }

    public List<MethodInterceptor> getMethodInterceptors() {
        return Collections.unmodifiableList(this.miList);
    }

    public void setMethodInterceptors(List<MethodInterceptor> miList) {
        this.miList = miList;
    }
}

