/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.app.config;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.rocketmq.acl.common.AclClientRPCHook;
import org.apache.rocketmq.acl.common.SessionCredentials;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.remoting.RPCHook;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MqConfig {
    @NacosValue(value="${rocket.mq.srvAddr}")
    private String namesrvAddr;
    @NacosValue(value="${rocketmq.ak}")
    private String ak;
    @NacosValue(value="${rocketmq.sk}")
    private String sk;

    @Bean(value={"defaultMQProducer"})
    public DefaultMQProducer defaultMQProducer() throws MQClientException {
        if (StringUtils.isNotEmpty((String)this.ak) && StringUtils.isNotEmpty((String)this.sk)) {
            SessionCredentials credentials = new SessionCredentials(this.ak, this.sk);
            AclClientRPCHook rpcHook = new AclClientRPCHook(credentials);
            DefaultMQProducer producer = new DefaultMQProducer("heraAppModify", (RPCHook)rpcHook);
            producer.setNamesrvAddr(this.namesrvAddr);
            producer.start();
            return producer;
        }
        DefaultMQProducer producer = new DefaultMQProducer("heraAppModify");
        producer.setNamesrvAddr(this.namesrvAddr);
        producer.start();
        return producer;
    }
}

