/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.util;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.hugegraph.driver.HugeClient;
import org.apache.hugegraph.entity.GraphConnection;
import org.apache.hugegraph.exception.ExternalException;
import org.apache.hugegraph.exception.ServerException;
import org.apache.hugegraph.rest.ClientException;
import org.apache.hugegraph.structure.gremlin.Result;
import org.apache.hugegraph.structure.gremlin.ResultSet;
import org.springframework.web.util.UriComponentsBuilder;

public final class HugeClientUtil {
    private static final String DEFAULT_PROTOCOL = "http";
    private static final Set<String> ACCEPTABLE_EXCEPTIONS = ImmutableSet.of((Object)"Permission denied: execute Resource");

    public static HugeClient tryConnect(GraphConnection connection) {
        HugeClient client;
        String graph = connection.getGraph();
        String host = connection.getHost();
        Integer port = connection.getPort();
        String username = connection.getUsername();
        String password = connection.getPassword();
        int timeout = connection.getTimeout();
        String protocol = connection.getProtocol() == null ? DEFAULT_PROTOCOL : connection.getProtocol();
        String trustStoreFile = connection.getTrustStoreFile();
        String trustStorePassword = connection.getTrustStorePassword();
        String url = UriComponentsBuilder.newInstance().scheme(protocol).host(host).port(port.intValue()).toUriString();
        if (username == null) {
            username = "";
            password = "";
        }
        try {
            client = HugeClient.builder((String)url, (String)graph).configUser(username, password).configTimeout(timeout).configSSL(trustStoreFile, trustStorePassword).build();
        }
        catch (IllegalStateException e) {
            String message = e.getMessage();
            if (message != null && message.startsWith("The version")) {
                throw new ExternalException("client-server.version.unmatched", (Throwable)e, new Object[0]);
            }
            if (message != null && (message.startsWith("Error loading trust store from") || message.startsWith("Cannot find trust store file"))) {
                throw new ExternalException("https.load.truststore.error", (Throwable)e, new Object[0]);
            }
            throw e;
        }
        catch (ServerException e) {
            String message = e.getMessage();
            if (401 == e.status() || message != null && message.startsWith("Authentication")) {
                throw new ExternalException("graph-connection.username-or-password.incorrect", (Throwable)e, new Object[0]);
            }
            if (message != null && message.contains("Invalid syntax for username and password")) {
                throw new ExternalException("graph-connection.missing-username-password", (Throwable)e, new Object[0]);
            }
            throw e;
        }
        catch (ClientException e) {
            Throwable cause = e.getCause();
            if (cause == null || cause.getMessage() == null) {
                throw e;
            }
            String message = cause.getMessage();
            if (message.contains("Connection refused")) {
                throw new ExternalException("service.unavailable", (Throwable)e, host, port);
            }
            if (message.contains("java.net.UnknownHostException") || message.contains("Host name may not be null")) {
                throw new ExternalException("service.unknown-host", (Throwable)e, host);
            }
            if (message.contains("<!doctype html>")) {
                throw new ExternalException("service.suspected-web", (Throwable)e, host, port);
            }
            throw e;
        }
        try {
            ResultSet rs = client.gremlin().gremlin("g.V().limit(1)").execute();
            rs.iterator().forEachRemaining(Result::getObject);
        }
        catch (ServerException e) {
            if (401 == e.status()) {
                throw new ExternalException("graph-connection.username-or-password.incorrect", (Throwable)e, new Object[0]);
            }
            String message = e.message();
            if (message != null && message.contains("Could not rebind [g]")) {
                throw new ExternalException("graph-connection.graph.unexist", (Throwable)e, graph, host, port);
            }
            if (!HugeClientUtil.isAcceptable(message)) {
                throw e;
            }
        }
        catch (Exception e) {
            client.close();
            throw e;
        }
        return client;
    }

    private static boolean isAcceptable(String message) {
        if (message == null) {
            return false;
        }
        for (String acceptableMessage : ACCEPTABLE_EXCEPTIONS) {
            if (!message.contains(acceptableMessage)) continue;
            return true;
        }
        return false;
    }
}

