/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.common;

import org.apache.hugegraph.computer.core.allocator.Allocator;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.graph.GraphFactory;
import org.apache.hugegraph.util.E;

public final class ComputerContext {
    private static volatile ComputerContext INSTANCE;
    private final Config config;
    private final GraphFactory graphFactory;
    private final Allocator allocator;

    private ComputerContext(Config config, GraphFactory graphFactory, Allocator allocator) {
        this.config = config;
        this.graphFactory = graphFactory;
        this.allocator = allocator;
    }

    public static synchronized void initContext(Config config, GraphFactory graphFactory, Allocator allocator) {
        INSTANCE = new ComputerContext(config, graphFactory, allocator);
    }

    public static ComputerContext instance() {
        E.checkNotNull((Object)INSTANCE, (String)"ComputerContext INSTANCE");
        return INSTANCE;
    }

    public Config config() {
        return this.config;
    }

    public GraphFactory graphFactory() {
        return this.graphFactory;
    }

    public Allocator allocator() {
        return this.allocator;
    }
}

