/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.input.hg;

import org.apache.hugegraph.computer.core.config.ComputerOptions;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.input.EdgeFetcher;
import org.apache.hugegraph.computer.core.input.GraphFetcher;
import org.apache.hugegraph.computer.core.input.InputSplit;
import org.apache.hugegraph.computer.core.input.VertexFetcher;
import org.apache.hugegraph.computer.core.input.hg.HugeEdgeFetcher;
import org.apache.hugegraph.computer.core.input.hg.HugeVertexFetcher;
import org.apache.hugegraph.computer.core.rpc.InputSplitRpcService;
import org.apache.hugegraph.config.TypedOption;
import org.apache.hugegraph.driver.HugeClient;
import org.apache.hugegraph.driver.HugeClientBuilder;

public class HugeGraphFetcher
implements GraphFetcher {
    private final HugeClient client;
    private final VertexFetcher vertexFetcher;
    private final EdgeFetcher edgeFetcher;
    private final InputSplitRpcService rpcService;

    public HugeGraphFetcher(Config config, InputSplitRpcService rpcService) {
        String url = (String)config.get((TypedOption)ComputerOptions.HUGEGRAPH_URL);
        String graph = (String)config.get((TypedOption)ComputerOptions.HUGEGRAPH_GRAPH_NAME);
        this.client = new HugeClientBuilder(url, graph).build();
        this.vertexFetcher = new HugeVertexFetcher(config, this.client);
        this.edgeFetcher = new HugeEdgeFetcher(config, this.client);
        this.rpcService = rpcService;
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public VertexFetcher vertexFetcher() {
        return this.vertexFetcher;
    }

    @Override
    public EdgeFetcher edgeFetcher() {
        return this.edgeFetcher;
    }

    @Override
    public InputSplit nextVertexInputSplit() {
        return this.rpcService.nextVertexInputSplit();
    }

    @Override
    public InputSplit nextEdgeInputSplit() {
        return this.rpcService.nextEdgeInputSplit();
    }
}

