/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.docs;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.server.docs.ContainerTypeSignature;
import com.linecorp.armeria.server.docs.DefaultTypeSignature;
import com.linecorp.armeria.server.docs.DescriptiveTypeSignature;
import com.linecorp.armeria.server.docs.MapTypeSignature;
import com.linecorp.armeria.server.docs.TypeSignatureJsonSerializer;
import com.linecorp.armeria.server.docs.TypeSignatureType;
import java.util.Objects;

@JsonSerialize(using=TypeSignatureJsonSerializer.class)
@UnstableApi
public interface TypeSignature {
    public static TypeSignature ofBase(String baseTypeName) {
        DefaultTypeSignature.checkBaseTypeName(baseTypeName, "baseTypeName");
        return new DefaultTypeSignature(TypeSignatureType.BASE, baseTypeName);
    }

    public static ContainerTypeSignature ofContainer(String containerTypeName, TypeSignature ... elementTypeSignatures) {
        Objects.requireNonNull(elementTypeSignatures, "elementTypeSignatures");
        return TypeSignature.ofContainer(containerTypeName, ImmutableList.copyOf(elementTypeSignatures));
    }

    public static ContainerTypeSignature ofContainer(String containerTypeName, Iterable<TypeSignature> elementTypeSignatures) {
        DefaultTypeSignature.checkBaseTypeName(containerTypeName, "containerTypeName");
        Objects.requireNonNull(elementTypeSignatures, "elementTypeSignatures");
        return new ContainerTypeSignature(TypeSignatureType.CONTAINER, containerTypeName, ImmutableList.copyOf(elementTypeSignatures));
    }

    public static ContainerTypeSignature ofList(TypeSignature elementTypeSignature) {
        Objects.requireNonNull(elementTypeSignature, "elementTypeSignature");
        return TypeSignature.ofIterable("list", elementTypeSignature);
    }

    public static ContainerTypeSignature ofSet(TypeSignature elementTypeSignature) {
        Objects.requireNonNull(elementTypeSignature, "elementTypeSignature");
        return TypeSignature.ofIterable("set", elementTypeSignature);
    }

    public static ContainerTypeSignature ofIterable(String iterableTypeName, TypeSignature elementTypeSignature) {
        Objects.requireNonNull(iterableTypeName, "iterableTypeName");
        Objects.requireNonNull(elementTypeSignature, "elementTypeSignature");
        return new ContainerTypeSignature(TypeSignatureType.ITERABLE, iterableTypeName, ImmutableList.of(elementTypeSignature));
    }

    public static MapTypeSignature ofMap(TypeSignature keyTypeSignature, TypeSignature valueTypeSignature) {
        Objects.requireNonNull(keyTypeSignature, "keyTypeSignature");
        Objects.requireNonNull(valueTypeSignature, "valueTypeSignature");
        return new MapTypeSignature(keyTypeSignature, valueTypeSignature);
    }

    public static ContainerTypeSignature ofOptional(TypeSignature elementTypeSignature) {
        Objects.requireNonNull(elementTypeSignature, "elementTypeSignature");
        return new ContainerTypeSignature(TypeSignatureType.OPTIONAL, "optional", ImmutableList.of(elementTypeSignature));
    }

    public static DescriptiveTypeSignature ofStruct(Class<?> structType) {
        Objects.requireNonNull(structType, "structType");
        return new DescriptiveTypeSignature(TypeSignatureType.STRUCT, structType);
    }

    public static DescriptiveTypeSignature ofStruct(String name, Object typeDescriptor) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(typeDescriptor, "typeDescriptor");
        return new DescriptiveTypeSignature(TypeSignatureType.STRUCT, name, typeDescriptor);
    }

    public static DescriptiveTypeSignature ofEnum(Class<?> enumType) {
        Objects.requireNonNull(enumType, "enumType");
        return new DescriptiveTypeSignature(TypeSignatureType.ENUM, enumType);
    }

    public static DescriptiveTypeSignature ofEnum(String name, Object enumTypeDescriptor) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(enumTypeDescriptor, "enumTypeDescriptor");
        return new DescriptiveTypeSignature(TypeSignatureType.ENUM, name, enumTypeDescriptor);
    }

    public static TypeSignature ofUnresolved(String unresolvedTypeName) {
        Objects.requireNonNull(unresolvedTypeName, "unresolvedTypeName");
        return new DefaultTypeSignature(TypeSignatureType.UNRESOLVED, '?' + unresolvedTypeName);
    }

    public TypeSignatureType type();

    public String name();

    default public String signature() {
        return this.name();
    }
}

