/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid.j2d;

import java.awt.Point;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.apache.sis.coverage.grid.j2d.ColorModelFactory;
import org.apache.sis.coverage.grid.j2d.ObservableImage;
import org.apache.sis.feature.internal.Resources;
import org.apache.sis.image.DataType;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Static;
import org.apache.sis.util.collection.WeakHashSet;

public final class RasterFactory
extends Static {
    private static final WeakHashSet<SampleModel> POOL = new WeakHashSet(SampleModel.class);

    private RasterFactory() {
    }

    public static BufferedImage createGrayScaleImage(int dataType, int width, int height, int numComponents, int visibleBand, double minimum, double maximum) {
        switch (dataType) {
            case 0: 
            case 1: {
                if (numComponents != 1 || !ColorModelFactory.isStandardRange(dataType, minimum, maximum)) break;
                return new ObservableImage(width, height, dataType == 0 ? 10 : 11);
            }
        }
        ColorModel cm = ColorModelFactory.createGrayScale(dataType, numComponents, visibleBand, minimum, maximum);
        return new ObservableImage(cm, cm.createCompatibleWritableRaster(width, height), false, null);
    }

    public static WritableRaster createRaster(DataBuffer buffer, int width, int height, int pixelStride, int scanlineStride, int[] bankIndices, int[] bandOffsets, Point location) {
        ComponentSampleModel model;
        int dataType = buffer.getDataType();
        if (buffer.getNumBanks() == 1 && (bankIndices == null || bankIndices[0] == 0)) {
            switch (dataType) {
                case 0: 
                case 1: {
                    return WritableRaster.createInterleavedRaster(buffer, width, height, scanlineStride, pixelStride, bandOffsets, location);
                }
                case 3: {
                    if (bandOffsets.length != 1 || pixelStride != 1) break;
                    return WritableRaster.createBandedRaster(buffer, width, height, scanlineStride, new int[1], bandOffsets, location);
                }
            }
            model = new PixelInterleavedSampleModel(dataType, width, height, pixelStride, scanlineStride, bandOffsets);
        } else {
            if (bankIndices == null) {
                bankIndices = ArraysExt.range((int)0, (int)bandOffsets.length);
            }
            if (pixelStride == 1) {
                switch (dataType) {
                    case 0: 
                    case 1: 
                    case 3: {
                        return WritableRaster.createBandedRaster(buffer, width, height, scanlineStride, bankIndices, bandOffsets, location);
                    }
                }
                model = new BandedSampleModel(dataType, width, height, scanlineStride, bankIndices, bandOffsets);
            } else {
                model = new ComponentSampleModel(dataType, width, height, pixelStride, scanlineStride, bankIndices, bandOffsets);
            }
        }
        return WritableRaster.createWritableRaster(RasterFactory.unique(model), buffer, location);
    }

    public static Buffer createBuffer(DataType dataType, int capacity) {
        switch (dataType) {
            case USHORT: 
            case SHORT: {
                return ShortBuffer.allocate(capacity);
            }
            case BYTE: {
                return ByteBuffer.allocate(capacity);
            }
            case INT: {
                return IntBuffer.allocate(capacity);
            }
            case FLOAT: {
                return FloatBuffer.allocate(capacity);
            }
            case DOUBLE: {
                return DoubleBuffer.allocate(capacity);
            }
        }
        throw new AssertionError((Object)dataType);
    }

    public static Buffer createBuffer(DataBuffer data, int bank) {
        Buffer buffer;
        switch (data.getDataType()) {
            case 0: {
                buffer = ByteBuffer.wrap(((DataBufferByte)data).getData(bank));
                break;
            }
            case 1: {
                buffer = ShortBuffer.wrap(((DataBufferUShort)data).getData(bank));
                break;
            }
            case 2: {
                buffer = ShortBuffer.wrap(((DataBufferShort)data).getData(bank));
                break;
            }
            case 3: {
                buffer = IntBuffer.wrap(((DataBufferInt)data).getData(bank));
                break;
            }
            case 4: {
                buffer = FloatBuffer.wrap(((DataBufferFloat)data).getData(bank));
                break;
            }
            case 5: {
                buffer = DoubleBuffer.wrap(((DataBufferDouble)data).getData(bank));
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        int lower = data.getOffsets()[bank];
        int upper = lower + data.getSize();
        if (lower != 0 || upper != buffer.capacity()) {
            buffer.position(lower).limit(upper).slice();
        }
        return buffer;
    }

    public static DataBuffer wrap(DataType dataType, Buffer ... data) {
        Object arrays;
        int numBands = data.length;
        switch (dataType) {
            case USHORT: 
            case SHORT: {
                arrays = new short[numBands][];
                break;
            }
            case INT: {
                arrays = new int[numBands][];
                break;
            }
            case BYTE: {
                arrays = new byte[numBands][];
                break;
            }
            case FLOAT: {
                arrays = new float[numBands][];
                break;
            }
            case DOUBLE: {
                arrays = new double[numBands][];
                break;
            }
            default: {
                throw new AssertionError((Object)dataType);
            }
        }
        int[] offsets = new int[numBands];
        int length = 0;
        for (int i = 0; i < numBands; ++i) {
            Buffer buffer = data[i];
            ArgumentChecks.ensureNonNullElement((String)"data", (int)i, (Object)buffer);
            arrays[i] = (short[])buffer.array();
            offsets[i] = Math.addExact(buffer.arrayOffset(), buffer.position());
            int r = buffer.remaining();
            if (i == 0) {
                length = r;
                continue;
            }
            if (length == r) continue;
            throw new RasterFormatException(Resources.format((short)41));
        }
        switch (dataType) {
            case BYTE: {
                return new DataBufferByte((byte[][])arrays, length, offsets);
            }
            case SHORT: {
                return new DataBufferShort((short[][])arrays, length, offsets);
            }
            case USHORT: {
                return new DataBufferUShort((short[][])arrays, length, offsets);
            }
            case INT: {
                return new DataBufferInt((int[][])arrays, length, offsets);
            }
            case FLOAT: {
                return new DataBufferFloat((float[][])arrays, length, offsets);
            }
            case DOUBLE: {
                return new DataBufferDouble((double[][])arrays, length, offsets);
            }
        }
        throw new AssertionError((Object)dataType);
    }

    static <T extends SampleModel> T unique(T sampleModel) {
        return (T)((SampleModel)POOL.unique(sampleModel));
    }
}

