/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.storage.logit.storage.file.index;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.util.GridUnsafe;
import org.apache.ignite3.raft.jraft.option.RaftOptions;
import org.apache.ignite3.raft.jraft.storage.logit.storage.file.AbstractFile;
import org.apache.ignite3.raft.jraft.storage.logit.storage.file.index.IndexType;
import org.apache.ignite3.raft.jraft.util.Bits;

public class IndexFile
extends AbstractFile {
    private static final IgniteLogger LOG = Loggers.forClass(IndexFile.class);
    public static final byte[] RECORD_MAGIC_BYTES = new byte[]{87};
    public static final int RECORD_MAGIC_BYTES_SIZE = RECORD_MAGIC_BYTES.length;

    public IndexFile(RaftOptions raftOptions, String filePath, int fileSize) {
        super(raftOptions, filePath, fileSize, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int appendIndex(long logIndex, int position, byte logType) {
        this.writeLock.lock();
        try {
            assert (logIndex > this.getLastLogIndex());
            int n = this.doAppend(logIndex, addr -> {
                GridUnsafe.putByte(addr, RECORD_MAGIC_BYTES[0]);
                GridUnsafe.putByte(addr + 1L, logType);
                Bits.putIntLittleEndian(addr + 2L, this.toRelativeOffset(logIndex));
                Bits.putIntLittleEndian(addr + 6L, position);
                return this.getIndexSize();
            });
            return n;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexEntry lookupIndex(long logIndex) {
        this.mapInIfNecessary();
        this.readLock.lock();
        try {
            ByteBuffer byteBuffer = this.sliceByteBuffer();
            int slot = (int)(logIndex - this.header.getFirstLogIndex());
            if (slot < 0) {
                IndexEntry indexEntry = IndexEntry.newInstance();
                return indexEntry;
            }
            IndexEntry indexEntry = this.parseEntry(byteBuffer, slot);
            return indexEntry;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public AbstractFile.CheckDataResult checkData(ByteBuffer buffer) {
        if (buffer.remaining() < RECORD_MAGIC_BYTES_SIZE) {
            return AbstractFile.CheckDataResult.CHECK_FAIL;
        }
        byte[] magic = new byte[RECORD_MAGIC_BYTES_SIZE];
        buffer.get(magic);
        if (!Arrays.equals(magic, RECORD_MAGIC_BYTES)) {
            return AbstractFile.CheckDataResult.FILE_END;
        }
        byte indexType = buffer.get();
        if (indexType != IndexType.IndexSegment.getType() && indexType != IndexType.IndexConf.getType()) {
            return AbstractFile.CheckDataResult.CHECK_FAIL;
        }
        if (buffer.remaining() < this.getIndexSize() - RECORD_MAGIC_BYTES_SIZE - 1) {
            return AbstractFile.CheckDataResult.CHECK_FAIL;
        }
        return new AbstractFile.CheckDataResult(this.getIndexSize());
    }

    @Override
    public void onRecoverDone(int recoverPosition) {
        int indexNum = (recoverPosition - this.header.getHeaderSize()) / 10;
        this.header.setLastLogIndex(this.header.getFirstLogIndex() + (long)indexNum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int truncate(long logIndex, int pos) {
        this.writeLock.lock();
        try {
            if (logIndex < this.header.getFirstLogIndex() || logIndex > this.header.getLastLogIndex()) {
                int n = 0;
                return n;
            }
            int slot = (int)(logIndex - this.header.getFirstLogIndex());
            int n = this.truncateToSlot(slot);
            return n;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int truncateToSlot(int slot) {
        this.writeLock.lock();
        try {
            this.header.setLastLogIndex(this.header.getFirstLogIndex() + (long)slot - 1L);
            int lastPos = this.header.getHeaderSize() + slot * this.getIndexSize();
            this.updateAllPosition(lastPos);
            this.clear(this.getWrotePosition());
            int n = lastPos;
            return n;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private IndexEntry parseEntry(ByteBuffer buffer, int n) {
        int pos = this.header.getHeaderSize() + n * this.getIndexSize();
        buffer.position(pos);
        IndexEntry indexEntry = IndexEntry.newInstance();
        indexEntry.decode(buffer);
        return indexEntry;
    }

    private int toRelativeOffset(long offset) {
        if (this.header.isBlank()) {
            return 0;
        }
        return (int)(offset - this.header.getFirstLogIndex());
    }

    public int calculateIndexPos(long logIndex) {
        return (int)((long)this.header.getHeaderSize() + (logIndex - this.getFirstLogIndex() + 1L) * (long)this.getIndexSize());
    }

    public int getIndexSize() {
        return 10;
    }

    public static class IndexEntry {
        private long logIndex;
        private int offset;
        private int position;
        private byte logType;
        public static final int INDEX_SIZE = 10;

        public IndexEntry(long logIndex, int position, byte logType) {
            this(logIndex, 0, position, logType);
        }

        public IndexEntry(int offset, int position) {
            this(0L, offset, position, IndexType.IndexSegment.getType());
        }

        public IndexEntry(long logIndex, int offset, int position, byte logType) {
            this.logIndex = logIndex;
            this.offset = offset;
            this.position = position;
            this.logType = logType;
        }

        public static IndexEntry newInstance() {
            return new IndexEntry(-1, -1);
        }

        public void setLogIndex(long logIndex) {
            this.logIndex = logIndex;
        }

        public long getLogIndex() {
            return this.logIndex;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getPosition() {
            return this.position;
        }

        public byte getLogType() {
            return this.logType;
        }

        public boolean decode(ByteBuffer buffer) {
            if (buffer == null || buffer.remaining() < 10) {
                LOG.error("Fail to decode index entry , invalid buffer length: {}", buffer == null ? 0 : buffer.remaining());
                return false;
            }
            byte[] magic = new byte[1];
            buffer.get(magic);
            if (!Arrays.equals(magic, RECORD_MAGIC_BYTES)) {
                LOG.error("Fail to decode index entry, invalid buffer magic", new Object[0]);
                return false;
            }
            this.logType = buffer.get();
            this.offset = buffer.getInt();
            this.position = buffer.getInt();
            return true;
        }

        public String toString() {
            return "IndexEntry{logIndex=" + this.logIndex + ", offset=" + this.offset + ", position=" + this.position + ", logType=" + this.logType + "}";
        }
    }
}

