/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.util.Static;
import org.apache.ignite3.internal.components.NodeProperties;
import org.apache.ignite3.internal.hlc.ClockService;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite3.internal.partition.replicator.network.replication.ReadWriteMultiRowPkReplicaRequest;
import org.apache.ignite3.internal.partition.replicator.network.replication.ReadWriteMultiRowReplicaRequest;
import org.apache.ignite3.internal.partition.replicator.network.replication.RequestType;
import org.apache.ignite3.internal.replicator.ReplicaService;
import org.apache.ignite3.internal.replicator.ReplicationGroupId;
import org.apache.ignite3.internal.replicator.TablePartitionId;
import org.apache.ignite3.internal.replicator.ZonePartitionId;
import org.apache.ignite3.internal.replicator.message.ReplicaMessageUtils;
import org.apache.ignite3.internal.replicator.message.ReplicaMessagesFactory;
import org.apache.ignite3.internal.replicator.message.ReplicaRequest;
import org.apache.ignite3.internal.replicator.message.ReplicationGroupIdMessage;
import org.apache.ignite3.internal.schema.BinaryRow;
import org.apache.ignite3.internal.schema.BinaryRowEx;
import org.apache.ignite3.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite3.internal.sql.engine.exec.NodeWithConsistencyToken;
import org.apache.ignite3.internal.sql.engine.exec.RowHandler;
import org.apache.ignite3.internal.sql.engine.exec.TableRowConverter;
import org.apache.ignite3.internal.sql.engine.exec.TxAttributes;
import org.apache.ignite3.internal.sql.engine.exec.UpdatableTable;
import org.apache.ignite3.internal.sql.engine.exec.mapping.ColocationGroup;
import org.apache.ignite3.internal.sql.engine.exec.row.RowSchema;
import org.apache.ignite3.internal.sql.engine.prepare.IgniteSqlValidatorErrorMessages;
import org.apache.ignite3.internal.sql.engine.schema.ColumnDescriptor;
import org.apache.ignite3.internal.sql.engine.schema.TableDescriptor;
import org.apache.ignite3.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite3.internal.sql.engine.util.RowTypeUtils;
import org.apache.ignite3.internal.sql.engine.util.TypeUtils;
import org.apache.ignite3.internal.table.InternalTable;
import org.apache.ignite3.internal.table.distributed.storage.InternalTableImpl;
import org.apache.ignite3.internal.table.distributed.storage.RowBatch;
import org.apache.ignite3.internal.tx.InternalTransaction;
import org.apache.ignite3.internal.util.CollectionUtils;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.sql.SqlException;
import org.jetbrains.annotations.Nullable;

public final class UpdatableTableImpl
implements UpdatableTable {
    private static final IgniteLogger LOG = Loggers.forClass(UpdatableTableImpl.class);
    private static final PartitionReplicationMessagesFactory PARTITION_REPLICATION_MESSAGES_FACTORY = new PartitionReplicationMessagesFactory();
    private static final ReplicaMessagesFactory REPLICA_MESSAGES_FACTORY = new ReplicaMessagesFactory();
    private final int tableId;
    private final int zoneId;
    private final TableDescriptor desc;
    private final ClockService clockService;
    private final NodeProperties nodeProperties;
    private final InternalTable table;
    private final ReplicaService replicaService;
    private final PartitionExtractor partitionExtractor;
    private final TableRowConverter rowConverter;
    private RowSchema rowSchema;

    UpdatableTableImpl(int tableId, int zoneId, TableDescriptor desc, int partitions, InternalTable table, ReplicaService replicaService, ClockService clockService, NodeProperties nodeProperties, TableRowConverter rowConverter) {
        this.tableId = tableId;
        this.zoneId = zoneId;
        this.table = table;
        this.desc = desc;
        this.replicaService = replicaService;
        this.clockService = clockService;
        this.nodeProperties = nodeProperties;
        this.partitionExtractor = row -> IgniteUtils.safeAbs(row.colocationHash()) % partitions;
        this.rowConverter = rowConverter;
    }

    @Override
    public <RowT> CompletableFuture<?> upsertAll(ExecutionContext<RowT> ectx, List<RowT> rows, ColocationGroup colocationGroup) {
        TxAttributes txAttributes = ectx.txAttributes();
        ReplicationGroupId commitPartitionId = txAttributes.commitPartition();
        assert (commitPartitionId != null);
        this.validateNotNullConstraint(ectx.rowHandler(), (RowT)rows);
        RelDataType rowType = RowTypeUtils.rowType(this.descriptor(), ectx.getTypeFactory());
        Supplier<RowSchema> schemaSupplier = this.makeSchemaSupplier(ectx);
        rows = UpdatableTableImpl.validateCharactersOverflowAndTrimIfPossible(rowType, ectx.rowHandler(), rows, schemaSupplier);
        Int2ObjectOpenHashMap rowsByPartition = new Int2ObjectOpenHashMap();
        for (RowT row : rows) {
            BinaryRowEx binaryRow = this.rowConverter.toFullRow(ectx, row);
            ((List)rowsByPartition.computeIfAbsent(this.partitionExtractor.fromRow(binaryRow), k -> new ArrayList())).add(binaryRow);
        }
        CompletableFuture[] futures = new CompletableFuture[rowsByPartition.size()];
        int batchNum = 0;
        for (Int2ObjectMap.Entry partToRows : rowsByPartition.int2ObjectEntrySet()) {
            ReplicationGroupId partGroupId = this.targetReplicationGroupId(partToRows.getIntKey());
            NodeWithConsistencyToken nodeWithConsistencyToken = (NodeWithConsistencyToken)colocationGroup.assignments().get(partToRows.getIntKey());
            ReadWriteMultiRowReplicaRequest request = PARTITION_REPLICATION_MESSAGES_FACTORY.readWriteMultiRowReplicaRequest().groupId(UpdatableTableImpl.serializeReplicationGroupId(partGroupId)).tableId(this.tableId).commitPartitionId(UpdatableTableImpl.serializeReplicationGroupId(commitPartitionId)).schemaVersion(((BinaryRow)((List)partToRows.getValue()).get(0)).schemaVersion()).binaryTuples(UpdatableTableImpl.binaryRowsToBuffers((Collection)partToRows.getValue())).transactionId(txAttributes.id()).enlistmentConsistencyToken(nodeWithConsistencyToken.enlistmentConsistencyToken()).requestType(RequestType.RW_UPSERT_ALL).timestamp(this.clockService.now()).skipDelayedAck(true).coordinatorId(txAttributes.coordinatorId()).build();
            futures[batchNum++] = this.replicaService.invoke(nodeWithConsistencyToken.name(), (ReplicaRequest)request);
        }
        return CompletableFuture.allOf(futures);
    }

    private static List<ByteBuffer> binaryRowsToBuffers(Collection<BinaryRow> rows) {
        ArrayList<ByteBuffer> result = new ArrayList<ByteBuffer>(rows.size());
        for (BinaryRow row : rows) {
            result.add(row.tupleSlice());
        }
        return result;
    }

    private static List<ByteBuffer> serializePrimaryKeys(Collection<BinaryRow> rows) {
        ArrayList<ByteBuffer> result = new ArrayList<ByteBuffer>(rows.size());
        for (BinaryRow row : rows) {
            result.add(row.tupleSlice());
        }
        return result;
    }

    private ReplicationGroupId targetReplicationGroupId(int partitionId) {
        if (this.nodeProperties.colocationEnabled()) {
            return new ZonePartitionId(this.zoneId, partitionId);
        }
        return new TablePartitionId(this.tableId, partitionId);
    }

    private static ReplicationGroupIdMessage serializeReplicationGroupId(ReplicationGroupId id) {
        return ReplicaMessageUtils.toReplicationGroupIdMessage(REPLICA_MESSAGES_FACTORY, id);
    }

    @Override
    public TableDescriptor descriptor() {
        return this.desc;
    }

    @Override
    public <RowT> CompletableFuture<Void> insert(InternalTransaction tx, ExecutionContext<RowT> ectx, RowT row) {
        assert (tx != null);
        this.validateNotNullConstraint(ectx.rowHandler(), row);
        RelDataType rowType = RowTypeUtils.rowType(this.descriptor(), ectx.getTypeFactory());
        Supplier<RowSchema> schemaSupplier = this.makeSchemaSupplier(ectx);
        Object validatedRow = TypeUtils.validateStringTypesOverflowAndTrimIfPossible(rowType, ectx.rowHandler(), row, schemaSupplier);
        BinaryRowEx tableRow = this.rowConverter.toFullRow(ectx, validatedRow);
        return this.table.insert(tableRow, tx).thenApply(success -> {
            if (success.booleanValue()) {
                return null;
            }
            RowHandler<Object> rowHandler = ectx.rowHandler();
            throw UpdatableTableImpl.conflictKeysException(List.of(rowHandler.toString(validatedRow)));
        });
    }

    @Override
    public <RowT> CompletableFuture<?> insertAll(ExecutionContext<RowT> ectx, List<RowT> rows, ColocationGroup colocationGroup) {
        TxAttributes txAttributes = ectx.txAttributes();
        ReplicationGroupId commitPartitionId = txAttributes.commitPartition();
        this.validateNotNullConstraint(ectx.rowHandler(), (RowT)rows);
        RelDataType rowType = RowTypeUtils.rowType(this.descriptor(), ectx.getTypeFactory());
        Supplier<RowSchema> schemaSupplier = this.makeSchemaSupplier(ectx);
        rows = UpdatableTableImpl.validateCharactersOverflowAndTrimIfPossible(rowType, ectx.rowHandler(), rows, schemaSupplier);
        assert (commitPartitionId != null);
        Int2ObjectMap<RowBatch> rowBatchByPartitionId = this.toRowBatchByPartitionId(ectx, rows);
        for (Int2ObjectMap.Entry partitionRowBatch : rowBatchByPartitionId.int2ObjectEntrySet()) {
            int partitionId = partitionRowBatch.getIntKey();
            RowBatch rowBatch = (RowBatch)partitionRowBatch.getValue();
            ReplicationGroupId partGroupId = this.targetReplicationGroupId(partitionId);
            NodeWithConsistencyToken nodeWithConsistencyToken = (NodeWithConsistencyToken)colocationGroup.assignments().get(partitionId);
            ReadWriteMultiRowReplicaRequest request = PARTITION_REPLICATION_MESSAGES_FACTORY.readWriteMultiRowReplicaRequest().groupId(UpdatableTableImpl.serializeReplicationGroupId(partGroupId)).tableId(this.tableId).commitPartitionId(UpdatableTableImpl.serializeReplicationGroupId(commitPartitionId)).schemaVersion(rowBatch.requestedRows.get(0).schemaVersion()).binaryTuples(UpdatableTableImpl.binaryRowsToBuffers(rowBatch.requestedRows)).transactionId(txAttributes.id()).enlistmentConsistencyToken(nodeWithConsistencyToken.enlistmentConsistencyToken()).requestType(RequestType.RW_INSERT_ALL).timestamp(this.clockService.now()).skipDelayedAck(true).coordinatorId(txAttributes.coordinatorId()).build();
            rowBatch.resultFuture = this.replicaService.invoke(nodeWithConsistencyToken.name(), (ReplicaRequest)request);
        }
        return this.handleInsertResults(ectx, (Collection<RowBatch>)rowBatchByPartitionId.values());
    }

    private <RowT> Int2ObjectMap<RowBatch> toRowBatchByPartitionId(ExecutionContext<RowT> ectx, List<RowT> rows) {
        Int2ObjectOpenHashMap rowBatchByPartitionId = new Int2ObjectOpenHashMap();
        int i = 0;
        for (RowT row : rows) {
            BinaryRowEx binaryRow = this.rowConverter.toFullRow(ectx, row);
            ((RowBatch)rowBatchByPartitionId.computeIfAbsent(this.partitionExtractor.fromRow(binaryRow), partitionId -> new RowBatch())).add(binaryRow, i++);
        }
        return rowBatchByPartitionId;
    }

    @Override
    public <RowT> CompletableFuture<Boolean> delete(@Nullable InternalTransaction explicitTx, ExecutionContext<RowT> ectx, RowT key) {
        assert (explicitTx != null);
        BinaryRowEx keyRow = this.rowConverter.toKeyRow(ectx, key);
        return this.table.delete(keyRow, explicitTx);
    }

    @Override
    public <RowT> CompletableFuture<?> deleteAll(ExecutionContext<RowT> ectx, List<RowT> rows, ColocationGroup colocationGroup) {
        TxAttributes txAttributes = ectx.txAttributes();
        ReplicationGroupId commitPartitionId = txAttributes.commitPartition();
        assert (commitPartitionId != null);
        Int2ObjectOpenHashMap keyRowsByPartition = new Int2ObjectOpenHashMap();
        for (RowT row : rows) {
            BinaryRowEx binaryRow = this.rowConverter.toKeyRow(ectx, row);
            ((List)keyRowsByPartition.computeIfAbsent(this.partitionExtractor.fromRow(binaryRow), k -> new ArrayList())).add(binaryRow);
        }
        CompletableFuture[] futures = new CompletableFuture[keyRowsByPartition.size()];
        int batchNum = 0;
        for (Int2ObjectMap.Entry partToRows : keyRowsByPartition.int2ObjectEntrySet()) {
            ReplicationGroupId partGroupId = this.targetReplicationGroupId(partToRows.getIntKey());
            NodeWithConsistencyToken nodeWithConsistencyToken = (NodeWithConsistencyToken)colocationGroup.assignments().get(partToRows.getIntKey());
            ReadWriteMultiRowPkReplicaRequest request = PARTITION_REPLICATION_MESSAGES_FACTORY.readWriteMultiRowPkReplicaRequest().groupId(UpdatableTableImpl.serializeReplicationGroupId(partGroupId)).tableId(this.tableId).commitPartitionId(UpdatableTableImpl.serializeReplicationGroupId(commitPartitionId)).schemaVersion(((BinaryRow)((List)partToRows.getValue()).get(0)).schemaVersion()).primaryKeys(UpdatableTableImpl.serializePrimaryKeys((Collection)partToRows.getValue())).transactionId(txAttributes.id()).enlistmentConsistencyToken(nodeWithConsistencyToken.enlistmentConsistencyToken()).requestType(RequestType.RW_DELETE_ALL).timestamp(this.clockService.now()).skipDelayedAck(true).coordinatorId(txAttributes.coordinatorId()).build();
            futures[batchNum++] = this.replicaService.invoke(nodeWithConsistencyToken.name(), (ReplicaRequest)request);
        }
        return CompletableFuture.allOf(futures);
    }

    private <RowT> CompletableFuture<List<RowT>> handleInsertResults(ExecutionContext<RowT> ectx, Collection<RowBatch> batches) {
        return InternalTableImpl.collectRejectedRowsResponses(batches).thenApply(response -> {
            if (CollectionUtils.nullOrEmpty(response)) {
                return null;
            }
            RowHandler handler = ectx.rowHandler();
            IgniteTypeFactory typeFactory = ectx.getTypeFactory();
            RowSchema rowSchema = TypeUtils.rowSchemaFromRelTypes(RelOptUtil.getFieldTypeList((RelDataType)RowTypeUtils.rowType(this.desc, typeFactory)));
            RowHandler.RowFactory rowFactory = handler.factory(rowSchema);
            ArrayList<String> conflictRows = new ArrayList<String>(response.size());
            for (BinaryRow row : response) {
                conflictRows.add(handler.toString(this.rowConverter.toRow(ectx, row, rowFactory)));
            }
            throw UpdatableTableImpl.conflictKeysException(conflictRows);
        });
    }

    private static RuntimeException conflictKeysException(List<String> conflictKeys) {
        LOG.debug("Unable to insert rows because of conflict [rows={}]", conflictKeys);
        return new SqlException(ErrorGroups.Sql.CONSTRAINT_VIOLATION_ERR, "PK unique constraint is violated");
    }

    private static <RowT> List<RowT> validateCharactersOverflowAndTrimIfPossible(RelDataType rowType, RowHandler<RowT> rowHandler, List<RowT> rows, Supplier<RowSchema> schemaSupplier) {
        ArrayList<RowT> out = new ArrayList<RowT>(rows.size());
        for (RowT row : rows) {
            out.add(TypeUtils.validateStringTypesOverflowAndTrimIfPossible(rowType, rowHandler, row, schemaSupplier));
        }
        return out;
    }

    private <RowT> void validateNotNullConstraint(RowHandler<RowT> rowHandler, List<RowT> rows) {
        for (RowT row : rows) {
            this.validateNotNullConstraint(rowHandler, row);
        }
    }

    private <RowT> void validateNotNullConstraint(RowHandler<RowT> rowHandler, RowT row) {
        for (int i = 0; i < this.desc.columnsCount(); ++i) {
            ColumnDescriptor column = this.desc.columnDescriptor(i);
            if (column.nullable() || !rowHandler.isNull(i, row)) continue;
            Exception ex = Static.RESOURCE.columnNotNullable(column.name()).ex();
            String originalMessage = ex.getMessage();
            String resolvedMessage = IgniteSqlValidatorErrorMessages.resolveErrorMessage(originalMessage);
            throw new SqlException(ErrorGroups.Sql.CONSTRAINT_VIOLATION_ERR, resolvedMessage != null ? resolvedMessage : originalMessage);
        }
    }

    private <RowT> Supplier<RowSchema> makeSchemaSupplier(ExecutionContext<RowT> ectx) {
        return () -> {
            if (this.rowSchema != null) {
                return this.rowSchema;
            }
            RelDataType rowType = RowTypeUtils.rowType(this.descriptor(), ectx.getTypeFactory());
            this.rowSchema = TypeUtils.rowSchemaFromRelTypes(RelOptUtil.getFieldTypeList((RelDataType)rowType));
            return this.rowSchema;
        };
    }

    @FunctionalInterface
    private static interface PartitionExtractor {
        public int fromRow(BinaryRowEx var1);
    }
}

