/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nullable;

public class NamespaceRelativePathLogInfo {
    @Nullable
    protected final String nsId;
    @Nullable
    protected final String relativePath;
    @Nullable
    protected final Boolean isSharedNamespace;

    public NamespaceRelativePathLogInfo(@Nullable String nsId, @Nullable String relativePath, @Nullable Boolean isSharedNamespace) {
        this.nsId = nsId;
        this.relativePath = relativePath;
        this.isSharedNamespace = isSharedNamespace;
    }

    public NamespaceRelativePathLogInfo() {
        this(null, null, null);
    }

    @Nullable
    public String getNsId() {
        return this.nsId;
    }

    @Nullable
    public String getRelativePath() {
        return this.relativePath;
    }

    @Nullable
    public Boolean getIsSharedNamespace() {
        return this.isSharedNamespace;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.nsId, this.relativePath, this.isSharedNamespace});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            NamespaceRelativePathLogInfo other = (NamespaceRelativePathLogInfo)obj;
            return (this.nsId == other.nsId || this.nsId != null && this.nsId.equals(other.nsId)) && (this.relativePath == other.relativePath || this.relativePath != null && this.relativePath.equals(other.relativePath)) && (this.isSharedNamespace == other.isSharedNamespace || this.isSharedNamespace != null && this.isSharedNamespace.equals(other.isSharedNamespace));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<NamespaceRelativePathLogInfo> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(NamespaceRelativePathLogInfo value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            if (value.nsId != null) {
                g.writeFieldName("ns_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.nsId, g);
            }
            if (value.relativePath != null) {
                g.writeFieldName("relative_path");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.relativePath, g);
            }
            if (value.isSharedNamespace != null) {
                g.writeFieldName("is_shared_namespace");
                StoneSerializers.nullable(StoneSerializers.boolean_()).serialize(value.isSharedNamespace, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public NamespaceRelativePathLogInfo deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Boolean f_isSharedNamespace;
            String f_relativePath;
            String f_nsId;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_nsId = null;
                f_relativePath = null;
                f_isSharedNamespace = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("ns_id".equals(field)) {
                        f_nsId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("relative_path".equals(field)) {
                        f_relativePath = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("is_shared_namespace".equals(field)) {
                        f_isSharedNamespace = StoneSerializers.nullable(StoneSerializers.boolean_()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            NamespaceRelativePathLogInfo value = new NamespaceRelativePathLogInfo(f_nsId, f_relativePath, f_isSharedNamespace);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected String nsId = null;
        protected String relativePath = null;
        protected Boolean isSharedNamespace = null;

        protected Builder() {
        }

        public Builder withNsId(String nsId) {
            this.nsId = nsId;
            return this;
        }

        public Builder withRelativePath(String relativePath) {
            this.relativePath = relativePath;
            return this;
        }

        public Builder withIsSharedNamespace(Boolean isSharedNamespace) {
            this.isSharedNamespace = isSharedNamespace;
            return this;
        }

        public NamespaceRelativePathLogInfo build() {
            return new NamespaceRelativePathLogInfo(this.nsId, this.relativePath, this.isSharedNamespace);
        }
    }
}

