/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util.common;

import java.util.Observable;
import java.util.Observer;
import org.apache.beam.sdk.annotations.Internal;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
public abstract class ElementByteSizeObserver
implements Observer {
    private @UnknownKeyFor @NonNull @Initialized boolean isLazy = false;
    private @UnknownKeyFor @NonNull @Initialized long totalSize = 0L;
    private @UnknownKeyFor @NonNull @Initialized double scalingFactor = 1.0;

    protected abstract void reportElementSize(@UnknownKeyFor @NonNull @Initialized long var1);

    public void setLazy() {
        this.isLazy = true;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean getIsLazy() {
        return this.isLazy;
    }

    public void update(@UnknownKeyFor @NonNull @Initialized Object obj) {
        this.update(null, obj);
    }

    public void setScalingFactor(@UnknownKeyFor @NonNull @Initialized double scalingFactor) {
        this.scalingFactor = scalingFactor;
    }

    @Override
    public void update(@UnknownKeyFor @NonNull @Initialized Observable obs, @UnknownKeyFor @NonNull @Initialized Object obj) {
        if (obj instanceof Long) {
            this.totalSize += (long)(this.scalingFactor * (double)((Long)obj).longValue());
        } else if (obj instanceof Integer) {
            this.totalSize += (long)(this.scalingFactor * (double)((Integer)obj).intValue());
        } else {
            throw new AssertionError((Object)"unexpected parameter object");
        }
    }

    public void advance() {
        this.reportElementSize(this.totalSize);
        this.totalSize = 0L;
        this.isLazy = false;
    }
}

