/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ClientAccessDataStream;
import com.ibm.as400.access.ConverterImplRemote;
import com.ibm.as400.access.DataStreamCompression;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.Trace;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;

class RCCallProgramRequestDataStream
extends ClientAccessDataStream {
    RCCallProgramRequestDataStream(String library, String program, ProgramParameter[] parameterList, ConverterImplRemote converter, int dataStreamLevel, int messageCount) throws CharConversionException {
        int i;
        int dataStreamLength = 43;
        for (i = 0; i < parameterList.length; ++i) {
            byte[] inputData = parameterList[i].getInputData();
            int parameterLength = 0;
            int parameterMaxLength = parameterList[i].getMaxLength();
            int parameterUsage = parameterList[i].getUsage();
            byte[] compressedInputData = null;
            if (parameterUsage == 2) {
                parameterUsage += 20;
            } else {
                if (inputData == null) {
                    inputData = new byte[]{};
                }
                if (parameterMaxLength > 1024) {
                    byte[] tempInputData;
                    if (inputData.length == parameterMaxLength) {
                        tempInputData = inputData;
                    } else {
                        tempInputData = new byte[parameterMaxLength];
                        System.arraycopy(inputData, 0, tempInputData, 0, inputData.length);
                    }
                    compressedInputData = DataStreamCompression.compressRLE(tempInputData, 0, tempInputData.length, (byte)27);
                    if (compressedInputData != null) {
                        parameterLength = compressedInputData.length;
                        parameterUsage += 20;
                    }
                }
            }
            if (parameterUsage < 20) {
                for (parameterLength = inputData.length; parameterLength >= 1 && inputData[parameterLength - 1] == 0; --parameterLength) {
                }
                compressedInputData = inputData;
                parameterUsage = parameterUsage == 3 && dataStreamLevel >= 5 ? (parameterUsage += 30) : (parameterUsage += 10);
            }
            dataStreamLength += 12 + parameterLength;
            parameterList[i].length_ = parameterLength;
            parameterList[i].maxLength_ = parameterMaxLength;
            parameterList[i].usage_ = parameterUsage;
            parameterList[i].compressedInputData_ = compressedInputData;
        }
        this.data_ = new byte[dataStreamLength];
        this.setLength(dataStreamLength);
        this.setServerID(57352);
        this.setTemplateLen(23);
        this.setReqRepID(4099);
        for (i = 0; i < 20; ++i) {
            this.data_[20 + i] = 64;
        }
        converter.stringToByteArray(program, this.data_, 20);
        converter.stringToByteArray(library, this.data_, 30);
        if (dataStreamLevel < 7 && messageCount == 2) {
            messageCount = 0;
        }
        if (dataStreamLevel >= 10 && dataStreamLevel < 11) {
            if (messageCount == 0) {
                messageCount = 3;
            }
            if (messageCount == 2) {
                messageCount = 4;
            }
        }
        if (dataStreamLevel >= 11) {
            if (messageCount == 0) {
                messageCount = 5;
            }
            if (messageCount == 2) {
                messageCount = 6;
            }
        }
        this.data_[40] = (byte)messageCount;
        this.set16bit(parameterList.length, 41);
        int index = 43;
        for (int i2 = 0; i2 < parameterList.length; ++i2) {
            int usage = parameterList[i2].usage_;
            int parameterLength = parameterList[i2].length_;
            this.set32bit(parameterLength + 12, index);
            this.set16bit(4355, index + 4);
            this.set32bit(parameterList[i2].getMaxLength(), index + 6);
            if (usage == 255) {
                if (dataStreamLevel < 6) {
                    this.set16bit(1, index + 10);
                } else {
                    this.set16bit(usage, index + 10);
                }
            } else {
                this.set16bit(usage, index + 10);
                if (parameterLength > 0) {
                    System.arraycopy(parameterList[i2].compressedInputData_, 0, this.data_, index + 12, parameterLength);
                }
            }
            index += 12 + parameterLength;
        }
    }

    @Override
    void write(OutputStream out) throws IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Sending call program request...");
        }
        super.write(out);
    }
}

