/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.EnhancedProfileTokenImplNative;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.NativeMethods;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.SignonConverter;
import com.ibm.as400.access.Trace;
import com.ibm.as400.security.auth.AS400AuthenticationException;
import com.ibm.as400.security.auth.AS400Credential;
import com.ibm.as400.security.auth.DestroyFailedException;
import com.ibm.as400.security.auth.ProfileHandleCredential;
import com.ibm.as400.security.auth.ProfileTokenCredential;
import com.ibm.as400.security.auth.ProfileTokenEnhancedInfo;
import com.ibm.as400.security.auth.ProfileTokenImpl;
import com.ibm.as400.security.auth.RefreshFailedException;
import com.ibm.as400.security.auth.RetrieveFailedException;
import com.ibm.as400.security.auth.SwapFailedException;
import java.beans.PropertyVetoException;
import java.io.IOException;

public class ProfileTokenImplNative
implements ProfileTokenImpl {
    private static final String CLASSNAME = "com.ibm.as400.access.ProfileTokenImplNative";
    private AS400Credential credential_ = null;

    @Override
    public void destroy() throws DestroyFailedException {
        this.nativeRemoveFromSystem(((ProfileTokenCredential)this.getCredential()).getToken());
        this.credential_ = null;
        if (Trace.isTraceOn()) {
            Trace.log(3, "Credential implementation destroyed >> " + this.toString());
        }
    }

    public byte[] generateRawToken(String uid, char[] pwd, int type, int timeoutInterval) throws RetrieveFailedException {
        if (pwd.length > 10) {
            Trace.log(2, "User profile password exceeds allowed length");
            throw new ExtendedIllegalArgumentException("password", 1);
        }
        return this.nativeCreateTokenChar(uid.toUpperCase(), pwd, type, timeoutInterval);
    }

    public byte[] generateRawToken(String uid, int pwdSpecialValue, int type, int timeoutInterval, ProfileTokenEnhancedInfo enhancedInfo) throws AS400AuthenticationException {
        return this.generateRawToken(uid, pwdSpecialValue, 5, type, timeoutInterval, enhancedInfo);
    }

    private byte[] generateRawToken(String uid, int pwdSpecialValue, int authenticationIndicator, int type, int timeoutInterval, ProfileTokenEnhancedInfo enhancedInfo) throws AS400AuthenticationException {
        String pwdSpecialVal;
        switch (pwdSpecialValue) {
            case 1: {
                pwdSpecialVal = "*NOPWD    ";
                break;
            }
            case 2: {
                pwdSpecialVal = "*NOPWDCHK ";
                break;
            }
            default: {
                Trace.log(2, "Password special value = " + pwdSpecialValue + " is not valid.");
                throw new ExtendedIllegalArgumentException("password special value", 2);
            }
        }
        if (Trace.isTraceOn()) {
            Trace.log(1, "ProfileTokenImplNative generating raw profile token w/special value: user=" + uid);
        }
        byte[] token = null;
        if (!ProfileTokenCredential.useEnhancedProfileTokens() || AS400.nativeVRM.getVersionReleaseModification() <= 460032) {
            token = this.nativeCreateTokenChar(uid.toUpperCase(), pwdSpecialVal.toCharArray(), type, timeoutInterval);
            enhancedInfo.setEnhancedTokenCreated(false);
        } else {
            enhancedInfo.ensureRequiredFieldsSet("127.0.0.1");
            token = EnhancedProfileTokenImplNative.nativeCreateTokenSpecialPassword(uid.toUpperCase(), pwdSpecialVal.toCharArray(), null, authenticationIndicator, enhancedInfo.getVerificationID(), enhancedInfo.getRemoteIPAddress(), enhancedInfo.getRemotePort(), enhancedInfo.getLocalIPAddress(), enhancedInfo.getLocalPort(), type, timeoutInterval);
            enhancedInfo.setEnhancedTokenCreated(true);
        }
        if (Trace.isTraceOn()) {
            Trace.log(1, "Raw profile token generated: " + enhancedInfo);
        }
        return token;
    }

    @Override
    public ProfileTokenCredential generateProfileToken(String uid, int pwdSpecialValue, ProfileTokenCredential profileTokenCred) throws PropertyVetoException, AS400AuthenticationException {
        ProfileTokenEnhancedInfo enhancedInfo = new ProfileTokenEnhancedInfo(profileTokenCred.getEnhancedInfo());
        byte[] token = this.generateRawToken(uid, pwdSpecialValue, profileTokenCred.getAuthenticationIndicator(), profileTokenCred.getTokenType(), profileTokenCred.getTimeoutInterval(), enhancedInfo);
        try {
            if (enhancedInfo.isEnhancedProfileToken()) {
                profileTokenCred.setToken(token, enhancedInfo);
            } else {
                profileTokenCred.setToken(token);
            }
            profileTokenCred.setTokenCreator(2);
        }
        catch (PropertyVetoException e) {
            try {
                this.nativeRemoveFromSystem(token);
                this.credential_ = null;
            }
            catch (DestroyFailedException e1) {
                Trace.log(2, "Unexpected Exception during profile token destroy: ", (Throwable)e);
            }
            throw e;
        }
        return profileTokenCred;
    }

    @Override
    public byte[] generateRawTokenExtended(String uid, char[] pwd, char[] additionalAuthenticationFactor, int type, int timeoutInterval, ProfileTokenEnhancedInfo enhancedInfo) throws RetrieveFailedException {
        boolean enhancedProfileToken;
        if (Trace.isTraceOn()) {
            String pwdInfo = "null";
            if (pwd != null) {
                pwdInfo = pwd.length > 0 && (pwd[0] == ' ' || pwd[0] == '\u0000') ? "char[" + pwd.length + "]='0x" + Integer.toHexString(0xFF & pwd[0]) + "....'" : "char[" + pwd.length + "]";
            }
            String aafInfo = "null";
            if (additionalAuthenticationFactor != null) {
                aafInfo = "char[" + additionalAuthenticationFactor.length + "]";
            }
            Trace.log(3, this, "generateRawTokenExtended(" + uid + "," + pwdInfo + "," + aafInfo + "," + enhancedInfo.getVerificationID() + "," + enhancedInfo.getRemoteIPAddress() + "," + enhancedInfo.getRemotePort() + "," + enhancedInfo.getLocalIPAddress() + "," + enhancedInfo.getLocalPort() + "," + type + "," + timeoutInterval + ")");
        }
        AS400 sys = this.getCredential().getSystem();
        boolean useEPT = false;
        try {
            useEPT = ProfileTokenCredential.useEnhancedProfileTokens() && sys.getVRM() > 460032;
        }
        catch (AS400SecurityException | IOException e) {
            Trace.log(2, "Unexpected Exception: ", (Throwable)e);
            throw new RetrieveFailedException();
        }
        ProgramParameter[] parmlist = new ProgramParameter[useEPT ? 19 : 8];
        parmlist[0] = new ProgramParameter(32);
        try {
            parmlist[1] = new ProgramParameter(SignonConverter.stringToByteArray(uid.toUpperCase()));
        }
        catch (AS400SecurityException se) {
            throw new RetrieveFailedException(se.getReturnCode());
        }
        parmlist[2] = new ProgramParameter(BinaryConverter.charArrayToByteArray(pwd));
        parmlist[3] = new ProgramParameter(BinaryConverter.intToByteArray(timeoutInterval));
        parmlist[4] = new ProgramParameter(CharConverter.stringToByteArray(sys, Integer.toString(type)));
        parmlist[5] = new ProgramParameter(BinaryConverter.intToByteArray(0));
        parmlist[6] = new ProgramParameter(BinaryConverter.intToByteArray(parmlist[2].getInputData().length));
        parmlist[7] = new ProgramParameter(BinaryConverter.intToByteArray(13488));
        if (useEPT) {
            boolean isLocalIPNull;
            boolean isAAFNull;
            enhancedInfo.ensureRequiredFieldsSet(sys.getLocalIPAddress());
            boolean bl = isAAFNull = additionalAuthenticationFactor == null || additionalAuthenticationFactor.length == 0;
            if (isAAFNull) {
                additionalAuthenticationFactor = new char[]{' '};
            }
            String remoteIpAddress = enhancedInfo.getRemoteIPAddress();
            String localIpAddress = enhancedInfo.getLocalIPAddress();
            boolean bl2 = isLocalIPNull = localIpAddress == null || localIpAddress.length() == 0;
            if (isLocalIPNull) {
                localIpAddress = "";
                enhancedInfo.setLocalIPAddress(localIpAddress);
            }
            parmlist[8] = new ProgramParameter(BinaryConverter.charArrayToByteArray(additionalAuthenticationFactor));
            parmlist[9] = new ProgramParameter(BinaryConverter.intToByteArray(isAAFNull ? 0 : parmlist[8].getInputData().length));
            parmlist[10] = new ProgramParameter(BinaryConverter.intToByteArray(13488));
            parmlist[11] = new ProgramParameter(BinaryConverter.intToByteArray(0));
            parmlist[12] = new ProgramParameter(CharConverter.stringToByteArray(sys, enhancedInfo.getVerificationID()));
            parmlist[13] = new ProgramParameter(CharConverter.stringToByteArray(sys, remoteIpAddress));
            parmlist[14] = new ProgramParameter(BinaryConverter.intToByteArray(parmlist[13].getInputData().length));
            parmlist[15] = new ProgramParameter(BinaryConverter.intToByteArray(enhancedInfo.getRemotePort()));
            parmlist[16] = new ProgramParameter(CharConverter.stringToByteArray(sys, localIpAddress));
            parmlist[17] = new ProgramParameter(BinaryConverter.intToByteArray(isLocalIPNull ? 0 : parmlist[16].getInputData().length));
            parmlist[18] = new ProgramParameter(BinaryConverter.intToByteArray(enhancedInfo.getRemotePort()));
            Trace.log(3, this, "generateRawTokenExtended creating EnhancedToken with verificationId='" + enhancedInfo.getVerificationID() + "' remoteIp='" + remoteIpAddress + "'");
            enhancedProfileToken = true;
        } else {
            Trace.log(3, this, "generateRawTokenExtended not creating EnhancedToken");
            enhancedProfileToken = false;
        }
        ProgramCall programCall = new ProgramCall(sys);
        try {
            programCall.setProgram(QSYSObjectPathName.toPath("QSYS", "QSYGENPT", "PGM"), parmlist);
            programCall.suggestThreadsafe();
            if (!programCall.run()) {
                Trace.log(2, "Call to QSYGENPT failed.");
                throw new RetrieveFailedException(programCall.getMessageList());
            }
            enhancedInfo.setEnhancedTokenCreated(enhancedProfileToken);
        }
        catch (RetrieveFailedException e) {
            throw e;
        }
        catch (PropertyVetoException | IOException | InterruptedException e) {
            Trace.log(2, "Unexpected Exception: ", (Throwable)e);
            throw new InternalErrorException(10);
        }
        catch (Exception e) {
            Trace.log(2, "Unexpected Exception: ", (Throwable)e);
            throw new RetrieveFailedException();
        }
        byte[] profileToken = parmlist[0].getOutputData();
        if (Trace.isTraceOn()) {
            Trace.log(3, (Object)this, "generateRawTokenExtended returned ", profileToken);
        }
        return profileToken;
    }

    public ProfileTokenCredential generateProfileTokenExtended(String uid, char[] password, ProfileTokenCredential profileTokenCred) throws PropertyVetoException, AS400AuthenticationException {
        return this.generateProfileTokenExtended(uid, password, null, profileTokenCred);
    }

    @Override
    public ProfileTokenCredential generateProfileTokenExtended(String uid, char[] password, char[] additionalAuthenticationFactor, ProfileTokenCredential profileTokenCred) throws PropertyVetoException, AS400AuthenticationException {
        ProfileTokenEnhancedInfo enhancedInfo = profileTokenCred.getEnhancedInfo();
        byte[] token = this.generateRawTokenExtended(uid, password, additionalAuthenticationFactor, profileTokenCred.getTokenType(), profileTokenCred.getTimeoutInterval(), enhancedInfo);
        try {
            profileTokenCred.setToken(token, enhancedInfo);
            profileTokenCred.setTokenCreator(2);
        }
        catch (PropertyVetoException e) {
            try {
                this.nativeRemoveFromSystem(token);
                this.credential_ = null;
            }
            catch (DestroyFailedException e1) {
                Trace.log(2, "Unexpected Exception during profile token destroy: ", (Throwable)e);
            }
            throw e;
        }
        return profileTokenCred;
    }

    AS400Credential getCredential() {
        return this.credential_;
    }

    @Override
    public int getTimeToExpiration() throws RetrieveFailedException {
        byte[] token = ((ProfileTokenCredential)this.getCredential()).getToken();
        if (Trace.isTraceOn()) {
            Trace.log(3, (Object)this, "getTimeToExpiration token=", token);
        }
        int expirationTime = this.nativeGetTimeToExpiration(token);
        if (Trace.isTraceOn()) {
            Trace.log(3, this, "getTimeToExpiration expirationTime=" + expirationTime);
        }
        return expirationTime;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public boolean isCurrent() {
        try {
            return !this.getCredential().isTimed() || this.getTimeToExpiration() > 0;
        }
        catch (RetrieveFailedException e) {
            Trace.log(2, "Unable to retrieve credential time to expiration", (Throwable)e);
            return false;
        }
    }

    @Deprecated
    native byte[] nativeCreateToken(String var1, String var2, int var3, int var4) throws RetrieveFailedException;

    native byte[] nativeCreateTokenChar(String var1, char[] var2, int var3, int var4) throws RetrieveFailedException;

    native int nativeGetTimeToExpiration(byte[] var1) throws RetrieveFailedException;

    native void nativeRefreshToken(byte[] var1, int var2, int var3) throws RefreshFailedException;

    native void nativeRemoveFromSystem(byte[] var1) throws DestroyFailedException;

    native void nativeSwap(byte[] var1) throws SwapFailedException;

    @Override
    public void refresh() throws RefreshFailedException {
        throw new NullPointerException("INVALID CODEPATH");
    }

    @Override
    public byte[] refresh(int type, int timeoutInterval) throws RefreshFailedException {
        if (Trace.isTraceOn()) {
            Trace.log(3, "refresh() called");
        }
        ProfileTokenCredential pt = (ProfileTokenCredential)this.getCredential();
        byte[] token = pt.getToken();
        byte[] bytes = new byte[32];
        System.arraycopy(token, 0, bytes, 0, bytes.length);
        if (!ProfileTokenCredential.useEnhancedProfileTokens() || AS400.nativeVRM.getVersionReleaseModification() <= 460032) {
            if (Trace.isTraceOn()) {
                Trace.log(3, (Object)this, "refresh input", token);
            }
            this.nativeRefreshToken(bytes, type, timeoutInterval);
        } else {
            try {
                if (Trace.isTraceOn()) {
                    Trace.log(3, (Object)this, "calling createTokenFromtoken(bytes," + pt.getVerificationID() + "," + pt.getRemoteIPAddress() + "," + type + "," + timeoutInterval + ")", token);
                }
                bytes = EnhancedProfileTokenImplNative.nativeCreateTokenFromToken(bytes, pt.getVerificationID(), pt.getRemoteIPAddress(), type, timeoutInterval);
            }
            catch (RetrieveFailedException e) {
                RefreshFailedException refreshFailed = new RefreshFailedException(e.getAS400MessageList());
                throw refreshFailed;
            }
        }
        if (Trace.isTraceOn()) {
            Trace.log(3, (Object)this, "refresh output", token);
        }
        return bytes;
    }

    @Override
    public void setCredential(AS400Credential credential) {
        if (credential == null) {
            Trace.log(2, "Parameter 'credential' is null.");
            throw new NullPointerException("credential");
        }
        this.credential_ = credential;
    }

    @Override
    public AS400Credential swap(boolean genRtnCr) throws SwapFailedException {
        ProfileTokenCredential cred;
        ProfileHandleCredential ph = null;
        if (genRtnCr) {
            try {
                ph = new ProfileHandleCredential();
                ph.setSystem(((ProfileTokenCredential)this.getCredential()).getSystem());
                ph.setHandle();
            }
            catch (Exception e) {
                Trace.log(2, "Unable to obtain current profile handle", (Throwable)e);
            }
        }
        if (!(cred = (ProfileTokenCredential)this.getCredential()).isEnhancedProfileToken() || AS400.nativeVRM.getVersionReleaseModification() <= 460032) {
            this.nativeSwap(cred.getToken());
        } else {
            EnhancedProfileTokenImplNative.nativeSwap(cred.getToken(), cred.getVerificationID(), cred.getRemoteIPAddress());
        }
        return ph;
    }

    static {
        if (Trace.traceOn_) {
            Trace.logLoadPath(CLASSNAME);
        }
        NativeMethods.loadNativeLibraryQyjspart();
    }
}

