/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import java.util.HashSet;
import java.util.Map;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.jobmaster.ExecutionDeploymentReconciler;
import org.apache.flink.runtime.jobmaster.ExecutionDeploymentReconciliationHandler;
import org.apache.flink.runtime.jobmaster.ExecutionDeploymentState;
import org.apache.flink.runtime.taskexecutor.ExecutionDeploymentReport;

public class DefaultExecutionDeploymentReconciler
implements ExecutionDeploymentReconciler {
    private final ExecutionDeploymentReconciliationHandler handler;

    public DefaultExecutionDeploymentReconciler(ExecutionDeploymentReconciliationHandler handler) {
        this.handler = handler;
    }

    @Override
    public void reconcileExecutionDeployments(ResourceID taskExecutorHost, ExecutionDeploymentReport executionDeploymentReport, Map<ExecutionAttemptID, ExecutionDeploymentState> expectedDeployedExecutions) {
        HashSet<ExecutionAttemptID> unknownExecutions = new HashSet<ExecutionAttemptID>(executionDeploymentReport.getExecutions());
        HashSet<ExecutionAttemptID> missingExecutions = new HashSet<ExecutionAttemptID>();
        for (Map.Entry<ExecutionAttemptID, ExecutionDeploymentState> execution : expectedDeployedExecutions.entrySet()) {
            boolean deployed = unknownExecutions.remove(execution.getKey());
            if (deployed || execution.getValue() == ExecutionDeploymentState.PENDING) continue;
            missingExecutions.add(execution.getKey());
        }
        if (!unknownExecutions.isEmpty()) {
            this.handler.onUnknownDeploymentsOf(unknownExecutions, taskExecutorHost);
        }
        if (!missingExecutions.isEmpty()) {
            this.handler.onMissingDeploymentsOf(missingExecutions, taskExecutorHost);
        }
    }
}

