/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.action;

import com.google.cloud.Timestamp;
import java.util.Optional;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.ChangeStreamMetrics;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dao.PartitionMetadataDao;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.PartitionMetadata;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.PartitionStartRecord;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.RestrictionInterrupter;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.TimestampRange;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.splittabledofn.ManualWatermarkEstimator;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionStartRecordAction {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(PartitionStartRecordAction.class);
    private final @UnknownKeyFor @NonNull @Initialized PartitionMetadataDao partitionMetadataDao;
    private final @UnknownKeyFor @NonNull @Initialized ChangeStreamMetrics metrics;

    PartitionStartRecordAction(@UnknownKeyFor @NonNull @Initialized PartitionMetadataDao partitionMetadataDao, @UnknownKeyFor @NonNull @Initialized ChangeStreamMetrics metrics) {
        this.partitionMetadataDao = partitionMetadataDao;
        this.metrics = metrics;
    }

    @VisibleForTesting
    public @UnknownKeyFor @NonNull @Initialized Optional<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DoFn.ProcessContinuation> run(@UnknownKeyFor @NonNull @Initialized PartitionMetadata partition, @UnknownKeyFor @NonNull @Initialized PartitionStartRecord record, @UnknownKeyFor @NonNull @Initialized RestrictionTracker<@UnknownKeyFor @NonNull @Initialized TimestampRange, @UnknownKeyFor @NonNull @Initialized Timestamp> tracker, @UnknownKeyFor @NonNull @Initialized RestrictionInterrupter<@UnknownKeyFor @NonNull @Initialized Timestamp> interrupter, @UnknownKeyFor @NonNull @Initialized ManualWatermarkEstimator<@UnknownKeyFor @NonNull @Initialized Instant> watermarkEstimator) {
        String token = partition.getPartitionToken();
        LOG.debug("[{}] Processing partition start record {}", (Object)token, (Object)record);
        Timestamp startTimestamp = record.getStartTimestamp();
        if (interrupter.tryInterrupt(startTimestamp)) {
            LOG.debug("[{}] Soft deadline reached with partition start records at {}, rescheduling", (Object)token, (Object)startTimestamp);
            return Optional.of(DoFn.ProcessContinuation.resume());
        }
        if (!tracker.tryClaim((Object)startTimestamp)) {
            LOG.debug("[{}] Could not claim queryChangeStream({}), stopping", (Object)token, (Object)startTimestamp);
            return Optional.of(DoFn.ProcessContinuation.stop());
        }
        watermarkEstimator.setWatermark(new Instant(startTimestamp.toSqlTimestamp().getTime()));
        for (String startPartitionToken : record.getPartitionTokens()) {
            this.processStartPartition(partition, record, startPartitionToken);
        }
        LOG.debug("[{}] partition start action completed successfully", (Object)token);
        return Optional.empty();
    }

    private void processStartPartition(@UnknownKeyFor @NonNull @Initialized PartitionMetadata partition, @UnknownKeyFor @NonNull @Initialized PartitionStartRecord record, @UnknownKeyFor @NonNull @Initialized String startPartitionToken) {
        LOG.debug("Processing start partition event {}", (Object)startPartitionToken);
        PartitionMetadata row = PartitionMetadata.newBuilder().setPartitionToken(startPartitionToken).setStartTimestamp(record.getStartTimestamp()).setEndTimestamp(partition.getEndTimestamp()).setHeartbeatMillis(partition.getHeartbeatMillis()).setState(PartitionMetadata.State.CREATED).setWatermark(record.getStartTimestamp()).build();
        LOG.debug("Inserting start partition token {}", (Object)startPartitionToken);
        Boolean insertedRow = this.partitionMetadataDao.runInTransaction(transaction -> {
            if (transaction.getPartition(startPartitionToken) == null) {
                transaction.insert(row);
                return true;
            }
            return false;
        }, "InsertStartPartition").getResult();
        if (insertedRow.booleanValue()) {
            this.metrics.incPartitionStartRecordCount();
        } else {
            LOG.debug("Partition start token {} already exists, skipping...", (Object)startPartitionToken);
        }
    }
}

