/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.auth.oauth2;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.token.BearerTokenError;
import java.net.URL;
import java.text.ParseException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hive.metastore.auth.HttpAuthenticationException;
import org.apache.hadoop.hive.metastore.auth.jwt.JWTValidator;
import org.apache.hadoop.hive.metastore.auth.oauth2.OAuth2Authenticator;
import org.apache.hadoop.hive.metastore.auth.oauth2.OAuth2PrincipalMapper;

public class JWTAccessTokenAuthenticator
implements OAuth2Authenticator {
    private static final Set<JOSEObjectType> ACCEPTABLE_TYPES = Collections.singleton(new JOSEObjectType("at+jwt"));
    private final JWTValidator validator;
    private final OAuth2PrincipalMapper principalMapper;

    public JWTAccessTokenAuthenticator(Issuer issuer, URL jwksURL, String audience, OAuth2PrincipalMapper principalMapper) {
        this.validator = new JWTValidator(ACCEPTABLE_TYPES, Collections.singletonList(jwksURL), issuer.getValue(), audience, Collections.emptySet());
        this.principalMapper = principalMapper;
    }

    @Override
    public String resolveUserName(String bearerToken, List<String> requiredScopes) throws HttpAuthenticationException {
        Scope scope;
        JWTClaimsSet claimSet;
        OAuth2Authenticator.requireBearerToken(bearerToken);
        try {
            claimSet = this.validator.validateJWT(bearerToken);
        }
        catch (BadJOSEException | ParseException e) {
            BearerTokenError error = BearerTokenError.INVALID_TOKEN;
            throw new HttpAuthenticationException(e.getMessage(), e, error.getHTTPStatusCode(), error.toWWWAuthenticateHeader());
        }
        catch (JOSEException e) {
            throw new HttpAuthenticationException("Unexpectedly failed to validate JWT", e, 500);
        }
        try {
            scope = Scope.parse((String)claimSet.getStringClaim("scope"));
        }
        catch (ParseException e) {
            BearerTokenError error = BearerTokenError.INVALID_TOKEN;
            throw new HttpAuthenticationException(e.getMessage(), (Throwable)e, error.getHTTPStatusCode(), error.toWWWAuthenticateHeader());
        }
        OAuth2Authenticator.requireScopes(scope, requiredScopes);
        return this.principalMapper.getUserName(claimName -> JWTAccessTokenAuthenticator.getStringFromClaim(claimSet, claimName));
    }

    private static String getStringFromClaim(JWTClaimsSet claimSet, String claimName) throws HttpAuthenticationException {
        try {
            return claimSet.getStringClaim(claimName);
        }
        catch (ParseException e) {
            BearerTokenError error = BearerTokenError.INVALID_TOKEN;
            throw new HttpAuthenticationException(e.getMessage(), (Throwable)e, error.getHTTPStatusCode(), error.toWWWAuthenticateHeader());
        }
    }
}

