/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.rewrite;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.StorageFormat;
import org.apache.hadoop.hive.ql.parse.rewrite.MergeStatement;
import org.apache.hadoop.hive.ql.parse.rewrite.Rewriter;
import org.apache.hadoop.hive.ql.parse.rewrite.sql.MultiInsertSqlGenerator;
import org.apache.hadoop.hive.ql.parse.rewrite.sql.SqlGeneratorFactory;
import org.apache.hadoop.hive.ql.session.SessionState;

public class MergeRewriter
implements Rewriter<MergeStatement>,
MergeStatement.DestClausePrefixSetter {
    private final Hive db;
    protected final HiveConf conf;
    protected final SqlGeneratorFactory sqlGeneratorFactory;

    public MergeRewriter(Hive db, HiveConf conf, SqlGeneratorFactory sqlGeneratorFactory) {
        this.db = db;
        this.conf = conf;
        this.sqlGeneratorFactory = sqlGeneratorFactory;
    }

    @Override
    public ParseUtils.ReparseResult rewrite(Context ctx, MergeStatement mergeStatement) throws SemanticException {
        this.setOperation(ctx);
        MultiInsertSqlGenerator sqlGenerator = this.sqlGeneratorFactory.createSqlGenerator();
        this.handleSource(mergeStatement.hasWhenNotMatchedInsertClause(), mergeStatement.getSourceAlias(), mergeStatement.getOnClauseAsText(), sqlGenerator);
        MergeWhenClauseSqlGenerator mergeSqlGenerator = this.createMergeSqlGenerator(mergeStatement, sqlGenerator);
        for (MergeStatement.WhenClause whenClause : mergeStatement.getWhenClauses()) {
            whenClause.toSql(mergeSqlGenerator);
        }
        boolean validateCardinalityViolation = mergeStatement.shouldValidateCardinalityViolation(this.conf);
        if (validateCardinalityViolation) {
            this.handleCardinalityViolation(mergeStatement.getTargetAlias(), mergeStatement.getOnClauseAsText(), sqlGenerator);
        }
        ParseUtils.ReparseResult rr = ParseUtils.parseRewrittenQuery(ctx, sqlGenerator.toString());
        Context rewrittenCtx = rr.rewrittenCtx;
        ASTNode rewrittenTree = rr.rewrittenTree;
        this.setOperation(rewrittenCtx);
        int insClauseIdx = 1;
        for (MergeStatement.WhenClause whenClause : mergeStatement.getWhenClauses()) {
            insClauseIdx += whenClause.addDestNamePrefixOfInsert(this, insClauseIdx, rewrittenCtx);
        }
        if (validateCardinalityViolation) {
            rewrittenCtx.addDestNamePrefix(rewrittenTree.getChildCount() - 1, Context.DestClausePrefix.INSERT);
        }
        return rr;
    }

    protected MergeWhenClauseSqlGenerator createMergeSqlGenerator(MergeStatement mergeStatement, MultiInsertSqlGenerator sqlGenerator) {
        return new MergeWhenClauseSqlGenerator(this.conf, sqlGenerator, mergeStatement);
    }

    private void handleSource(boolean hasWhenNotMatchedClause, String sourceAlias, String onClauseAsText, MultiInsertSqlGenerator sqlGenerator) {
        sqlGenerator.append("FROM\n");
        sqlGenerator.append("(SELECT ");
        sqlGenerator.appendAcidSelectColumns(Context.Operation.MERGE);
        sqlGenerator.appendAllColsOfTargetTable();
        sqlGenerator.append(" FROM ").appendTargetTableName().append(") ");
        sqlGenerator.appendSubQueryAlias();
        sqlGenerator.append('\n');
        sqlGenerator.indent().append(hasWhenNotMatchedClause ? "RIGHT OUTER JOIN" : "INNER JOIN").append("\n");
        sqlGenerator.indent().append(sourceAlias);
        sqlGenerator.append('\n');
        sqlGenerator.indent().append("ON ").append(onClauseAsText).append('\n');
    }

    private void handleCardinalityViolation(String targetAlias, String onClauseAsString, MultiInsertSqlGenerator sqlGenerator) throws SemanticException {
        String tableName = "merge_tmp_table";
        List<String> sortKeys = sqlGenerator.getSortKeys(Context.Operation.MERGE);
        sqlGenerator.append("INSERT INTO ").append(tableName).append("\n  SELECT cardinality_violation(").append(StringUtils.join(sortKeys, (String)","));
        sqlGenerator.appendPartColsOfTargetTableWithComma(targetAlias);
        sqlGenerator.append(")\n WHERE ").append(onClauseAsString).append(" GROUP BY ").append(StringUtils.join(sortKeys, (String)","));
        sqlGenerator.appendPartColsOfTargetTableWithComma(targetAlias);
        sqlGenerator.append(" HAVING count(*) > 1");
        try {
            if (null == this.db.getTable(tableName, false)) {
                StorageFormat format = new StorageFormat((Configuration)this.conf);
                format.processStorageFormat("TextFile");
                Table table = this.db.newTable(tableName);
                table.setSerializationLib(format.getSerde());
                ArrayList<FieldSchema> fields = new ArrayList<FieldSchema>();
                fields.add(new FieldSchema("val", "int", null));
                table.setFields(fields);
                table.setDataLocation(Warehouse.getDnsPath((Path)new Path(SessionState.get().getTempTableSpace(), tableName), (Configuration)this.conf));
                table.getTTable().setTemporary(true);
                table.setStoredAsSubDirectories(false);
                table.setInputFormatClass(format.getInputFormat());
                table.setOutputFormatClass(format.getOutputFormat());
                this.db.createTable(table, true);
            }
        }
        catch (MetaException | HiveException e) {
            throw new SemanticException(e.getMessage(), e);
        }
    }

    protected void setOperation(Context context) {
        context.setOperation(Context.Operation.MERGE);
    }

    protected static class MergeWhenClauseSqlGenerator
    implements MergeStatement.MergeSqlGenerator {
        protected final HiveConf conf;
        protected final MultiInsertSqlGenerator sqlGenerator;
        protected final MergeStatement mergeStatement;
        protected String hintStr;

        MergeWhenClauseSqlGenerator(HiveConf conf, MultiInsertSqlGenerator sqlGenerator, MergeStatement mergeStatement) {
            this.conf = conf;
            this.sqlGenerator = sqlGenerator;
            this.mergeStatement = mergeStatement;
            this.hintStr = mergeStatement.getHintStr();
        }

        @Override
        public void appendWhenNotMatchedInsertClause(MergeStatement.InsertClause insertClause) {
            this.sqlGenerator.append("INSERT INTO ").append(this.mergeStatement.getTargetName());
            if (insertClause.getColumnList() != null) {
                this.sqlGenerator.append(" (");
                this.sqlGenerator.appendCols(insertClause.getColumnList(), Function.identity());
                this.sqlGenerator.append(')');
            }
            this.sqlGenerator.append("    -- insert clause\n  SELECT ");
            if (StringUtils.isNotBlank((CharSequence)this.hintStr)) {
                this.sqlGenerator.append(this.hintStr);
                this.hintStr = null;
            }
            this.sqlGenerator.append(String.join((CharSequence)", ", insertClause.getValuesClause()));
            this.sqlGenerator.append("\n   WHERE ").append(insertClause.getPredicate());
            if (insertClause.getExtraPredicate() != null) {
                this.sqlGenerator.append(" AND ").append(insertClause.getExtraPredicate());
            }
            this.sqlGenerator.append('\n');
        }

        @Override
        public void appendWhenMatchedUpdateClause(MergeStatement.UpdateClause updateClause) {
            Table targetTable = this.mergeStatement.getTargetTable();
            String targetAlias = this.mergeStatement.getTargetAlias();
            String onClauseAsString = this.mergeStatement.getOnClauseAsText();
            this.sqlGenerator.append("    -- update clause").append("\n");
            ArrayList<String> valuesAndAcidSortKeys = new ArrayList<String>(targetTable.getCols().size() + targetTable.getPartCols().size() + 1);
            valuesAndAcidSortKeys.addAll(this.sqlGenerator.getSortKeys(Context.Operation.MERGE));
            this.addValues(targetTable, targetAlias, updateClause.getNewValuesMap(), valuesAndAcidSortKeys);
            this.sqlGenerator.appendInsertBranch(this.hintStr, valuesAndAcidSortKeys);
            this.hintStr = null;
            this.addWhereClauseOfUpdate(onClauseAsString, updateClause.getExtraPredicate(), updateClause.getDeleteExtraPredicate(), this.sqlGenerator);
            this.sqlGenerator.appendSortKeys();
        }

        protected void addValues(Table targetTable, String targetAlias, Map<String, String> newValues, List<String> values) {
            UnaryOperator formatter = name -> String.format("%s.%s", targetAlias, HiveUtils.unparseIdentifier(name, (Configuration)this.conf));
            for (FieldSchema fieldSchema2 : targetTable.getCols()) {
                if (newValues.containsKey(fieldSchema2.getName())) {
                    String rhsExp = newValues.get(fieldSchema2.getName());
                    values.add(this.getRhsExpValue(rhsExp, (String)formatter.apply(fieldSchema2.getName())));
                    continue;
                }
                values.add((String)formatter.apply(fieldSchema2.getName()));
            }
            targetTable.getPartCols().forEach(fieldSchema -> values.add((String)formatter.apply(fieldSchema.getName())));
        }

        protected String getRhsExpValue(String newValue, String alias) {
            return newValue;
        }

        protected void addWhereClauseOfUpdate(String onClauseAsString, String extraPredicate, String deleteExtraPredicate, MultiInsertSqlGenerator sqlGenerator) {
            this.addWhereClauseOfUpdate(onClauseAsString, extraPredicate, deleteExtraPredicate, sqlGenerator, UnaryOperator.identity());
        }

        protected void addWhereClauseOfUpdate(String onClauseAsString, String extraPredicate, String deleteExtraPredicate, MultiInsertSqlGenerator sqlGenerator, UnaryOperator<String> columnRefsFunc) {
            StringBuilder whereClause = new StringBuilder(onClauseAsString);
            if (extraPredicate != null) {
                whereClause.append(" AND ").append(extraPredicate);
            }
            if (deleteExtraPredicate != null) {
                whereClause.append(" AND NOT(").append(deleteExtraPredicate).append(")");
            }
            sqlGenerator.indent().append("WHERE ");
            sqlGenerator.append((String)columnRefsFunc.apply(whereClause.toString()));
        }

        @Override
        public void appendWhenMatchedDeleteClause(MergeStatement.DeleteClause deleteClause) {
            this.handleWhenMatchedDelete(this.mergeStatement.getOnClauseAsText(), deleteClause.getExtraPredicate(), deleteClause.getUpdateExtraPredicate(), this.hintStr, this.sqlGenerator);
            this.hintStr = null;
        }

        protected void handleWhenMatchedDelete(String onClauseAsString, String extraPredicate, String updateExtraPredicate, String hintStr, MultiInsertSqlGenerator sqlGenerator) {
            sqlGenerator.appendDeleteBranch(hintStr);
            sqlGenerator.indent().append("WHERE ").append(onClauseAsString);
            if (extraPredicate != null) {
                sqlGenerator.append(" AND ").append(extraPredicate);
            }
            if (updateExtraPredicate != null) {
                sqlGenerator.append(" AND NOT(").append(updateExtraPredicate).append(")");
            }
            sqlGenerator.append("\n").indent();
            sqlGenerator.appendSortKeys();
        }
    }
}

