/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.metric;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.ReplicationMetricList;
import org.apache.hadoop.hive.metastore.api.ReplicationMetrics;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.messaging.MessageEncoder;
import org.apache.hadoop.hive.metastore.messaging.MessageFactory;
import org.apache.hadoop.hive.ql.exec.repl.ReplStatsTracker;
import org.apache.hadoop.hive.ql.exec.util.Retryable;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.metric.MetricCollector;
import org.apache.hadoop.hive.ql.parse.repl.metric.event.Progress;
import org.apache.hadoop.hive.ql.parse.repl.metric.event.ReplicationMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetricSink {
    private static final Logger LOG = LoggerFactory.getLogger(MetricSink.class);
    private ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private static volatile MetricSink instance;
    private boolean isInitialised = false;
    private HiveConf conf;
    private static String RM_PROGRESS_COLUMN_WIDTH_EXCEEDS_MSG;

    private MetricSink() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MetricSink getInstance() {
        if (instance != null) return instance;
        Class<MetricSink> clazz = MetricSink.class;
        synchronized (MetricSink.class) {
            if (instance != null) return instance;
            instance = new MetricSink();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public synchronized void init(HiveConf conf) {
        if (!this.isInitialised) {
            this.conf = conf;
            this.executorService.scheduleAtFixedRate(new MetricSinkWriter(conf), 0L, this.getFrequencyInSecs(), TimeUnit.SECONDS);
            this.isInitialised = true;
            LOG.debug("Metrics Sink Initialised with frequency {} ", (Object)this.getFrequencyInSecs());
        }
    }

    long getFrequencyInSecs() {
        return MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.REPL_METRICS_UPDATE_FREQUENCY, (TimeUnit)TimeUnit.MINUTES) * 60L;
    }

    public synchronized void tearDown() {
        if (this.isInitialised) {
            try {
                this.executorService.shutdown();
            }
            finally {
                if (!this.executorService.isShutdown()) {
                    this.executorService.shutdownNow();
                }
            }
            this.isInitialised = false;
        }
    }

    static {
        RM_PROGRESS_COLUMN_WIDTH_EXCEEDS_MSG = "ERROR: RM_PROGRESS LIMIT EXCEEDED.";
    }

    static class MetricSinkWriter
    implements Runnable {
        private MetricCollector collector = MetricCollector.getInstance();
        private HiveConf conf;

        MetricSinkWriter(HiveConf conf) {
            this.conf = conf;
        }

        private String updateRMProgressIfLimitExceeds(Progress progress, MessageEncoder encoder) throws SemanticException {
            try {
                String progressJson = new ObjectMapper().writeValueAsString((Object)progress);
                String serializedProgress = encoder.getSerializer().serialize(progressJson);
                if (serializedProgress.length() > ReplStatsTracker.RM_PROGRESS_LENGTH) {
                    LOG.warn("Error: RM_PROGRESS limit exceeded.\nRM_PROGRESS: " + progressJson + " overwritten by " + RM_PROGRESS_COLUMN_WIDTH_EXCEEDS_MSG);
                    serializedProgress = encoder.getSerializer().serialize(RM_PROGRESS_COLUMN_WIDTH_EXCEEDS_MSG);
                }
                return serializedProgress;
            }
            catch (Exception e) {
                throw new SemanticException((Throwable)e);
            }
        }

        @Override
        public void run() {
            ReplicationMetricList metricList = new ReplicationMetricList();
            try {
                LOG.debug("Updating metrics to DB");
                LinkedList<ReplicationMetric> metrics = this.collector.getMetrics();
                if (metrics.size() > 0) {
                    LOG.debug("Converting metrics to thrift metrics {} ", (Object)metrics.size());
                    int totalMetricsSize = metrics.size();
                    ArrayList<ReplicationMetrics> replicationMetricsList = new ArrayList<ReplicationMetrics>(totalMetricsSize);
                    ObjectMapper mapper = new ObjectMapper();
                    MessageEncoder encoder = MessageFactory.getDefaultInstanceForReplMetrics((Configuration)this.conf);
                    for (int index = 0; index < totalMetricsSize; ++index) {
                        ReplicationMetric metric = metrics.removeFirst();
                        ReplicationMetrics persistentMetric = new ReplicationMetrics();
                        persistentMetric.setDumpExecutionId(metric.getDumpExecutionId());
                        persistentMetric.setScheduledExecutionId(metric.getScheduledExecutionId());
                        persistentMetric.setPolicy(metric.getPolicy());
                        persistentMetric.setProgress(this.updateRMProgressIfLimitExceeds(metric.getProgress(), encoder));
                        persistentMetric.setMetadata(mapper.writeValueAsString((Object)metric.getMetadata()));
                        persistentMetric.setMessageFormat(encoder.getMessageFormat());
                        LOG.debug("Metric to be persisted {} ", (Object)persistentMetric);
                        replicationMetricsList.add(persistentMetric);
                    }
                    metricList.setReplicationMetricList(replicationMetricsList);
                    Retryable retryable = Retryable.builder().withHiveConf(this.conf).withRetryOnException(Exception.class).build();
                    retryable.executeCallable(() -> {
                        if (metricList.getReplicationMetricListSize() > 0) {
                            LOG.debug("Persisting metrics to DB {} ", (Object)metricList.getReplicationMetricListSize());
                            Hive.get(this.conf).getMSC().addReplicationMetrics(metricList);
                        }
                        return null;
                    });
                } else {
                    LOG.debug("No Metrics to Update ");
                }
            }
            catch (Exception e) {
                LOG.error("Metrics are not getting persisted", (Throwable)e);
            }
        }
    }
}

