/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.misc.properties;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableOperation;
import org.apache.hadoop.hive.ql.ddl.table.misc.properties.AlterTableSetPropertiesDesc;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.PartitionIterable;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.plan.LoadMultiFilesDesc;
import org.apache.hadoop.hive.ql.plan.MoveWork;

public class AlterTableSetPropertiesOperation
extends AbstractAlterTableOperation<AlterTableSetPropertiesDesc> {
    public AlterTableSetPropertiesOperation(DDLOperationContext context, AlterTableSetPropertiesDesc desc) {
        super(context, desc);
    }

    @Override
    protected void doAlteration(Table table, Partition partition) throws HiveException {
        if ("USER".equals(this.environmentContext.getProperties().get("STATS_GENERATED"))) {
            this.environmentContext.getProperties().remove("DO_NOT_UPDATE_STATS");
        }
        if (partition != null) {
            partition.getTPartition().getParameters().putAll(((AlterTableSetPropertiesDesc)this.desc).getProps());
        } else {
            boolean isFromMmTable = AcidUtils.isInsertOnlyTable(table.getParameters());
            Boolean isToMmTable = AcidUtils.isToInsertOnlyTable(table, ((AlterTableSetPropertiesDesc)this.desc).getProps());
            boolean isToFullAcid = AcidUtils.isToFullAcid(table, ((AlterTableSetPropertiesDesc)this.desc).getProps());
            if (!isFromMmTable && BooleanUtils.isTrue((Boolean)isToMmTable)) {
                if (!HiveConf.getBoolVar((Configuration)this.context.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MM_ALLOW_ORIGINALS)) {
                    List<Task<?>> mmTasks = this.generateAddMmTasks(table, ((AlterTableSetPropertiesDesc)this.desc).getWriteId());
                    for (Task<?> mmTask : mmTasks) {
                        this.context.getTask().addDependentTask(mmTask);
                    }
                } else if (!table.getPartitionKeys().isEmpty()) {
                    PartitionIterable parts = new PartitionIterable(this.context.getDb(), table, null, MetastoreConf.getIntVar((Configuration)this.context.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.BATCH_RETRIEVE_MAX));
                    for (Partition part : parts) {
                        this.checkMmLb(part);
                    }
                } else {
                    this.checkMmLb(table);
                }
            } else if (isFromMmTable) {
                if (isToFullAcid) {
                    table.getParameters().put("transactional_properties", "default");
                } else if (BooleanUtils.isFalse((Boolean)isToMmTable)) {
                    throw new HiveException("Cannot convert an ACID table to non-ACID");
                }
            }
            String externalProp = ((AlterTableSetPropertiesDesc)this.desc).getProps().get("EXTERNAL");
            if (externalProp != null) {
                if (Boolean.parseBoolean(externalProp) && table.getTableType() == TableType.MANAGED_TABLE) {
                    table.setTableType(TableType.EXTERNAL_TABLE);
                } else if (!Boolean.parseBoolean(externalProp) && table.getTableType() == TableType.EXTERNAL_TABLE) {
                    table.setTableType(TableType.MANAGED_TABLE);
                }
            }
            table.getTTable().getParameters().putAll(((AlterTableSetPropertiesDesc)this.desc).getProps());
        }
    }

    private List<Task<?>> generateAddMmTasks(Table table, Long writeId) throws HiveException {
        if (writeId == null) {
            throw new HiveException("Internal error - write ID not set for MM conversion");
        }
        ArrayList<Path> sources = new ArrayList<Path>();
        ArrayList<Path> targets = new ArrayList<Path>();
        int stmtId = 0;
        String mmDir = AcidUtils.deltaSubdir(writeId, writeId, stmtId);
        if (!table.getPartitionKeys().isEmpty()) {
            PartitionIterable parts = new PartitionIterable(this.context.getDb(), table, null, MetastoreConf.getIntVar((Configuration)this.context.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.BATCH_RETRIEVE_MAX));
            for (Partition part : parts) {
                this.checkMmLb(part);
                Path source = part.getDataLocation();
                Path target = new Path(source, mmDir);
                sources.add(source);
                targets.add(target);
                Utilities.FILE_OP_LOGGER.trace("Will move " + String.valueOf(source) + " to " + String.valueOf(target));
            }
        } else {
            this.checkMmLb(table);
            Path source = table.getDataLocation();
            Path target = new Path(source, mmDir);
            sources.add(source);
            targets.add(target);
            Utilities.FILE_OP_LOGGER.trace("Will move " + String.valueOf(source) + " to " + String.valueOf(target));
        }
        MoveWork mw = new MoveWork(null, null, null, null, false);
        mw.setMultiFilesDesc(new LoadMultiFilesDesc(sources, targets, true, null, null));
        return Lists.newArrayList((Object[])new Task[]{TaskFactory.get(mw)});
    }

    private void checkMmLb(Table table) throws HiveException {
        if (!table.isStoredAsSubDirectories()) {
            return;
        }
        throw new HiveException("Converting list bucketed tables stored as subdirectories  to MM is not supported. Please re-create a table in the desired format.");
    }

    private void checkMmLb(Partition partition) throws HiveException {
        if (!partition.isStoredAsSubDirectories()) {
            return;
        }
        throw new HiveException("Converting list bucketed tables stored as subdirectories  to MM is not supported. Please re-create a table in the desired format.");
    }
}

