/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.create;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Strings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.SQLCheckConstraint;
import org.apache.hadoop.hive.metastore.api.SQLDefaultConstraint;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLNotNullConstraint;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SQLUniqueConstraint;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.misc.sortoder.SortFieldDesc;
import org.apache.hadoop.hive.ql.ddl.misc.sortoder.SortFields;
import org.apache.hadoop.hive.ql.ddl.misc.sortoder.ZOrderFieldDesc;
import org.apache.hadoop.hive.ql.ddl.misc.sortoder.ZOrderFields;
import org.apache.hadoop.hive.ql.ddl.table.constraint.ConstraintsUtils;
import org.apache.hadoop.hive.ql.ddl.table.convert.AlterTableConvertOperation;
import org.apache.hadoop.hive.ql.ddl.table.create.CreateTableDesc;
import org.apache.hadoop.hive.ql.ddl.table.create.like.CreateTableLikeDesc;
import org.apache.hadoop.hive.ql.ddl.table.storage.skewed.SkewedTableUtils;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.io.SchemaInferenceUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.SessionHiveMetaStoreClient;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.CalcitePlanner;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.PartitionTransform;
import org.apache.hadoop.hive.ql.parse.QB;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.StorageFormat;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.session.SessionStateUtil;
import org.apache.hadoop.hive.ql.util.NullOrdering;

@DDLSemanticAnalyzerFactory.DDLType(types={961})
public class CreateTableAnalyzer
extends CalcitePlanner {
    private static final String[] UPDATED_TBL_PROPS = new String[]{"transactional", "transactional_properties", "bucketing_version"};

    public CreateTableAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    protected ASTNode handlePostCboRewriteContext(CalcitePlanner.PreCboCtx cboCtx, ASTNode newAST) throws SemanticException {
        if (cboCtx.getType() == CalcitePlanner.PreCboCtx.Type.CTAS) {
            this.init(false);
            this.setAST(newAST);
            newAST = this.reAnalyzeCTASAfterCbo(newAST);
        } else {
            newAST = super.handlePostCboRewriteContext(cboCtx, newAST);
        }
        return newAST;
    }

    public ASTNode reAnalyzeCTASAfterCbo(ASTNode newAst) throws SemanticException {
        if ((newAst = this.analyzeCreateTable(newAst, this.getQB(), null)) == null) {
            this.LOG.error("analyzeCreateTable failed to initialize CTAS after CBO; new ast is " + this.getAST().dump());
            throw new SemanticException("analyzeCreateTable failed to initialize CTAS after CBO");
        }
        return newAst;
    }

    @Override
    protected boolean genResolvedParseTree(ASTNode ast, SemanticAnalyzer.PlannerContext plannerCtx) throws SemanticException {
        this.ast = ast;
        this.viewsExpanded = new ArrayList();
        ASTNode child = this.analyzeCreateTable(ast, this.getQB(), plannerCtx);
        if (child == null) {
            return false;
        }
        return this.analyzeAndResolveChildTree(child, plannerCtx);
    }

    private boolean hasConstraints(List<FieldSchema> partCols, List<SQLDefaultConstraint> defConstraints, List<SQLNotNullConstraint> notNullConstraints, List<SQLCheckConstraint> checkConstraints) {
        for (FieldSchema partFS : partCols) {
            for (SQLDefaultConstraint dc : defConstraints) {
                if (!dc.getColumn_name().equals(partFS.getName())) continue;
                return true;
            }
            for (SQLCheckConstraint cc : checkConstraints) {
                if (!cc.getColumn_name().equals(partFS.getName())) continue;
                return true;
            }
            for (SQLNotNullConstraint nc : notNullConstraints) {
                if (!nc.getColumn_name().equals(partFS.getName()) || !nc.isEnable_cstr()) continue;
                return true;
            }
        }
        return false;
    }

    private String getSortOrderJson(ASTNode ast) {
        ArrayList<SortFieldDesc> sortFieldDescList = new ArrayList<SortFieldDesc>();
        SortFields sortFields = new SortFields(sortFieldDescList);
        for (int i = 0; i < ast.getChildCount(); ++i) {
            ASTNode child = (ASTNode)ast.getChild(i);
            SortFieldDesc.SortDirection sortDirection = child.getToken().getType() == 1282 ? SortFieldDesc.SortDirection.DESC : SortFieldDesc.SortDirection.ASC;
            child = (ASTNode)child.getChild(0);
            String name = CreateTableAnalyzer.unescapeIdentifier(child.getChild(0).getText()).toLowerCase();
            NullOrdering nullOrder = NullOrdering.fromToken(child.getToken().getType());
            sortFieldDescList.add(new SortFieldDesc(name, sortDirection, nullOrder));
        }
        try {
            return JSON_OBJECT_MAPPER.writer().writeValueAsString((Object)sortFields);
        }
        catch (JsonProcessingException e) {
            this.LOG.warn("Can not create write order json. ", (Throwable)e);
            return null;
        }
    }

    private String getZOrderJson(ASTNode ast) {
        ArrayList<ZOrderFieldDesc> zOrderFieldDescs = new ArrayList<ZOrderFieldDesc>();
        ZOrderFields zOrderFields = new ZOrderFields(zOrderFieldDescs);
        for (int i = 0; i < ast.getChildCount(); ++i) {
            ASTNode child = (ASTNode)ast.getChild(i);
            String name = CreateTableAnalyzer.unescapeIdentifier(child.getText()).toLowerCase();
            zOrderFieldDescs.add(new ZOrderFieldDesc(name));
        }
        try {
            return JSON_OBJECT_MAPPER.writer().writeValueAsString((Object)zOrderFields);
        }
        catch (JsonProcessingException e) {
            this.LOG.warn("Can not create z-order json. ", (Throwable)e);
            return null;
        }
    }

    private boolean isExternalTableChanged(Map<String, String> tblProp, boolean isTransactional, boolean isExt, boolean isTableTypeChanged) {
        if (isTableTypeChanged && tblProp != null && tblProp.getOrDefault("transactional", "false").equalsIgnoreCase("true") || isTransactional) {
            isExt = false;
        }
        return isExt;
    }

    private static boolean isIcebergTable(Map<String, String> tblProps) {
        return AlterTableConvertOperation.ConversionFormats.ICEBERG.properties().get("storage_handler").equalsIgnoreCase(tblProps.get("storage_handler"));
    }

    private String getDefaultLocation(String dbName, String tableName, boolean isExt) throws SemanticException {
        String tblLocation;
        try {
            Warehouse wh = new Warehouse((Configuration)this.conf);
            tblLocation = wh.getDefaultTablePath(this.db.getDatabase(dbName), tableName, isExt).toUri().getPath();
        }
        catch (MetaException | HiveException e) {
            throw new SemanticException(e);
        }
        return tblLocation;
    }

    private Map<String, String> validateAndAddDefaultProperties(Map<String, String> tblProp, boolean isExt, StorageFormat storageFormat, String qualifiedTableName, List<Order> sortCols, boolean isMaterialization, boolean isTemporaryTable, boolean isTransactional, boolean isManaged, String[] qualifiedTabName, boolean isTableTypeChanged) throws SemanticException {
        boolean makeAcid;
        Map<String, String> retValue = Optional.ofNullable(tblProp).orElseGet(HashMap::new);
        String paraString = HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.NEW_TABLE_DEFAULT_PARA);
        if (paraString != null && !paraString.isEmpty()) {
            for (String keyValuePair : paraString.split(",")) {
                String[] keyValue = keyValuePair.split("=", 2);
                if (keyValue.length != 2 || retValue.containsKey(keyValue[0])) continue;
                retValue.put(keyValue[0], keyValue[1]);
            }
        }
        if (!retValue.containsKey("transactional") && retValue.containsKey("transactional_properties")) {
            throw new SemanticException("Cannot specify transactional_properties without transactional");
        }
        if ((isExt = this.isExternalTableChanged(retValue, isTransactional, isExt, isTableTypeChanged)) && HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXTERNALTABLE_PURGE_DEFAULT) && retValue.get("external.table.purge") == null) {
            retValue.put("external.table.purge", "true");
        }
        boolean makeInsertOnly = !isTemporaryTable && HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CREATE_TABLES_AS_INSERT_ONLY);
        boolean bl = makeAcid = !isTemporaryTable && this.makeAcid();
        if (!isManaged && HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.CREATE_TABLE_AS_EXTERNAL)) {
            makeInsertOnly = false;
            makeAcid = false;
        }
        if ((makeInsertOnly || makeAcid || isTransactional || isManaged) && !isExt && !isMaterialization && StringUtils.isBlank((CharSequence)storageFormat.getStorageHandler()) && !retValue.containsKey("transactional")) {
            if (makeInsertOnly || isTransactional) {
                retValue.put("transactional", "true");
                retValue.put("transactional_properties", "insert_only");
            }
            if (makeAcid || isTransactional || isManaged && !makeInsertOnly) {
                retValue = this.convertToAcidByDefault(storageFormat, qualifiedTableName, sortCols, retValue);
            }
        }
        if (!isExt) {
            this.addDbAndTabToOutputs(qualifiedTabName, TableType.MANAGED_TABLE, isTemporaryTable, retValue, storageFormat);
        } else {
            this.addDbAndTabToOutputs(qualifiedTabName, TableType.EXTERNAL_TABLE, isTemporaryTable, retValue, storageFormat);
        }
        if (CreateTableAnalyzer.isIcebergTable(retValue)) {
            SessionStateUtil.addResourceOrThrow((Configuration)this.conf, "defaultLocation", this.getDefaultLocation(qualifiedTabName[0], qualifiedTabName[1], true));
        }
        return retValue;
    }

    private void updateDefaultTblProps(Map<String, String> source, Map<String, String> target, List<String> skipped) {
        if (source == null || target == null) {
            return;
        }
        for (String property : UPDATED_TBL_PROPS) {
            if (skipped != null && skipped.contains(property) || !source.containsKey(property)) continue;
            target.put(property, source.get(property));
        }
    }

    ASTNode analyzeCreateTable(ASTNode ast, QB qb, SemanticAnalyzer.PlannerContext plannerCtx) throws SemanticException {
        TableName qualifiedTabName = CreateTableAnalyzer.getQualifiedTableName((ASTNode)ast.getChild(0));
        String dbDotTab = qualifiedTabName.getNotEmptyDbTable();
        String likeTableName = null;
        ArrayList<FieldSchema> cols = new ArrayList();
        ArrayList<FieldSchema> partCols = new ArrayList();
        ArrayList<String> partColNames = new ArrayList();
        List<Object> bucketCols = new ArrayList();
        ArrayList<SQLPrimaryKey> primaryKeys = new ArrayList<SQLPrimaryKey>();
        ArrayList<SQLForeignKey> foreignKeys = new ArrayList<SQLForeignKey>();
        ArrayList<SQLUniqueConstraint> uniqueConstraints = new ArrayList<SQLUniqueConstraint>();
        ArrayList<SQLNotNullConstraint> notNullConstraints = new ArrayList<SQLNotNullConstraint>();
        ArrayList<SQLDefaultConstraint> defaultConstraints = new ArrayList<SQLDefaultConstraint>();
        ArrayList<ConstraintsUtils.ConstraintInfo> defaultConstraintInfo = new ArrayList<ConstraintsUtils.ConstraintInfo>();
        ArrayList<SQLCheckConstraint> checkConstraints = new ArrayList<SQLCheckConstraint>();
        ArrayList<Order> sortCols = new ArrayList();
        int numBuckets = -1;
        String comment = null;
        String location = null;
        Map<String, String> tblProps = null;
        boolean ifNotExists = false;
        boolean isExt = false;
        boolean isTemporary = false;
        boolean isManaged = false;
        boolean isMaterialization = false;
        boolean isTransactional = false;
        ASTNode selectStmt = null;
        boolean CREATE_TABLE = false;
        boolean CTLT = true;
        int CTAS = 2;
        int CTT = 3;
        int CTLF = 4;
        int command_type = 0;
        ArrayList<String> skewedColNames = new ArrayList();
        ArrayList<List<String>> skewedValues = new ArrayList();
        HashMap listBucketColValuesMapping = new HashMap();
        boolean storedAsDirs = false;
        boolean isUserStorageFormat = false;
        boolean partitionTransformSpecExists = false;
        String likeFile = null;
        String likeFileFormat = null;
        String sortOrder = null;
        BaseSemanticAnalyzer.RowFormatParams rowFormatParams = new BaseSemanticAnalyzer.RowFormatParams();
        StorageFormat storageFormat = new StorageFormat((Configuration)this.conf);
        this.LOG.info("Creating table " + dbDotTab + " position=" + ast.getCharPositionInLine());
        int numCh = ast.getChildCount();
        String defaultStorageHandler = HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DEFAULT_STORAGE_HANDLER);
        if (defaultStorageHandler != null && !defaultStorageHandler.isEmpty()) {
            this.LOG.info("Default storage handler class detected in config. Using storage handler class if exists: '{}'", (Object)defaultStorageHandler);
            storageFormat.setStorageHandler(defaultStorageHandler);
            isUserStorageFormat = true;
        }
        block43: for (int num = 1; num < numCh; ++num) {
            ASTNode child = (ASTNode)ast.getChild(num);
            if (storageFormat.fillStorageFormat(child)) {
                isUserStorageFormat = true;
                continue;
            }
            switch (child.getToken().getType()) {
                case 1055: {
                    ifNotExists = true;
                    continue block43;
                }
                case 145: {
                    isExt = true;
                    continue block43;
                }
                case 215: {
                    isManaged = true;
                    isTransactional = true;
                    continue block43;
                }
                case 355: {
                    isTemporary = true;
                    isMaterialization = "$MATERIALIZATION".equals(child.getText());
                    continue block43;
                }
                case 367: {
                    isTransactional = true;
                    command_type = 3;
                    continue block43;
                }
                case 1085: {
                    if (cols.size() != 0) {
                        throw new SemanticException(ErrorMsg.CTLT_COLLST_COEXISTENCE.getMsg());
                    }
                    likeFileFormat = CreateTableAnalyzer.getUnescapedName((ASTNode)child.getChild(0));
                    likeFile = CreateTableAnalyzer.getUnescapedName((ASTNode)child.getChild(1));
                    command_type = 4;
                    continue block43;
                }
                case 1087: {
                    if (child.getChildCount() <= 0) continue block43;
                    likeTableName = CreateTableAnalyzer.getUnescapedName((ASTNode)child.getChild(0));
                    if (likeTableName != null) {
                        if (command_type == 2) {
                            throw new SemanticException(ErrorMsg.CTAS_CTLT_COEXISTENCE.getMsg());
                        }
                        if (cols.size() != 0) {
                            throw new SemanticException(ErrorMsg.CTLT_COLLST_COEXISTENCE.getMsg());
                        }
                    }
                    command_type = 1;
                    continue block43;
                }
                case 1161: {
                    if (command_type == 1) {
                        throw new SemanticException(ErrorMsg.CTAS_CTLT_COEXISTENCE.getMsg());
                    }
                    if (cols.size() != 0) {
                        throw new SemanticException(ErrorMsg.CTAS_COLLST_COEXISTENCE.getMsg());
                    }
                    if (partCols.size() != 0 || bucketCols.size() != 0) {
                        boolean dynPart = HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.DYNAMIC_PARTITIONING);
                        if (!dynPart) {
                            throw new SemanticException(ErrorMsg.CTAS_PARCOL_COEXISTENCE.getMsg());
                        }
                        throw new SemanticException(ErrorMsg.CTAS_PARCOL_COEXISTENCE.getMsg());
                    }
                    if (!this.conf.getBoolVar(HiveConf.ConfVars.HIVE_CTAS_EXTERNAL_TABLES) && isExt) {
                        throw new SemanticException(ErrorMsg.CTAS_EXTTBL_COEXISTENCE.getMsg());
                    }
                    command_type = 2;
                    if (plannerCtx != null) {
                        plannerCtx.setCTASToken(child);
                    }
                    selectStmt = child;
                    continue block43;
                }
                case 1252: {
                    cols = CreateTableAnalyzer.getColumns(child, true, this.ctx.getTokenRewriteStream(), primaryKeys, foreignKeys, uniqueConstraints, notNullConstraints, defaultConstraintInfo, checkConstraints, (Configuration)this.conf);
                    continue block43;
                }
                case 1258: {
                    comment = CreateTableAnalyzer.unescapeSQLString(child.getChild(0).getText());
                    continue block43;
                }
                case 1262: {
                    partCols = CreateTableAnalyzer.getColumns(child, false, this.ctx.getTokenRewriteStream(), primaryKeys, foreignKeys, uniqueConstraints, notNullConstraints, defaultConstraintInfo, checkConstraints, (Configuration)this.conf);
                    if (!this.hasConstraints(partCols, defaultConstraints, notNullConstraints, checkConstraints)) continue block43;
                    throw new SemanticException(ErrorMsg.INVALID_CSTR_SYNTAX.getMsg("NOT NULL,DEFAULT and CHECK Constraints are not allowed with partition columns. "));
                }
                case 1263: {
                    SessionStateUtil.addResourceOrThrow((Configuration)this.conf, "partition_transform_spec", PartitionTransform.getPartitionTransformSpec(child));
                    partitionTransformSpecExists = true;
                    continue block43;
                }
                case 1261: {
                    partColNames = CreateTableAnalyzer.getColumnNames(child);
                    continue block43;
                }
                case 868: {
                    bucketCols = CreateTableAnalyzer.getColumnNames((ASTNode)child.getChild(0));
                    if (child.getChildCount() == 2) {
                        numBuckets = Integer.parseInt(child.getChild(1).getText());
                        continue block43;
                    }
                    sortCols = this.getColumnNamesOrder((ASTNode)child.getChild(1));
                    numBuckets = Integer.parseInt(child.getChild(2).getText());
                    continue block43;
                }
                case 1330: {
                    sortOrder = this.getSortOrderJson((ASTNode)child.getChild(0));
                    continue block43;
                }
                case 1331: {
                    sortOrder = this.getZOrderJson((ASTNode)child.getChild(0));
                    continue block43;
                }
                case 1267: {
                    rowFormatParams.analyzeRowFormat(child);
                    continue block43;
                }
                case 1260: {
                    location = CreateTableAnalyzer.unescapeSQLString(child.getChild(0).getText());
                    location = EximUtil.relativeToAbsolutePath(this.conf, location);
                    this.inputs.add(this.toReadEntity(location));
                    continue block43;
                }
                case 1264: {
                    tblProps = CreateTableAnalyzer.getProps((ASTNode)child.getChild(0));
                    this.addPropertyReadEntry(tblProps, this.inputs);
                    continue block43;
                }
                case 1273: {
                    child = (ASTNode)child.getChild(0);
                    storageFormat.setSerde(CreateTableAnalyzer.unescapeSQLString(child.getChild(0).getText()));
                    if (child.getChildCount() != 2) continue block43;
                    CreateTableAnalyzer.readProps((ASTNode)child.getChild(1).getChild(0), storageFormat.getSerdeProps());
                    continue block43;
                }
                case 1274: {
                    HiveConf hiveConf = SessionState.get().getConf();
                    skewedColNames = SkewedTableUtils.analyzeSkewedTableDDLColNames(child);
                    skewedValues = SkewedTableUtils.analyzeDDLSkewedValues(child);
                    storedAsDirs = this.analyzeStoredAdDirs(child);
                    continue block43;
                }
                default: {
                    throw new AssertionError((Object)("Unknown token: " + String.valueOf(child.getToken())));
                }
            }
        }
        this.validateStorageFormat(storageFormat, tblProps, partitionTransformSpecExists);
        if (command_type == 0 || command_type == 1 || command_type == 3 || command_type == 4) {
            this.queryState.setCommandType(HiveOperation.CREATETABLE);
        } else if (command_type == 2) {
            this.queryState.setCommandType(HiveOperation.CREATETABLE_AS_SELECT);
        } else {
            throw new SemanticException("Unrecognized command.");
        }
        storageFormat.fillDefaultStorageFormat(isExt, false);
        if (ifNotExists) {
            try {
                Table table = this.getTable(qualifiedTabName, false);
                if (table != null) {
                    return null;
                }
            }
            catch (HiveException e) {
                throw new IllegalStateException("Unexpected Exception thrown: " + e.getMessage(), e);
            }
        }
        if (isTemporary && location == null) {
            try {
                location = SessionState.generateTempTableLocation((Configuration)this.conf);
            }
            catch (MetaException err) {
                throw new SemanticException("Error while generating temp table path:", (Throwable)err);
            }
        }
        Database database = this.getDatabase(qualifiedTabName.getDb());
        boolean isDefaultTableTypeChanged = false;
        if (database.getParameters() != null) {
            String defaultTableType = database.getParameters().getOrDefault("defaultTableType", null);
            if (defaultTableType != null && defaultTableType.equalsIgnoreCase("external")) {
                isExt = true;
                isDefaultTableTypeChanged = true;
            } else if (defaultTableType != null && defaultTableType.equalsIgnoreCase("acid")) {
                isDefaultTableTypeChanged = true;
                isTransactional = !isExt;
            }
        }
        switch (command_type) {
            case 4: {
                try {
                    if (!SchemaInferenceUtils.doesSupportSchemaInference((Configuration)this.conf, likeFileFormat)) {
                        throw new SemanticException(ErrorMsg.CTLF_UNSUPPORTED_FORMAT.getErrorCodedMsg(new String[]{likeFileFormat}));
                    }
                }
                catch (HiveException e) {
                    throw new SemanticException(e.getMessage(), (Throwable)e);
                }
            }
            case 0: {
                if (!CollectionUtils.isEmpty(partColNames)) {
                    throw new SemanticException("Partition columns can only declared using their name and types in regular CREATE TABLE statements");
                }
                tblProps = this.validateAndAddDefaultProperties(tblProps, isExt, storageFormat, dbDotTab, sortCols, isMaterialization, isTemporary, isTransactional, isManaged, new String[]{qualifiedTabName.getDb(), qualifiedTabName.getTable()}, isDefaultTableTypeChanged);
                isExt = this.isExternalTableChanged(tblProps, isTransactional, isExt, isDefaultTableTypeChanged);
                this.addDbAndTabToOutputs(new String[]{qualifiedTabName.getDb(), qualifiedTabName.getTable()}, TableType.MANAGED_TABLE, isTemporary, tblProps, storageFormat);
                if (!Strings.isNullOrEmpty((String)sortOrder)) {
                    tblProps.put("default-sort-order", sortOrder);
                }
                CreateTableDesc crtTblDesc = new CreateTableDesc(qualifiedTabName, isExt, isTemporary, cols, partCols, bucketCols, sortCols, numBuckets, rowFormatParams.getFieldDelim(), rowFormatParams.getFieldEscape(), rowFormatParams.getCollItemDelim(), rowFormatParams.getMapKeyDelim(), rowFormatParams.getLineDelim(), comment, storageFormat.getInputFormat(), storageFormat.getOutputFormat(), location, storageFormat.getSerde(), storageFormat.getStorageHandler(), storageFormat.getSerdeProps(), tblProps, ifNotExists, skewedColNames, skewedValues, primaryKeys, foreignKeys, uniqueConstraints, notNullConstraints, defaultConstraints, checkConstraints);
                crtTblDesc.setStoredAsSubDirectories(storedAsDirs);
                crtTblDesc.setNullFormat(rowFormatParams.getNullFormat());
                crtTblDesc.setLikeFile(likeFile);
                crtTblDesc.setLikeFileFormat(likeFileFormat);
                crtTblDesc.validate(this.conf);
                this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), crtTblDesc)));
                String tblLocation = null;
                tblLocation = location != null ? location : this.getDefaultLocation(qualifiedTabName.getDb(), qualifiedTabName.getTable(), isExt);
                boolean isNativeColumnDefaultSupported = false;
                try {
                    HiveStorageHandler storageHandler = HiveUtils.getStorageHandler((Configuration)this.conf, storageFormat.getStorageHandler());
                    if (storageHandler != null) {
                        storageHandler.addResourcesForCreateTable(tblProps, this.conf);
                        isNativeColumnDefaultSupported = storageHandler.supportsDefaultColumnValues(tblProps);
                    }
                }
                catch (HiveException e) {
                    throw new RuntimeException(e);
                }
                ConstraintsUtils.constraintInfosToDefaultConstraints(qualifiedTabName, defaultConstraintInfo, crtTblDesc.getDefaultConstraints(), isNativeColumnDefaultSupported);
                SessionStateUtil.addResourceOrThrow((Configuration)this.conf, "location", tblLocation);
                if (isExt && ConstraintsUtils.hasEnabledOrValidatedConstraints(notNullConstraints, crtTblDesc.getDefaultConstraints(), checkConstraints, isNativeColumnDefaultSupported)) {
                    throw new SemanticException(ErrorMsg.INVALID_CSTR_SYNTAX.getMsg("Constraints are disallowed with External tables. Only RELY is allowed."));
                }
                if (checkConstraints == null || checkConstraints.isEmpty()) break;
                ConstraintsUtils.validateCheckConstraint(cols, checkConstraints, this.ctx.getConf());
                break;
            }
            case 3: {
                if (isExt && !isDefaultTableTypeChanged) {
                    throw new SemanticException(qualifiedTabName.getTable() + " cannot be declared transactional because it's an external table");
                }
                tblProps = this.validateAndAddDefaultProperties(tblProps, isExt, storageFormat, dbDotTab, sortCols, isMaterialization, isTemporary, isTransactional, isManaged, new String[]{qualifiedTabName.getDb(), qualifiedTabName.getTable()}, isDefaultTableTypeChanged);
                isExt = this.isExternalTableChanged(tblProps, isTransactional, isExt, isDefaultTableTypeChanged);
                this.addDbAndTabToOutputs(new String[]{qualifiedTabName.getDb(), qualifiedTabName.getTable()}, TableType.MANAGED_TABLE, false, tblProps, storageFormat);
                CreateTableDesc crtTranTblDesc = new CreateTableDesc(qualifiedTabName, isExt, isTemporary, cols, partCols, bucketCols, sortCols, numBuckets, rowFormatParams.getFieldDelim(), rowFormatParams.getFieldEscape(), rowFormatParams.getCollItemDelim(), rowFormatParams.getMapKeyDelim(), rowFormatParams.getLineDelim(), comment, storageFormat.getInputFormat(), storageFormat.getOutputFormat(), location, storageFormat.getSerde(), storageFormat.getStorageHandler(), storageFormat.getSerdeProps(), tblProps, ifNotExists, skewedColNames, skewedValues, primaryKeys, foreignKeys, uniqueConstraints, notNullConstraints, defaultConstraints, checkConstraints);
                crtTranTblDesc.setStoredAsSubDirectories(storedAsDirs);
                crtTranTblDesc.setNullFormat(rowFormatParams.getNullFormat());
                crtTranTblDesc.validate(this.conf);
                this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), crtTranTblDesc)));
                break;
            }
            case 1: {
                tblProps = this.validateAndAddDefaultProperties(tblProps, isExt, storageFormat, dbDotTab, sortCols, isMaterialization, isTemporary, isTransactional, isManaged, new String[]{qualifiedTabName.getDb(), qualifiedTabName.getTable()}, isDefaultTableTypeChanged);
                tblProps.put("created_with_ctlt", "true");
                isExt = this.isExternalTableChanged(tblProps, isTransactional, isExt, isDefaultTableTypeChanged);
                this.addDbAndTabToOutputs(new String[]{qualifiedTabName.getDb(), qualifiedTabName.getTable()}, TableType.MANAGED_TABLE, isTemporary, tblProps, storageFormat);
                Table likeTable = this.getTable(likeTableName, false);
                if (likeTable != null) {
                    if (isTemporary || isExt || CreateTableAnalyzer.isIcebergTable(tblProps)) {
                        this.updateDefaultTblProps(likeTable.getParameters(), tblProps, new ArrayList<String>(Arrays.asList("transactional", "transactional_properties")));
                    } else {
                        this.updateDefaultTblProps(likeTable.getParameters(), tblProps, null);
                    }
                }
                if (likeTable.getTableType() == TableType.EXTERNAL_TABLE && HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.CREATE_TABLE_AS_EXTERNAL)) {
                    isExt = true;
                }
                CreateTableLikeDesc crtTblLikeDesc = new CreateTableLikeDesc(dbDotTab, isExt, isTemporary, storageFormat.getInputFormat(), storageFormat.getOutputFormat(), location, storageFormat.getSerde(), storageFormat.getSerdeProps(), tblProps, ifNotExists, likeTableName, isUserStorageFormat);
                String tblLocation = this.getDefaultLocation(qualifiedTabName.getDb(), qualifiedTabName.getTable(), isExt);
                SessionStateUtil.addResource((Configuration)this.conf, "location", tblLocation);
                this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), crtTblLikeDesc)));
                break;
            }
            case 2: {
                String tblLocation;
                if (isTemporary) {
                    if (!this.ctx.isExplainSkipExecution() && !isMaterialization) {
                        SessionState ss = SessionState.get();
                        if (ss == null) {
                            throw new SemanticException("No current SessionState, cannot create temporary table " + qualifiedTabName.getNotEmptyDbTable());
                        }
                        Map<String, Table> tables = SessionHiveMetaStoreClient.getTempTablesForDatabase(qualifiedTabName.getDb(), qualifiedTabName.getTable());
                        if (tables != null && tables.containsKey(qualifiedTabName.getTable())) {
                            throw new SemanticException("Temporary table " + qualifiedTabName.getNotEmptyDbTable() + " already exists");
                        }
                    }
                } else {
                    try {
                        Table dumpTable = this.db.newTable(dbDotTab);
                        if (null != this.db.getTable(dumpTable.getDbName(), dumpTable.getTableName(), false) && !this.ctx.isExplainSkipExecution()) {
                            throw new SemanticException(ErrorMsg.TABLE_ALREADY_EXISTS.getMsg(dbDotTab));
                        }
                    }
                    catch (HiveException e) {
                        throw new SemanticException((Throwable)e);
                    }
                }
                if (location != null && location.length() != 0) {
                    Path locPath = new Path(location);
                    FileSystem curFs = null;
                    FileStatus locStats = null;
                    try {
                        FileStatus[] lStats;
                        curFs = locPath.getFileSystem((Configuration)this.conf);
                        if (curFs != null) {
                            locStats = curFs.getFileStatus(locPath);
                        }
                        if (locStats != null && locStats.isDir() && (lStats = curFs.listStatus(locPath)) != null && lStats.length != 0) {
                            for (FileStatus lStat : lStats) {
                                if (lStat.getPath().getName().startsWith(HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.STAGING_DIR))) continue;
                                throw new SemanticException(ErrorMsg.CTAS_LOCATION_NONEMPTY.getMsg(location));
                            }
                        }
                    }
                    catch (FileNotFoundException lStats) {
                    }
                    catch (IOException ioE) {
                        this.LOG.debug("Exception when validate folder", (Throwable)ioE);
                    }
                    tblLocation = location;
                } else {
                    tblLocation = this.getDefaultLocation(qualifiedTabName.getDb(), qualifiedTabName.getTable(), isExt);
                }
                SessionStateUtil.addResource((Configuration)this.conf, "location", tblLocation);
                if (!CollectionUtils.isEmpty(partCols)) {
                    throw new SemanticException("Partition columns can only declared using their names in CTAS statements");
                }
                tblProps = this.validateAndAddDefaultProperties(tblProps, isExt, storageFormat, dbDotTab, sortCols, isMaterialization, isTemporary, isTransactional, isManaged, new String[]{qualifiedTabName.getDb(), qualifiedTabName.getTable()}, isDefaultTableTypeChanged);
                isExt = this.isExternalTableChanged(tblProps, isTransactional, isExt, isDefaultTableTypeChanged);
                tblProps.put("created_with_ctas", "true");
                this.addDbAndTabToOutputs(new String[]{qualifiedTabName.getDb(), qualifiedTabName.getTable()}, TableType.MANAGED_TABLE, isTemporary, tblProps, storageFormat);
                this.tableDesc = new CreateTableDesc(qualifiedTabName, isExt, isTemporary, cols, partColNames, bucketCols, sortCols, numBuckets, rowFormatParams.getFieldDelim(), rowFormatParams.getFieldEscape(), rowFormatParams.getCollItemDelim(), rowFormatParams.getMapKeyDelim(), rowFormatParams.getLineDelim(), comment, storageFormat.getInputFormat(), storageFormat.getOutputFormat(), location, storageFormat.getSerde(), storageFormat.getStorageHandler(), storageFormat.getSerdeProps(), tblProps, ifNotExists, skewedColNames, skewedValues, true, primaryKeys, foreignKeys, uniqueConstraints, notNullConstraints, defaultConstraints, checkConstraints);
                this.tableDesc.setMaterialization(isMaterialization);
                this.tableDesc.setStoredAsSubDirectories(storedAsDirs);
                this.tableDesc.setNullFormat(rowFormatParams.getNullFormat());
                qb.setTableDesc(this.tableDesc);
                return selectStmt;
            }
            default: {
                throw new SemanticException("Unrecognized command.");
            }
        }
        return null;
    }
}

