/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.autostart;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.DatastoreInitialisationException;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.FileMetaData;
import org.datanucleus.metadata.PackageMetaData;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.autostart.AbstractAutoStartMechanism;
import org.datanucleus.util.Localiser;

public class MetaDataAutoStarter
extends AbstractAutoStartMechanism {
    protected String metaDataFiles;
    protected StoreManager storeMgr;
    protected ClassLoaderResolver clr;
    protected Collection<StoreData> classes = new HashSet<StoreData>();

    public MetaDataAutoStarter(StoreManager storeMgr, ClassLoaderResolver clr) {
        this.metaDataFiles = storeMgr.getStringProperty("datanucleus.autostartmetadatafiles");
        this.storeMgr = storeMgr;
        this.clr = clr;
    }

    @Override
    public Collection<StoreData> getAllClassData() throws DatastoreInitialisationException {
        if (this.metaDataFiles == null) {
            return Collections.EMPTY_SET;
        }
        Collection<FileMetaData> fileMetaData = this.storeMgr.getNucleusContext().getMetaDataManager().loadFiles(this.metaDataFiles.split(","), this.clr);
        for (FileMetaData filemd : fileMetaData) {
            for (int i = 0; i < filemd.getNoOfPackages(); ++i) {
                PackageMetaData pmd = filemd.getPackage(i);
                for (int j = 0; j < pmd.getNoOfClasses(); ++j) {
                    ClassMetaData cmd = pmd.getClass(j);
                    this.classes.add(new StoreData(cmd.getFullClassName().trim(), null, StoreData.Type.FCO, null));
                }
            }
        }
        return this.classes;
    }

    @Override
    public void addClass(StoreData data) {
    }

    @Override
    public void deleteClass(String className) {
    }

    @Override
    public void deleteAllClasses() {
    }

    @Override
    public String getStorageDescription() {
        return Localiser.msg("034150");
    }
}

