/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.tuple;

import org.apache.datasketches.hive.tuple.State;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.SummaryFactory;
import org.apache.datasketches.tuple.UpdatableSketch;
import org.apache.datasketches.tuple.UpdatableSketchBuilder;
import org.apache.datasketches.tuple.UpdatableSummary;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;

class SketchState<U, S extends UpdatableSummary<U>>
extends State<S> {
    private UpdatableSketch<U, S> sketch_;

    SketchState() {
    }

    boolean isInitialized() {
        return this.sketch_ != null;
    }

    void init(int nominalNumEntries, float samplingProbability, SummaryFactory<S> summaryFactory) {
        super.init(nominalNumEntries);
        this.sketch_ = new UpdatableSketchBuilder(summaryFactory).setNominalEntries(nominalNumEntries).setSamplingProbability(samplingProbability).build();
    }

    void update(Object data, PrimitiveObjectInspector keyObjectInspector, U value) {
        switch (keyObjectInspector.getPrimitiveCategory()) {
            case BINARY: {
                this.sketch_.update(PrimitiveObjectInspectorUtils.getBinary((Object)data, (PrimitiveObjectInspector)keyObjectInspector).copyBytes(), value);
                return;
            }
            case BYTE: {
                this.sketch_.update((long)PrimitiveObjectInspectorUtils.getByte((Object)data, (PrimitiveObjectInspector)keyObjectInspector), value);
                return;
            }
            case DOUBLE: {
                this.sketch_.update(PrimitiveObjectInspectorUtils.getDouble((Object)data, (PrimitiveObjectInspector)keyObjectInspector), value);
                return;
            }
            case FLOAT: {
                this.sketch_.update((double)PrimitiveObjectInspectorUtils.getFloat((Object)data, (PrimitiveObjectInspector)keyObjectInspector), value);
                return;
            }
            case INT: {
                this.sketch_.update((long)PrimitiveObjectInspectorUtils.getInt((Object)data, (PrimitiveObjectInspector)keyObjectInspector), value);
                return;
            }
            case LONG: {
                this.sketch_.update(PrimitiveObjectInspectorUtils.getLong((Object)data, (PrimitiveObjectInspector)keyObjectInspector), value);
                return;
            }
            case STRING: {
                this.sketch_.update(PrimitiveObjectInspectorUtils.getString((Object)data, (PrimitiveObjectInspector)keyObjectInspector), value);
                return;
            }
        }
        throw new IllegalArgumentException("Unrecongnized input data type, please use data of type: byte, double, float, int, long, or string only.");
    }

    @Override
    Sketch<S> getResult() {
        if (this.sketch_ == null) {
            return null;
        }
        this.sketch_.trim();
        return this.sketch_.compact();
    }

    @Override
    void reset() {
        this.sketch_ = null;
    }
}

