/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.HelixManager;
import org.apache.helix.PropertyKey;
import org.apache.helix.controller.LogUtil;
import org.apache.helix.controller.common.PartitionStateMap;
import org.apache.helix.controller.dataproviders.ResourceControllerDataProvider;
import org.apache.helix.controller.pipeline.AbstractAsyncBaseStage;
import org.apache.helix.controller.pipeline.AsyncWorkerType;
import org.apache.helix.controller.stages.AttributeName;
import org.apache.helix.controller.stages.BestPossibleStateOutput;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.controller.stages.IntermediateStateOutput;
import org.apache.helix.model.BuiltInStateModelDefinitions;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.MasterSlaveSMD;
import org.apache.helix.model.Partition;
import org.apache.helix.model.Resource;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistAssignmentStage
extends AbstractAsyncBaseStage {
    private static final Logger LOG = LoggerFactory.getLogger(PersistAssignmentStage.class);

    @Override
    public AsyncWorkerType getAsyncWorkerType() {
        return AsyncWorkerType.PersistAssignmentWorker;
    }

    @Override
    public void execute(ClusterEvent event) throws Exception {
        ResourceControllerDataProvider cache = (ResourceControllerDataProvider)event.getAttribute(AttributeName.ControllerDataProvider.name());
        ClusterConfig clusterConfig = cache.getClusterConfig();
        if (!clusterConfig.isPersistBestPossibleAssignment().booleanValue() && !clusterConfig.isPersistIntermediateAssignment().booleanValue()) {
            return;
        }
        BestPossibleStateOutput bestPossibleAssignment = (BestPossibleStateOutput)event.getAttribute(AttributeName.BEST_POSSIBLE_STATE.name());
        HelixManager helixManager = (HelixManager)event.getAttribute(AttributeName.helixmanager.name());
        HelixDataAccessor accessor = helixManager.getHelixDataAccessor();
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        Map resourceMap = (Map)event.getAttribute(AttributeName.RESOURCES.name());
        for (String resourceId : bestPossibleAssignment.resourceSet()) {
            try {
                this.persistAssignment((Resource)resourceMap.get(resourceId), cache, event, bestPossibleAssignment, clusterConfig, accessor, keyBuilder);
            }
            catch (HelixException ex) {
                LogUtil.logError(LOG, this._eventId, "Failed to persist assignment for resource " + resourceId, ex);
            }
        }
    }

    private void persistAssignment(Resource resource, ResourceControllerDataProvider cache, ClusterEvent event, BestPossibleStateOutput bestPossibleAssignment, ClusterConfig clusterConfig, HelixDataAccessor accessor, PropertyKey.Builder keyBuilder) {
        String resourceId = resource.getResourceName();
        if (resource != null) {
            Map<Partition, Map<String, String>> assignmentToPersist;
            Map<String, List<String>> newLists;
            IdealState idealState = cache.getIdealState(resourceId);
            if (idealState == null) {
                LogUtil.logWarn(LOG, event.getEventId(), "IdealState not found for resource " + resourceId);
                return;
            }
            IdealState.RebalanceMode mode = idealState.getRebalanceMode();
            if (!mode.equals((Object)IdealState.RebalanceMode.SEMI_AUTO) && !mode.equals((Object)IdealState.RebalanceMode.FULL_AUTO)) {
                return;
            }
            IdealState delta = new IdealState(resourceId);
            boolean needPersist = false;
            if (mode.equals((Object)IdealState.RebalanceMode.FULL_AUTO) && (newLists = bestPossibleAssignment.getPreferenceLists(resourceId)) != null && this.hasPreferenceListChanged(newLists, idealState)) {
                delta.setPreferenceLists(newLists);
                needPersist = true;
            }
            PartitionStateMap partitionStateMap = bestPossibleAssignment.getPartitionStateMap(resourceId);
            if (clusterConfig.isPersistIntermediateAssignment().booleanValue()) {
                IntermediateStateOutput intermediateAssignment = (IntermediateStateOutput)event.getAttribute(AttributeName.INTERMEDIATE_STATE.name());
                partitionStateMap = intermediateAssignment.getPartitionStateMap(resourceId);
            }
            if ((assignmentToPersist = this.convertAssignmentPersisted(resource, idealState, partitionStateMap.getStateMap())) != null && this.hasInstanceMapChanged(assignmentToPersist, idealState)) {
                for (Partition partition : assignmentToPersist.keySet()) {
                    Map<String, String> instanceMap = assignmentToPersist.get(partition);
                    delta.setInstanceStateMap(partition.getPartitionName(), instanceMap);
                }
                needPersist = true;
            }
            if (needPersist) {
                accessor.updateProperty(keyBuilder.idealStates(resourceId), current -> {
                    if (current != null) {
                        ZNRecord deltaRecord = delta.getRecord();
                        if (!deltaRecord.getMapFields().isEmpty()) {
                            current.getMapFields().clear();
                            current.getMapFields().putAll(deltaRecord.getMapFields());
                        }
                        if (!deltaRecord.getListFields().isEmpty()) {
                            current.getListFields().putAll(deltaRecord.getListFields());
                        }
                    }
                    return current;
                }, idealState);
            }
        }
    }

    private boolean hasPreferenceListChanged(Map<String, List<String>> newLists, IdealState idealState) {
        Map<String, List<String>> existLists = idealState.getPreferenceLists();
        HashSet<String> partitions = new HashSet<String>(newLists.keySet());
        partitions.addAll(existLists.keySet());
        for (String partition : partitions) {
            List<String> assignedInstances = newLists.get(partition);
            List<String> existingInstances = existLists.get(partition);
            if (assignedInstances == null && existingInstances == null || assignedInstances != null && existingInstances != null && assignedInstances.equals(existingInstances)) continue;
            return true;
        }
        return false;
    }

    private boolean hasInstanceMapChanged(Map<Partition, Map<String, String>> newAssiments, IdealState idealState) {
        HashSet<Partition> partitions = new HashSet<Partition>(newAssiments.keySet());
        for (String p : idealState.getPartitionSet()) {
            partitions.add(new Partition(p));
        }
        for (Partition partition : partitions) {
            Map<String, String> instanceMap = newAssiments.get(partition);
            Map<String, String> existInstanceMap = idealState.getInstanceStateMap(partition.getPartitionName());
            if (instanceMap == null && existInstanceMap == null || instanceMap != null && existInstanceMap != null && instanceMap.equals(existInstanceMap)) continue;
            return true;
        }
        return false;
    }

    private Map<Partition, Map<String, String>> convertAssignmentPersisted(Resource resource, IdealState idealState, Map<Partition, Map<String, String>> assignments) {
        String stateModelDef = idealState.getStateModelDefRef();
        if (!stateModelDef.equals(BuiltInStateModelDefinitions.MasterSlave.name()) || idealState.getRebalanceMode().equals((Object)IdealState.RebalanceMode.FULL_AUTO)) {
            return assignments;
        }
        HashMap<Partition, Map<String, String>> assignmentToPersist = new HashMap<Partition, Map<String, String>>();
        for (Partition partition : resource.getPartitions()) {
            List<String> preferenceList;
            HashMap<String, String> instanceMap = new HashMap<String, String>();
            Map<String, String> assignment = assignments.get(partition);
            if (assignment != null) {
                instanceMap.putAll(assignment);
            }
            if ((preferenceList = idealState.getPreferenceList(partition.getPartitionName())) == null) {
                preferenceList = Collections.emptyList();
            }
            HashSet<String> nodeList = new HashSet<String>(preferenceList);
            nodeList.addAll(assignment.keySet());
            boolean hasMaster = false;
            for (String ins : nodeList) {
                String state = (String)instanceMap.get(ins);
                if (state == null || !state.equals(MasterSlaveSMD.States.SLAVE.name()) && !state.equals(MasterSlaveSMD.States.MASTER.name())) {
                    instanceMap.put(ins, MasterSlaveSMD.States.SLAVE.name());
                }
                if (state == null || !state.equals(MasterSlaveSMD.States.MASTER.name())) continue;
                hasMaster = true;
            }
            if (!hasMaster && preferenceList.size() > 0) {
                instanceMap.put(preferenceList.get(0), MasterSlaveSMD.States.MASTER.name());
            }
            assignmentToPersist.put(partition, instanceMap);
        }
        return assignmentToPersist;
    }
}

