/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.common.caches;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.PropertyKey;
import org.apache.helix.common.caches.ParticipantStateCache;
import org.apache.helix.common.controllers.ControlContextProvider;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.LiveInstance;

public class TaskCurrentStateCache
extends ParticipantStateCache<CurrentState> {
    public TaskCurrentStateCache(ControlContextProvider controlContextProvider) {
        super(controlContextProvider);
    }

    @Override
    protected Set<PropertyKey> PopulateParticipantKeys(HelixDataAccessor accessor, Map<String, LiveInstance> liveInstanceMap) {
        HashSet<PropertyKey> participantStateKeys = new HashSet<PropertyKey>();
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        for (String instanceName : liveInstanceMap.keySet()) {
            LiveInstance liveInstance = liveInstanceMap.get(instanceName);
            String sessionId = liveInstance.getEphemeralOwner();
            List<String> currentStateNames = accessor.getChildNames(keyBuilder.taskCurrentStates(instanceName, sessionId));
            for (String currentStateName : currentStateNames) {
                participantStateKeys.add(keyBuilder.taskCurrentState(instanceName, sessionId, currentStateName));
            }
        }
        return participantStateKeys;
    }
}

