/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.replication.consumer;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.server.ldap.replication.consumer.ReplicationConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class PingerThread
extends Thread {
    private static final Logger CONSUMER_LOG = LoggerFactory.getLogger((String)Loggers.CONSUMER_LOG.getName());
    private Queue<ReplicationConsumer> consumers = new ConcurrentLinkedQueue<ReplicationConsumer>();
    private boolean stop = false;
    private long sleepTime = 5000L;

    public PingerThread(int sleepSec) {
        if (sleepSec > 0) {
            this.sleepTime = sleepSec * 1000;
        }
        CONSUMER_LOG.info("Configured pinger thread to sleep for {} seconds", (Object)(this.sleepTime / 1000L));
        this.setDaemon(true);
    }

    @Override
    public void run() {
        try {
            if (CONSUMER_LOG.isDebugEnabled()) {
                MDC.put((String)"Replica", (String)"Pinger");
                CONSUMER_LOG.debug("Starting the provider's pinger");
            }
            while (!this.stop) {
                for (ReplicationConsumer consumer : this.consumers) {
                    consumer.ping();
                }
                Thread.sleep(this.sleepTime);
            }
        }
        catch (InterruptedException ie) {
            CONSUMER_LOG.debug("The pinger has been interrupted");
        }
    }

    public void addConsumer(ReplicationConsumer consumer) {
        if (!this.consumers.contains(consumer)) {
            this.consumers.add(consumer);
        }
    }

    public void removeConsumer(ReplicationConsumer consumer) {
        this.consumers.remove(consumer);
    }

    public void stopPinging() {
        this.stop = true;
    }
}

