/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.FSVisitor;
import org.apache.hadoop.hbase.util.MD5Hash;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, SmallTests.class})
public class TestFSVisitor {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFSVisitor.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestFSVisitor.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private final String TABLE_NAME = "testtb";
    private Set<String> tableFamilies;
    private Set<String> tableRegions;
    private Set<String> tableHFiles;
    private FileSystem fs;
    private Path tableDir;
    private Path rootDir;

    @Before
    public void setUp() throws Exception {
        this.fs = FileSystem.get((Configuration)TEST_UTIL.getConfiguration());
        this.rootDir = TEST_UTIL.getDataTestDir("hbase");
        this.tableFamilies = new HashSet<String>();
        this.tableRegions = new HashSet<String>();
        this.tableHFiles = new HashSet<String>();
        this.tableDir = this.createTableFiles(this.rootDir, "testtb", this.tableRegions, this.tableFamilies, this.tableHFiles);
        CommonFSUtils.logFileSystemState((FileSystem)this.fs, (Path)this.rootDir, (Logger)LOG);
    }

    @After
    public void tearDown() throws Exception {
        this.fs.delete(this.rootDir, true);
    }

    @Test
    public void testVisitStoreFiles() throws IOException {
        final HashSet regions = new HashSet();
        final HashSet families = new HashSet();
        final HashSet hfiles = new HashSet();
        FSVisitor.visitTableStoreFiles((FileSystem)this.fs, (Path)this.tableDir, (FSVisitor.StoreFileVisitor)new FSVisitor.StoreFileVisitor(){

            public void storeFile(String region, String family, String hfileName) throws IOException {
                regions.add(region);
                families.add(family);
                hfiles.add(hfileName);
            }
        });
        Assert.assertEquals(regions, this.tableRegions);
        Assert.assertEquals(families, this.tableFamilies);
        Assert.assertEquals(hfiles, this.tableHFiles);
    }

    private Path createTableFiles(Path rootDir, String tableName, Set<String> tableRegions, Set<String> tableFamilies, Set<String> tableHFiles) throws IOException {
        Path tableDir = new Path(rootDir, tableName);
        for (int r = 0; r < 10; ++r) {
            String regionName = MD5Hash.getMD5AsHex((byte[])Bytes.toBytes((int)r));
            tableRegions.add(regionName);
            Path regionDir = new Path(tableDir, regionName);
            for (int f = 0; f < 3; ++f) {
                String familyName = "f" + f;
                tableFamilies.add(familyName);
                Path familyDir = new Path(regionDir, familyName);
                this.fs.mkdirs(familyDir);
                for (int h = 0; h < 5; ++h) {
                    String hfileName = TEST_UTIL.getRandomUUID().toString().replaceAll("-", "");
                    tableHFiles.add(hfileName);
                    this.fs.createNewFile(new Path(familyDir, hfileName));
                }
            }
        }
        return tableDir;
    }
}

