/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.procedure2.FailedRemoteDispatchException;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureEvent;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.RemoteProcedureDispatcher;
import org.apache.hadoop.hbase.procedure2.RemoteProcedureException;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class ServerRemoteProcedure
extends Procedure<MasterProcedureEnv>
implements RemoteProcedureDispatcher.RemoteProcedure<MasterProcedureEnv, ServerName> {
    protected static final Logger LOG = LoggerFactory.getLogger(ServerRemoteProcedure.class);
    protected ProcedureEvent<?> event;
    protected ServerName targetServer;
    protected Throwable remoteError;
    protected MasterProcedureProtos.ServerRemoteProcedureState state = MasterProcedureProtos.ServerRemoteProcedureState.SERVER_REMOTE_PROCEDURE_DISPATCH;

    protected abstract boolean complete(MasterProcedureEnv var1, Throwable var2);

    @Override
    protected synchronized Procedure<MasterProcedureEnv>[] execute(MasterProcedureEnv env) throws ProcedureYieldException, ProcedureSuspendedException, InterruptedException {
        if (this.state != MasterProcedureProtos.ServerRemoteProcedureState.SERVER_REMOTE_PROCEDURE_DISPATCH) {
            if (this.complete(env, this.remoteError)) {
                return null;
            }
            this.state = MasterProcedureProtos.ServerRemoteProcedureState.SERVER_REMOTE_PROCEDURE_DISPATCH;
        }
        try {
            env.getRemoteDispatcher().addOperationToNode(this.targetServer, this);
        }
        catch (FailedRemoteDispatchException frde) {
            LOG.warn("Can not send remote operation {} to {}, this operation will be retried to send to another server", (Object)this.getProcId(), (Object)this.targetServer);
            return null;
        }
        this.event = new ProcedureEvent<ServerRemoteProcedure>(this);
        this.event.suspendIfNotReady(this);
        throw new ProcedureSuspendedException();
    }

    @Override
    protected synchronized void completionCleanup(MasterProcedureEnv env) {
        env.getRemoteDispatcher().removeCompletedOperation(this.targetServer, this);
    }

    @Override
    public synchronized void remoteCallFailed(MasterProcedureEnv env, ServerName serverName, IOException exception) {
        this.state = MasterProcedureProtos.ServerRemoteProcedureState.SERVER_REMOTE_PROCEDURE_DISPATCH_FAIL;
        this.remoteOperationDone(env, exception);
    }

    @Override
    public synchronized void remoteOperationCompleted(MasterProcedureEnv env) {
        this.state = MasterProcedureProtos.ServerRemoteProcedureState.SERVER_REMOTE_PROCEDURE_REPORT_SUCCEED;
        this.remoteOperationDone(env, null);
    }

    @Override
    public synchronized void remoteOperationFailed(MasterProcedureEnv env, RemoteProcedureException error) {
        this.state = MasterProcedureProtos.ServerRemoteProcedureState.SERVER_REMOTE_PROCEDURE_REPORT_FAILED;
        this.remoteOperationDone(env, error);
    }

    synchronized void remoteOperationDone(MasterProcedureEnv env, Throwable error) {
        if (this.isFinished()) {
            LOG.info("This procedure {} is already finished, skip the rest processes", (Object)this.getProcId());
            return;
        }
        if (this.event == null) {
            LOG.warn("procedure event for {} is null, maybe the procedure is created when recovery", (Object)this.getProcId());
            return;
        }
        this.remoteError = error;
        env.getMasterServices().getMasterProcedureExecutor().getStore().update(this);
        this.event.wake(env.getProcedureScheduler());
        this.event = null;
    }
}

