/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.http;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.RegionMetrics;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Size;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.AsyncAdmin;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.hadoop.hbase.util.AbstractHBaseTool;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.gson.FieldNamingPolicy;
import org.apache.hbase.thirdparty.com.google.gson.Gson;
import org.apache.hbase.thirdparty.com.google.gson.GsonBuilder;
import org.apache.hbase.thirdparty.com.google.gson.JsonElement;
import org.apache.hbase.thirdparty.com.google.gson.JsonObject;
import org.apache.hbase.thirdparty.com.google.gson.JsonPrimitive;
import org.apache.hbase.thirdparty.com.google.gson.JsonSerializationContext;
import org.apache.hbase.thirdparty.com.google.gson.JsonSerializer;
import org.apache.hbase.thirdparty.org.apache.commons.cli.CommandLine;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RegionVisualizer
extends AbstractHBaseTool {
    private static final Logger LOG = LoggerFactory.getLogger(RegionVisualizer.class);
    private final Admin admin;
    private final AsyncAdmin asyncAdmin;
    private final Gson gson;

    public RegionVisualizer() {
        this.admin = null;
        this.asyncAdmin = null;
        this.gson = null;
    }

    public RegionVisualizer(Admin admin) {
        this.admin = admin;
        this.asyncAdmin = null;
        this.gson = RegionVisualizer.buildGson();
    }

    public RegionVisualizer(AsyncAdmin asyncAdmin) {
        this.admin = null;
        this.asyncAdmin = asyncAdmin;
        this.gson = RegionVisualizer.buildGson();
    }

    public String renderRegionDetails() {
        return this.gson.toJson(this.clusterStatusToRegionDetails());
    }

    public static void main(String[] argv) {
        new RegionVisualizer().doStaticMain(argv);
    }

    static Gson buildGson() {
        return new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).enableComplexMapKeySerialization().registerTypeAdapter((Type)((Object)byte[].class), new ByteArraySerializer()).registerTypeAdapter((Type)((Object)Size.class), new SizeAsBytesSerializer()).registerTypeAdapter((Type)((Object)RegionDetails.class), new RegionDetailsSerializer()).create();
    }

    private ClusterMetrics getClusterMetrics() throws ExecutionException, InterruptedException, IOException {
        if (this.admin != null) {
            return this.admin.getClusterMetrics();
        }
        if (this.asyncAdmin != null) {
            return this.asyncAdmin.getClusterMetrics().get();
        }
        throw new RuntimeException("should not happen");
    }

    private List<RegionDetails> clusterStatusToRegionDetails() {
        ClusterMetrics clusterMetrics;
        try {
            clusterMetrics = this.getClusterMetrics();
        }
        catch (Exception e) {
            LOG.warn("Failed to retrieve cluster metrics.", (Throwable)e);
            return Collections.emptyList();
        }
        return clusterMetrics.getLiveServerMetrics().entrySet().stream().flatMap(serverEntry -> {
            ServerName serverName = (ServerName)serverEntry.getKey();
            ServerMetrics serverMetrics = (ServerMetrics)serverEntry.getValue();
            return serverMetrics.getRegionMetrics().values().stream().map(regionMetrics -> {
                TableName tableName = RegionInfo.getTable(regionMetrics.getRegionName());
                return new RegionDetails(serverName, tableName, (RegionMetrics)regionMetrics);
            });
        }).collect(Collectors.toList());
    }

    @Override
    protected void addOptions() {
    }

    @Override
    protected void processOptions(CommandLine cmd) {
    }

    @Override
    protected int doWork() throws Exception {
        Configuration conf = HBaseConfiguration.create(this.getConf());
        AsyncConnection conn = ConnectionFactory.createAsyncConnection(conf).get();
        RegionVisualizer viz = new RegionVisualizer(conn.getAdmin());
        System.out.println(viz.renderRegionDetails());
        return 0;
    }

    public static final class RegionDetails {
        private final ServerName serverName;
        private final TableName tableName;
        private final RegionMetrics regionMetrics;

        RegionDetails(ServerName serverName, TableName tableName, RegionMetrics regionMetrics) {
            this.serverName = serverName;
            this.tableName = tableName;
            this.regionMetrics = regionMetrics;
        }

        public ServerName getServerName() {
            return this.serverName;
        }

        public TableName getTableName() {
            return this.tableName;
        }

        public RegionMetrics getRegionMetrics() {
            return this.regionMetrics;
        }

        public String toString() {
            return new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE).append("serverName", this.serverName).append("tableName", this.tableName).append("regionMetrics", this.regionMetrics).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RegionDetails that = (RegionDetails)o;
            return new EqualsBuilder().append(this.serverName, that.serverName).append(this.tableName, that.tableName).append(this.regionMetrics, that.regionMetrics).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append(this.serverName).append(this.tableName).append(this.regionMetrics).toHashCode();
        }
    }

    private static final class RegionDetailsSerializer
    implements JsonSerializer<RegionDetails> {
        private RegionDetailsSerializer() {
        }

        @Override
        public JsonElement serialize(RegionDetails src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jobj = (JsonObject)context.serialize(src.getRegionMetrics());
            jobj.addProperty("server_name", src.getServerName().toShortString());
            jobj.addProperty("table_name", src.getTableName().getNameAsString());
            return jobj;
        }
    }

    private static final class SizeAsBytesSerializer
    implements JsonSerializer<Size> {
        private SizeAsBytesSerializer() {
        }

        @Override
        public JsonElement serialize(Size src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.get(Size.Unit.BYTE));
        }
    }

    private static final class ByteArraySerializer
    implements JsonSerializer<byte[]> {
        private ByteArraySerializer() {
        }

        @Override
        public JsonElement serialize(byte[] src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(Bytes.toString(src));
        }
    }
}

