/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.regionserver.DisabledRegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.StoreEngine;
import org.apache.hadoop.hbase.regionserver.StripeStoreEngine;
import org.apache.hadoop.hbase.util.AbstractHBaseTool;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.LoadTestKVGenerator;
import org.apache.hadoop.hbase.util.MultiThreadedAction;
import org.apache.hadoop.hbase.util.MultiThreadedReader;
import org.apache.hadoop.hbase.util.MultiThreadedWriter;
import org.apache.hadoop.hbase.util.MultiThreadedWriterBase;
import org.apache.hadoop.hbase.util.RegionSplitter;
import org.apache.hadoop.hbase.util.test.LoadTestDataGenerator;
import org.apache.hbase.thirdparty.com.google.common.base.Splitter;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterables;
import org.apache.hbase.thirdparty.org.apache.commons.cli.CommandLine;
import org.apache.yetus.audience.InterfaceAudience;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class StripeCompactionsPerformanceEvaluation
extends AbstractHBaseTool {
    private static final Logger LOG = LoggerFactory.getLogger(StripeCompactionsPerformanceEvaluation.class);
    private static final TableName TABLE_NAME = TableName.valueOf((String)StripeCompactionsPerformanceEvaluation.class.getSimpleName());
    private static final byte[] COLUMN_FAMILY = Bytes.toBytes((String)"CF");
    private static final int MIN_NUM_SERVERS = 1;
    private static final String DATAGEN_KEY = "datagen";
    private static final String ITERATIONS_KEY = "iters";
    private static final String PRELOAD_COUNT_KEY = "pwk";
    private static final String WRITE_COUNT_KEY = "wk";
    private static final String WRITE_THREADS_KEY = "wt";
    private static final String READ_THREADS_KEY = "rt";
    private static final String INITIAL_STRIPE_COUNT_KEY = "initstripes";
    private static final String SPLIT_SIZE_KEY = "splitsize";
    private static final String SPLIT_PARTS_KEY = "splitparts";
    private static final String VALUE_SIZE_KEY = "valsize";
    private static final String SEQ_SHARDS_PER_SERVER_KEY = "seqshards";
    private LoadTestDataGenerator dataGen;
    private int iterationCount;
    private long preloadKeys;
    private long writeKeys;
    private int writeThreads;
    private int readThreads;
    private Long initialStripeCount;
    private Long splitSize;
    private Long splitParts;
    private static final String VALUE_SIZE_DEFAULT = "512:4096";
    protected IntegrationTestingUtility util = new IntegrationTestingUtility();

    protected void addOptions() {
        this.addOptWithArg(DATAGEN_KEY, "Type of data generator to use (default or sequential)");
        this.addOptWithArg(SEQ_SHARDS_PER_SERVER_KEY, "Sequential generator will shard the data into many sequences. The number of such shards per server is specified (default is 1).");
        this.addOptWithArg(ITERATIONS_KEY, "Number of iterations to run to compare");
        this.addOptWithArg(PRELOAD_COUNT_KEY, "Number of keys to preload, per server");
        this.addOptWithArg(WRITE_COUNT_KEY, "Number of keys to write, per server");
        this.addOptWithArg(WRITE_THREADS_KEY, "Number of threads to use for writing");
        this.addOptWithArg(READ_THREADS_KEY, "Number of threads to use for reading");
        this.addOptWithArg(INITIAL_STRIPE_COUNT_KEY, "Number of stripes to split regions into initially");
        this.addOptWithArg(SPLIT_SIZE_KEY, "Size at which a stripe will split into more stripes");
        this.addOptWithArg(SPLIT_PARTS_KEY, "Number of stripes to split a stripe into when it splits");
        this.addOptWithArg(VALUE_SIZE_KEY, "Value size; either a number, or a colon-separated range; default 512:4096");
    }

    protected void processOptions(CommandLine cmd) {
        int minValueSize = 0;
        int maxValueSize = 0;
        String valueSize = cmd.getOptionValue(VALUE_SIZE_KEY, VALUE_SIZE_DEFAULT);
        if (valueSize.contains(":")) {
            List valueSizes = Splitter.on((char)':').splitToList((CharSequence)valueSize);
            if (valueSizes.size() != 2) {
                throw new RuntimeException("Invalid value size: " + valueSize);
            }
            minValueSize = Integer.parseInt((String)Iterables.get((Iterable)valueSizes, (int)0));
            maxValueSize = Integer.parseInt((String)Iterables.get((Iterable)valueSizes, (int)1));
        } else {
            minValueSize = maxValueSize = Integer.parseInt(valueSize);
        }
        String datagen = cmd.getOptionValue(DATAGEN_KEY, "default").toLowerCase(Locale.ROOT);
        if ("default".equals(datagen)) {
            this.dataGen = new MultiThreadedAction.DefaultDataGenerator(minValueSize, maxValueSize, 1, 1, (byte[][])new byte[][]{COLUMN_FAMILY});
        } else if ("sequential".equals(datagen)) {
            int shards = Integer.parseInt(cmd.getOptionValue(SEQ_SHARDS_PER_SERVER_KEY, "1"));
            this.dataGen = new SeqShardedDataGenerator(minValueSize, maxValueSize, shards);
        } else {
            throw new RuntimeException("Unknown datagen: " + datagen);
        }
        this.iterationCount = Integer.parseInt(cmd.getOptionValue(ITERATIONS_KEY, "1"));
        this.preloadKeys = Long.parseLong(cmd.getOptionValue(PRELOAD_COUNT_KEY, "1000000"));
        this.writeKeys = Long.parseLong(cmd.getOptionValue(WRITE_COUNT_KEY, "1000000"));
        this.writeThreads = Integer.parseInt(cmd.getOptionValue(WRITE_THREADS_KEY, "10"));
        this.readThreads = Integer.parseInt(cmd.getOptionValue(READ_THREADS_KEY, "20"));
        this.initialStripeCount = this.getLongOrNull(cmd, INITIAL_STRIPE_COUNT_KEY);
        this.splitSize = this.getLongOrNull(cmd, SPLIT_SIZE_KEY);
        this.splitParts = this.getLongOrNull(cmd, SPLIT_PARTS_KEY);
    }

    private Long getLongOrNull(CommandLine cmd, String option) {
        if (!cmd.hasOption(option)) {
            return null;
        }
        return Long.parseLong(cmd.getOptionValue(option));
    }

    public Configuration getConf() {
        Configuration c = super.getConf();
        if (c == null && this.util != null) {
            c = this.conf = this.util.getConfiguration();
        }
        return c;
    }

    protected int doWork() throws Exception {
        this.setUp();
        try {
            boolean isStripe = true;
            for (int i = 0; i < this.iterationCount * 2; ++i) {
                this.createTable(isStripe);
                this.runOneTest((isStripe ? "Stripe" : "Default") + i, this.conf);
                isStripe = !isStripe;
            }
            int n = 0;
            return n;
        }
        finally {
            this.tearDown();
        }
    }

    private void setUp() throws Exception {
        this.util = new IntegrationTestingUtility();
        LOG.debug("Initializing/checking cluster has 1 servers");
        this.util.initializeCluster(1);
        LOG.debug("Done initializing/checking cluster");
    }

    protected void deleteTable() throws Exception {
        if (this.util.getAdmin().tableExists(TABLE_NAME)) {
            LOG.info("Deleting table");
            if (!this.util.getAdmin().isTableDisabled(TABLE_NAME)) {
                this.util.getAdmin().disableTable(TABLE_NAME);
            }
            this.util.getAdmin().deleteTable(TABLE_NAME);
            LOG.info("Deleted table");
        }
    }

    private void createTable(boolean isStripe) throws Exception {
        this.createTable(this.createHtd(isStripe));
    }

    private void tearDown() throws Exception {
        this.deleteTable();
        LOG.info("Restoring the cluster");
        this.util.restoreCluster();
        LOG.info("Done restoring the cluster");
    }

    private void runOneTest(String description, Configuration conf) throws Exception {
        boolean success;
        int numServers = this.util.getHBaseClusterInterface().getClusterMetrics().getLiveServerMetrics().size();
        long startKey = this.preloadKeys * (long)numServers;
        long endKey = startKey + this.writeKeys * (long)numServers;
        StripeCompactionsPerformanceEvaluation.status(String.format("%s test starting on %d servers; preloading 0 to %d and writing to %d", description, numServers, startKey, endKey));
        if (this.preloadKeys > 0L) {
            MultiThreadedWriter preloader = new MultiThreadedWriter(this.dataGen, conf, TABLE_NAME);
            long time = EnvironmentEdgeManager.currentTime();
            preloader.start(0L, startKey, this.writeThreads);
            preloader.waitForFinish();
            if (preloader.getNumWriteFailures() > 0) {
                throw new IOException("Preload failed");
            }
            int waitTime = (int)Math.min(this.preloadKeys / 100L, 30000L);
            StripeCompactionsPerformanceEvaluation.status(description + " preload took " + (EnvironmentEdgeManager.currentTime() - time) / 1000L + "sec; sleeping for " + waitTime / 1000 + "sec for store to stabilize");
            Thread.sleep(waitTime);
        }
        MultiThreadedWriter writer = new MultiThreadedWriter(this.dataGen, conf, TABLE_NAME);
        MultiThreadedReader reader = new MultiThreadedReader(this.dataGen, conf, TABLE_NAME, 100.0);
        reader.linkToWriter((MultiThreadedWriterBase)writer);
        long testStartTime = EnvironmentEdgeManager.currentTime();
        writer.start(startKey, endKey, this.writeThreads);
        reader.start(startKey, endKey, this.readThreads);
        writer.waitForFinish();
        reader.waitForFinish();
        StripeCompactionsPerformanceEvaluation.status("Readers and writers stopped for test " + description);
        boolean bl = success = writer.getNumWriteFailures() == 0;
        if (!success) {
            LOG.error("Write failed");
        } else {
            boolean bl2 = success = reader.getNumReadErrors() == 0L && reader.getNumReadFailures() == 0L;
            if (!success) {
                LOG.error("Read failed");
            }
        }
        StripeCompactionsPerformanceEvaluation.status(description + " test took " + (EnvironmentEdgeManager.currentTime() - testStartTime) / 1000L + "sec");
        Assert.assertTrue((boolean)success);
    }

    private static void status(String s) {
        LOG.info("STATUS " + s);
        System.out.println(s);
    }

    private HTableDescriptor createHtd(boolean isStripe) throws Exception {
        HTableDescriptor htd = new HTableDescriptor(TABLE_NAME);
        htd.addFamily(new HColumnDescriptor(COLUMN_FAMILY));
        String noSplitsPolicy = DisabledRegionSplitPolicy.class.getName();
        htd.setConfiguration("hbase.regionserver.region.split.policy", noSplitsPolicy);
        if (isStripe) {
            htd.setConfiguration(StoreEngine.STORE_ENGINE_CLASS_KEY, StripeStoreEngine.class.getName());
            if (this.initialStripeCount != null) {
                htd.setConfiguration("hbase.store.stripe.initialStripeCount", this.initialStripeCount.toString());
                htd.setConfiguration(HStore.BLOCKING_STOREFILES_KEY, Long.toString(10L * this.initialStripeCount));
            } else {
                htd.setConfiguration(HStore.BLOCKING_STOREFILES_KEY, "500");
            }
            if (this.splitSize != null) {
                htd.setConfiguration("hbase.store.stripe.sizeToSplit", this.splitSize.toString());
            }
            if (this.splitParts != null) {
                htd.setConfiguration("hbase.store.stripe.splitPartCount", this.splitParts.toString());
            }
        } else {
            htd.setConfiguration(HStore.BLOCKING_STOREFILES_KEY, "10");
        }
        return htd;
    }

    protected void createTable(HTableDescriptor htd) throws Exception {
        this.deleteTable();
        if (this.util.getHBaseClusterInterface() instanceof MiniHBaseCluster) {
            LOG.warn("Test does not make a lot of sense for minicluster. Will set flush size low.");
            htd.setConfiguration(HConstants.HREGION_MEMSTORE_FLUSH_SIZE, "1048576");
        }
        byte[][] splits = new RegionSplitter.HexStringSplit().split(this.util.getHBaseClusterInterface().getClusterMetrics().getLiveServerMetrics().size());
        this.util.getAdmin().createTable((TableDescriptor)htd, splits);
    }

    public static class SeqShardedDataGenerator
    extends LoadTestDataGenerator {
        private static final byte[][] COLUMN_NAMES = new byte[][]{Bytes.toBytes((String)"col1")};
        private static final int PAD_TO = 10;
        private static final int PREFIX_PAD_TO = 7;
        private final int numPartitions;

        public SeqShardedDataGenerator(int minValueSize, int maxValueSize, int numPartitions) {
            super(minValueSize, maxValueSize);
            this.numPartitions = numPartitions;
        }

        public byte[] getDeterministicUniqueKey(long keyBase) {
            String num = StringUtils.leftPad((String)String.valueOf(keyBase), (int)10, (String)"0");
            return Bytes.toBytes((String)(this.getPrefix(keyBase) + num));
        }

        private String getPrefix(long i) {
            return StringUtils.leftPad((String)String.valueOf((int)(i % (long)this.numPartitions)), (int)7, (String)"0");
        }

        public byte[][] getColumnFamilies() {
            return new byte[][]{COLUMN_FAMILY};
        }

        public byte[][] generateColumnsForCf(byte[] rowKey, byte[] cf) {
            return COLUMN_NAMES;
        }

        public byte[] generateValue(byte[] rowKey, byte[] cf, byte[] column) {
            return this.kvGenerator.generateRandomSizeValue((byte[][])new byte[][]{rowKey, cf, column});
        }

        public boolean verify(byte[] rowKey, byte[] cf, byte[] column, byte[] value) {
            return LoadTestKVGenerator.verify((byte[])value, (byte[][])new byte[][]{rowKey, cf, column});
        }

        public boolean verify(byte[] rowKey, byte[] cf, Set<byte[]> columnSet) {
            return true;
        }
    }
}

