/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.master.assignment.RegionStates;
import org.apache.hadoop.hbase.master.assignment.ServerState;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.RSProcedureDispatcher;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.AbstractProcedureScheduler;
import org.apache.hadoop.hbase.procedure2.FailedRemoteDispatchException;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureEvent;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureUtil;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.RemoteProcedureDispatcher;
import org.apache.hadoop.hbase.procedure2.RemoteProcedureException;
import org.apache.hadoop.hbase.regionserver.FlushRegionCallable;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.util.RetryCounter;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class FlushRegionProcedure
extends Procedure<MasterProcedureEnv>
implements TableProcedureInterface,
RemoteProcedureDispatcher.RemoteProcedure<MasterProcedureEnv, ServerName> {
    private static final Logger LOG = LoggerFactory.getLogger(FlushRegionProcedure.class);
    private RegionInfo region;
    private List<byte[]> columnFamilies;
    private ProcedureEvent<?> event;
    private boolean dispatched;
    private boolean succ;
    private RetryCounter retryCounter;

    public FlushRegionProcedure() {
    }

    public FlushRegionProcedure(RegionInfo region) {
        this(region, null);
    }

    public FlushRegionProcedure(RegionInfo region, List<byte[]> columnFamilies) {
        this.region = region;
        this.columnFamilies = columnFamilies;
    }

    protected Procedure<MasterProcedureEnv>[] execute(MasterProcedureEnv env) throws ProcedureYieldException, ProcedureSuspendedException, InterruptedException {
        RegionStates regionStates;
        RegionStateNode regionNode;
        if (this.dispatched) {
            if (this.succ) {
                return null;
            }
            this.dispatched = false;
        }
        if ((regionNode = (regionStates = env.getAssignmentManager().getRegionStates()).getRegionStateNode(this.region)) == null) {
            LOG.debug("Region {} is not in region states, it is very likely that it has been cleared by other procedures such as merge or split, so skip {}. See HBASE-28226", (Object)this.region, (Object)this);
            return null;
        }
        regionNode.lock();
        try {
            if (!regionNode.isInState(RegionState.State.OPEN) || regionNode.isInTransition()) {
                LOG.info("State of region {} is not OPEN or in transition. Skip {} ...", (Object)this.region, (Object)this);
                Procedure<MasterProcedureEnv>[] procedureArray = null;
                return procedureArray;
            }
            ServerName targetServer = regionNode.getRegionLocation();
            if (targetServer == null) {
                this.setTimeoutForSuspend(env, String.format("target server of region %s is null", this.region.getRegionNameAsString()));
                throw new ProcedureSuspendedException();
            }
            ServerState serverState = regionStates.getServerNode(targetServer).getState();
            if (serverState != ServerState.ONLINE) {
                this.setTimeoutForSuspend(env, String.format("target server of region %s %s is in state %s", new Object[]{this.region.getRegionNameAsString(), targetServer, serverState}));
                throw new ProcedureSuspendedException();
            }
            try {
                env.getRemoteDispatcher().addOperationToNode((Comparable)targetServer, this);
                this.dispatched = true;
                this.event = new ProcedureEvent((Object)this);
                this.event.suspendIfNotReady((Procedure)this);
                throw new ProcedureSuspendedException();
            }
            catch (FailedRemoteDispatchException e) {
                this.setTimeoutForSuspend(env, "Failed send request to " + targetServer);
                throw new ProcedureSuspendedException();
            }
        }
        finally {
            regionNode.unlock();
        }
    }

    protected synchronized boolean setTimeoutFailure(MasterProcedureEnv env) {
        this.setState(ProcedureProtos.ProcedureState.RUNNABLE);
        env.getProcedureScheduler().addFront(this);
        return false;
    }

    protected void rollback(MasterProcedureEnv env) throws IOException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    protected boolean abort(MasterProcedureEnv env) {
        return false;
    }

    public void remoteCallFailed(MasterProcedureEnv env, ServerName serverName, IOException e) {
        this.complete(env, e);
    }

    public void remoteOperationCompleted(MasterProcedureEnv env) {
        this.complete(env, null);
    }

    public void remoteOperationFailed(MasterProcedureEnv env, RemoteProcedureException error) {
        this.complete(env, (Throwable)error);
    }

    private void complete(MasterProcedureEnv env, Throwable error) {
        if (this.isFinished()) {
            LOG.info("This procedure {} is already finished, skip the rest processes", (Object)this.getProcId());
            return;
        }
        if (this.event == null) {
            LOG.warn("procedure event for {} is null, maybe the procedure is created when recovery", (Object)this.getProcId());
            return;
        }
        if (error == null) {
            this.succ = true;
        }
        this.event.wake((AbstractProcedureScheduler)env.getProcedureScheduler());
        this.event = null;
    }

    private void setTimeoutForSuspend(MasterProcedureEnv env, String reason) {
        if (this.retryCounter == null) {
            this.retryCounter = ProcedureUtil.createRetryCounter((Configuration)env.getMasterConfiguration());
        }
        long backoff = this.retryCounter.getBackoffTimeAndIncrementAttempts();
        LOG.warn("{} can not run currently because {}, wait {} ms to retry", new Object[]{this, reason, backoff});
        this.setTimeout(Math.toIntExact(backoff));
        this.setState(ProcedureProtos.ProcedureState.WAITING_TIMEOUT);
        this.skipPersistence();
    }

    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        MasterProcedureProtos.FlushRegionProcedureStateData.Builder builder = MasterProcedureProtos.FlushRegionProcedureStateData.newBuilder();
        builder.setRegion(ProtobufUtil.toRegionInfo((RegionInfo)this.region));
        if (this.columnFamilies != null) {
            for (byte[] columnFamily : this.columnFamilies) {
                if (columnFamily == null || columnFamily.length <= 0) continue;
                builder.addColumnFamily(UnsafeByteOperations.unsafeWrap((byte[])columnFamily));
            }
        }
        serializer.serialize((Message)builder.build());
    }

    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        MasterProcedureProtos.FlushRegionProcedureStateData data = (MasterProcedureProtos.FlushRegionProcedureStateData)serializer.deserialize(MasterProcedureProtos.FlushRegionProcedureStateData.class);
        this.region = ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)data.getRegion());
        if (data.getColumnFamilyCount() > 0) {
            this.columnFamilies = data.getColumnFamilyList().stream().filter(cf -> !cf.isEmpty()).map(ByteString::toByteArray).collect(Collectors.toList());
        }
    }

    public Optional<RemoteProcedureDispatcher.RemoteOperation> remoteCallBuild(MasterProcedureEnv env, ServerName serverName) {
        MasterProcedureProtos.FlushRegionParameter.Builder builder = MasterProcedureProtos.FlushRegionParameter.newBuilder();
        builder.setRegion(ProtobufUtil.toRegionInfo((RegionInfo)this.region));
        if (this.columnFamilies != null) {
            for (byte[] columnFamily : this.columnFamilies) {
                if (columnFamily == null || columnFamily.length <= 0) continue;
                builder.addColumnFamily(UnsafeByteOperations.unsafeWrap((byte[])columnFamily));
            }
        }
        return Optional.of(new RSProcedureDispatcher.ServerOperation(this, this.getProcId(), FlushRegionCallable.class, builder.build().toByteArray(), env.getMasterServices().getMasterActiveTime()));
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.FLUSH;
    }

    protected boolean waitInitialized(MasterProcedureEnv env) {
        return env.waitInitialized(this);
    }

    @Override
    public TableName getTableName() {
        return this.region.getTable();
    }
}

