/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.master.procedure.DeleteTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureTestingUtility;
import org.apache.hadoop.hbase.master.procedure.TestTableDDLProcedureBase;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MasterTests.class, MediumTests.class})
public class TestDeleteTableProcedureWithRecovery
extends TestTableDDLProcedureBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestDeleteTableProcedureWithRecovery.class);
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setupCluster() throws Exception {
        UTIL.getConfiguration().setBoolean("hbase.snapshot.before.destructive.action.enabled", true);
        TestTableDDLProcedureBase.setupCluster();
    }

    @Test
    public void testRecoverySnapshotRollback() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        String[] families = new String[]{"f1", "f2"};
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        MasterProcedureTestingUtility.createTable(procExec, tableName, null, families);
        MasterProcedureTestingUtility.loadData(UTIL.getConnection(), tableName, 100, new byte[0][], families);
        UTIL.getAdmin().disableTable(tableName);
        long procId = procExec.submitProcedure((Procedure)new FailingDeleteTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        Procedure result = procExec.getResult(procId);
        Assert.assertTrue((String)"Procedure should have failed", (boolean)result.isFailed());
        boolean snapshotFound = false;
        for (SnapshotDescription snapshot : UTIL.getAdmin().listSnapshots()) {
            if (!snapshot.getName().startsWith("auto_" + tableName.getNameAsString())) continue;
            snapshotFound = true;
            break;
        }
        Assert.assertTrue((String)"Recovery snapshot should have been cleaned up during rollback", (!snapshotFound ? 1 : 0) != 0);
    }

    @Test
    public void testRecoverySnapshotAndRestore() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TableName restoredTableName = TableName.valueOf((String)(this.name.getMethodName() + "_restored"));
        String[] families = new String[]{"f1", "f2"};
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        MasterProcedureTestingUtility.createTable(procExec, tableName, null, families);
        MasterProcedureTestingUtility.loadData(UTIL.getConnection(), tableName, 100, new byte[0][], families);
        UTIL.getAdmin().disableTable(tableName);
        long procId = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new DeleteTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName));
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId);
        MasterProcedureTestingUtility.validateTableDeletion(this.getMaster(), tableName);
        String recoverySnapshotName = null;
        for (SnapshotDescription snapshot : UTIL.getAdmin().listSnapshots()) {
            if (!snapshot.getName().startsWith("auto_" + tableName.getNameAsString())) continue;
            recoverySnapshotName = snapshot.getName();
            break;
        }
        Assert.assertTrue((String)"Recovery snapshot should exist", (recoverySnapshotName != null ? 1 : 0) != 0);
        UTIL.getAdmin().cloneSnapshot(recoverySnapshotName, restoredTableName);
        UTIL.waitUntilAllRegionsAssigned(restoredTableName);
        Assert.assertEquals((long)100L, (long)UTIL.countRows(restoredTableName));
        UTIL.getAdmin().disableTable(restoredTableName);
        UTIL.getAdmin().deleteTable(restoredTableName);
    }

    public static class FailingDeleteTableProcedure
    extends DeleteTableProcedure {
        private boolean failOnce = false;

        public FailingDeleteTableProcedure() {
        }

        public FailingDeleteTableProcedure(MasterProcedureEnv env, TableName tableName) {
            super(env, tableName);
        }

        protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.DeleteTableState state) throws InterruptedException, ProcedureSuspendedException {
            if (!this.failOnce && state == MasterProcedureProtos.DeleteTableState.DELETE_TABLE_CLEAR_FS_LAYOUT) {
                this.failOnce = true;
                throw new RuntimeException("Simulated failure");
            }
            return super.executeFromState(env, state);
        }
    }
}

