/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.ExportSnapshot;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestExportSnapshotHelpers {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestExportSnapshotHelpers.class);

    @Test
    public void testBalanceSplit() {
        ArrayList<Pair> files = new ArrayList<Pair>(21);
        for (long i = 0L; i <= 20L; ++i) {
            SnapshotProtos.SnapshotFileInfo fileInfo = SnapshotProtos.SnapshotFileInfo.newBuilder().setType(SnapshotProtos.SnapshotFileInfo.Type.HFILE).setHfile("file-" + i).build();
            files.add(new Pair((Object)fileInfo, (Object)i));
        }
        List splits = ExportSnapshot.getBalancedSplits(files, (int)5);
        Assert.assertEquals((long)5L, (long)splits.size());
        String[] split0 = new String[]{"file-20", "file-11", "file-10", "file-1", "file-0"};
        this.verifyBalanceSplit((List)splits.get(0), split0, 42L);
        String[] split1 = new String[]{"file-19", "file-12", "file-9", "file-2"};
        this.verifyBalanceSplit((List)splits.get(1), split1, 42L);
        String[] split2 = new String[]{"file-18", "file-13", "file-8", "file-3"};
        this.verifyBalanceSplit((List)splits.get(2), split2, 42L);
        String[] split3 = new String[]{"file-17", "file-14", "file-7", "file-4"};
        this.verifyBalanceSplit((List)splits.get(3), split3, 42L);
        String[] split4 = new String[]{"file-16", "file-15", "file-6", "file-5"};
        this.verifyBalanceSplit((List)splits.get(4), split4, 42L);
    }

    private void verifyBalanceSplit(List<Pair<SnapshotProtos.SnapshotFileInfo, Long>> split, String[] expected, long expectedSize) {
        Assert.assertEquals((long)expected.length, (long)split.size());
        long totalSize = 0L;
        for (int i = 0; i < expected.length; ++i) {
            Pair<SnapshotProtos.SnapshotFileInfo, Long> fileInfo = split.get(i);
            Assert.assertEquals((Object)expected[i], (Object)((SnapshotProtos.SnapshotFileInfo)fileInfo.getFirst()).getHfile());
            totalSize += ((Long)fileInfo.getSecond()).longValue();
        }
        Assert.assertEquals((long)expectedSize, (long)totalSize);
    }

    @Test
    public void testGroupFilesForSplitsWithoutCustomFileGrouper() {
        ArrayList<Pair> files = new ArrayList<Pair>();
        for (long i = 0L; i < 10L; ++i) {
            SnapshotProtos.SnapshotFileInfo fileInfo = SnapshotProtos.SnapshotFileInfo.newBuilder().setType(SnapshotProtos.SnapshotFileInfo.Type.HFILE).setHfile("file-" + i).build();
            files.add(new Pair((Object)fileInfo, (Object)(i * 10L)));
        }
        Configuration conf = new Configuration();
        conf.setInt("snapshot.export.format.splits", 3);
        ExportSnapshot.ExportSnapshotInputFormat inputFormat = new ExportSnapshot.ExportSnapshotInputFormat();
        Collection groups = inputFormat.groupFilesForSplits(conf, files);
        Assert.assertEquals((String)"Should create 3 groups", (long)3L, (long)groups.size());
        long totalSize = 0L;
        int totalFiles = 0;
        for (List group : groups) {
            for (Pair file : group) {
                totalSize += ((Long)file.getSecond()).longValue();
                ++totalFiles;
            }
        }
        Assert.assertEquals((String)"All files should be included", (long)10L, (long)totalFiles);
        Assert.assertEquals((String)"Total size should be preserved", (long)450L, (long)totalSize);
    }

    @Test
    public void testGroupFilesForSplitsWithCustomFileGrouper() {
        ArrayList<Pair> files = new ArrayList<Pair>();
        for (long i = 0L; i < 8L; ++i) {
            SnapshotProtos.SnapshotFileInfo fileInfo = SnapshotProtos.SnapshotFileInfo.newBuilder().setType(SnapshotProtos.SnapshotFileInfo.Type.HFILE).setHfile("file-" + i).build();
            files.add(new Pair((Object)fileInfo, (Object)(i * 5L)));
        }
        Configuration conf = new Configuration();
        conf.setInt("snapshot.export.format.splits", 4);
        conf.setClass("snapshot.export.input.file.grouper.class", TestCustomFileGrouper.class, ExportSnapshot.CustomFileGrouper.class);
        ExportSnapshot.ExportSnapshotInputFormat inputFormat = new ExportSnapshot.ExportSnapshotInputFormat();
        Collection groups = inputFormat.groupFilesForSplits(conf, files);
        Assert.assertEquals((String)"Should create splits based on custom grouper output", (long)4L, (long)groups.size());
        long totalSize = 0L;
        int totalFiles = 0;
        for (List group : groups) {
            for (Pair file : group) {
                totalSize += ((Long)file.getSecond()).longValue();
                ++totalFiles;
            }
        }
        Assert.assertEquals((String)"All files should be included", (long)8L, (long)totalFiles);
        Assert.assertEquals((String)"Total size should be preserved", (long)140L, (long)totalSize);
    }

    @Test
    public void testFileLocationResolverWithNoopResolver() {
        ArrayList<Pair> files = new ArrayList<Pair>();
        for (long i = 0L; i < 3L; ++i) {
            SnapshotProtos.SnapshotFileInfo fileInfo = SnapshotProtos.SnapshotFileInfo.newBuilder().setType(SnapshotProtos.SnapshotFileInfo.Type.HFILE).setHfile("file-" + i).build();
            files.add(new Pair((Object)fileInfo, (Object)(i * 10L)));
        }
        ExportSnapshot.NoopFileLocationResolver resolver = new ExportSnapshot.NoopFileLocationResolver();
        Set locations = resolver.getLocationsForInputFiles(files);
        Assert.assertTrue((String)"NoopFileLocationResolver should return empty locations", (boolean)locations.isEmpty());
    }

    @Test
    public void testFileLocationResolverWithCustomResolver() {
        ArrayList<Pair<SnapshotProtos.SnapshotFileInfo, Long>> files = new ArrayList<Pair<SnapshotProtos.SnapshotFileInfo, Long>>();
        for (long i = 0L; i < 3L; ++i) {
            SnapshotProtos.SnapshotFileInfo fileInfo = SnapshotProtos.SnapshotFileInfo.newBuilder().setType(SnapshotProtos.SnapshotFileInfo.Type.HFILE).setHfile("file-" + i).build();
            files.add((Pair<SnapshotProtos.SnapshotFileInfo, Long>)new Pair((Object)fileInfo, (Object)(i * 10L)));
        }
        TestFileLocationResolver resolver = new TestFileLocationResolver();
        Set<String> locations = resolver.getLocationsForInputFiles(files);
        Assert.assertEquals((String)"Should return expected locations", (long)2L, (long)locations.size());
        Assert.assertTrue((String)"Should contain rack1", (boolean)locations.contains("rack1"));
        Assert.assertTrue((String)"Should contain rack2", (boolean)locations.contains("rack2"));
    }

    @Test
    public void testInputSplitWithFileLocationResolver() {
        ArrayList<Pair> files = new ArrayList<Pair>();
        for (long i = 0L; i < 3L; ++i) {
            SnapshotProtos.SnapshotFileInfo fileInfo = SnapshotProtos.SnapshotFileInfo.newBuilder().setType(SnapshotProtos.SnapshotFileInfo.Type.HFILE).setHfile("file-" + i).build();
            files.add(new Pair((Object)fileInfo, (Object)(i * 10L)));
        }
        TestFileLocationResolver resolver = new TestFileLocationResolver();
        ExportSnapshot.ExportSnapshotInputFormat.ExportSnapshotInputSplit split = new ExportSnapshot.ExportSnapshotInputFormat.ExportSnapshotInputSplit(files, (ExportSnapshot.FileLocationResolver)resolver);
        try {
            String[] locations = split.getLocations();
            Assert.assertEquals((String)"Should return 2 locations", (long)2L, (long)locations.length);
            boolean hasRack1 = false;
            boolean hasRack2 = false;
            for (String location : locations) {
                if ("rack1".equals(location)) {
                    hasRack1 = true;
                }
                if (!"rack2".equals(location)) continue;
                hasRack2 = true;
            }
            Assert.assertTrue((String)"Should contain rack1", (boolean)hasRack1);
            Assert.assertTrue((String)"Should contain rack2", (boolean)hasRack2);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get locations", e);
        }
    }

    public static class TestFileLocationResolver
    implements ExportSnapshot.FileLocationResolver {
        public Set<String> getLocationsForInputFiles(Collection<Pair<SnapshotProtos.SnapshotFileInfo, Long>> files) {
            HashSet<String> locations = new HashSet<String>();
            locations.add("rack1");
            locations.add("rack2");
            return locations;
        }
    }

    public static class TestCustomFileGrouper
    implements ExportSnapshot.CustomFileGrouper {
        public Collection<Collection<Pair<SnapshotProtos.SnapshotFileInfo, Long>>> getGroupedInputFiles(Collection<Pair<SnapshotProtos.SnapshotFileInfo, Long>> snapshotFiles) {
            ArrayList<Collection<Pair<SnapshotProtos.SnapshotFileInfo, Long>>> groups = new ArrayList<Collection<Pair<SnapshotProtos.SnapshotFileInfo, Long>>>();
            ArrayList<Pair<SnapshotProtos.SnapshotFileInfo, Long>> group1 = new ArrayList<Pair<SnapshotProtos.SnapshotFileInfo, Long>>();
            ArrayList<Pair<SnapshotProtos.SnapshotFileInfo, Long>> group2 = new ArrayList<Pair<SnapshotProtos.SnapshotFileInfo, Long>>();
            int count = 0;
            for (Pair<SnapshotProtos.SnapshotFileInfo, Long> file : snapshotFiles) {
                if (count % 2 == 0) {
                    group1.add(file);
                } else {
                    group2.add(file);
                }
                ++count;
            }
            groups.add(group1);
            groups.add(group2);
            return groups;
        }
    }
}

