/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.nfs.nfs3.request;

import java.io.IOException;
import org.apache.hadoop.nfs.nfs3.FileHandle;
import org.apache.hadoop.nfs.nfs3.request.RequestWithHandle;
import org.apache.hadoop.oncrpc.XDR;

public class READDIRPLUS3Request
extends RequestWithHandle {
    private final long cookie;
    private final long cookieVerf;
    private final int dirCount;
    private final int maxCount;

    public static READDIRPLUS3Request deserialize(XDR xdr) throws IOException {
        FileHandle handle = READDIRPLUS3Request.readHandle(xdr);
        long cookie = xdr.readHyper();
        long cookieVerf = xdr.readHyper();
        int dirCount = xdr.readInt();
        int maxCount = xdr.readInt();
        return new READDIRPLUS3Request(handle, cookie, cookieVerf, dirCount, maxCount);
    }

    public READDIRPLUS3Request(FileHandle handle, long cookie, long cookieVerf, int dirCount, int maxCount) {
        super(handle);
        this.cookie = cookie;
        this.cookieVerf = cookieVerf;
        this.dirCount = dirCount;
        this.maxCount = maxCount;
    }

    public long getCookie() {
        return this.cookie;
    }

    public long getCookieVerf() {
        return this.cookieVerf;
    }

    public int getDirCount() {
        return this.dirCount;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    @Override
    public void serialize(XDR xdr) {
        this.handle.serialize(xdr);
        xdr.writeLongAsHyper(this.cookie);
        xdr.writeLongAsHyper(this.cookieVerf);
        xdr.writeInt(this.dirCount);
        xdr.writeInt(this.maxCount);
    }
}

