/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueUpdateWarning;

public class QueueCapacityUpdateContext {
    private final Resource updatedClusterResource;
    private final RMNodeLabelsManager labelsManager;
    private final List<QueueUpdateWarning> warnings = new ArrayList<QueueUpdateWarning>();

    public QueueCapacityUpdateContext(Resource updatedClusterResource, RMNodeLabelsManager labelsManager) {
        this.updatedClusterResource = updatedClusterResource;
        this.labelsManager = labelsManager;
    }

    public Resource getUpdatedClusterResource(String label) {
        return this.labelsManager.getResourceByLabel(label, this.updatedClusterResource);
    }

    public Resource getUpdatedClusterResource() {
        return this.updatedClusterResource;
    }

    public void addUpdateWarning(QueueUpdateWarning warning) {
        this.warnings.add(warning);
    }

    public List<QueueUpdateWarning> getUpdateWarnings() {
        return this.warnings;
    }
}

