/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.hadoop.fs.s3a.S3AStore;
import org.apache.hadoop.fs.s3a.impl.S3AFileSystemOperations;
import org.apache.hadoop.fs.s3a.impl.streams.ObjectInputStreamCallbacks;
import org.apache.hadoop.fs.store.audit.AuditSpan;
import org.apache.hadoop.util.LambdaUtils;
import org.apache.hadoop.util.functional.CallableRaisingIOE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;

public class InputStreamCallbacksImpl
implements ObjectInputStreamCallbacks {
    private static final Logger LOG = LoggerFactory.getLogger(InputStreamCallbacksImpl.class);
    private final AuditSpan auditSpan;
    private final S3AStore store;
    private final S3AFileSystemOperations fsOperations;
    private final ThreadPoolExecutor threadPool;

    public InputStreamCallbacksImpl(AuditSpan auditSpan, S3AStore store, S3AFileSystemOperations fsOperations, ThreadPoolExecutor threadPool) {
        this.auditSpan = Objects.requireNonNull(auditSpan);
        this.store = Objects.requireNonNull(store);
        this.fsOperations = Objects.requireNonNull(fsOperations);
        this.threadPool = Objects.requireNonNull(threadPool);
    }

    @Override
    public void close() {
        this.auditSpan.close();
    }

    @Override
    public GetObjectRequest.Builder newGetRequestBuilder(String key) {
        try (AuditSpan span = this.auditSpan.activate();){
            GetObjectRequest.Builder builder = this.store.getRequestFactory().newGetObjectRequestBuilder(key);
            return builder;
        }
    }

    @Override
    public ResponseInputStream<GetObjectResponse> getObject(GetObjectRequest request) throws IOException {
        try (AuditSpan span = this.auditSpan.activate();){
            ResponseInputStream<GetObjectResponse> responseInputStream = this.fsOperations.getObject(this.store, request, this.store.getRequestFactory());
            return responseInputStream;
        }
    }

    @Override
    public <T> CompletableFuture<T> submit(CallableRaisingIOE<T> operation) {
        CompletableFuture result = new CompletableFuture();
        this.threadPool.submit(() -> LambdaUtils.eval((CompletableFuture)result, () -> {
            LOG.debug("Starting submitted operation in {}", (Object)this.auditSpan.getSpanId());
            try {
                try (AuditSpan span = this.auditSpan.activate();){
                    Object object = operation.apply();
                    return object;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                LOG.debug("Completed submitted operation in {}", (Object)this.auditSpan.getSpanId());
            }
        }));
        return result;
    }
}

