/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity;

import com.microsoft.azure.cosmosdb.BridgeInternal;
import com.microsoft.azure.cosmosdb.DocumentClientException;
import com.microsoft.azure.cosmosdb.Error;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.HttpUtils;
import io.reactivex.netty.protocol.http.client.HttpResponseHeaders;
import java.util.Map;

public class ConflictException
extends DocumentClientException {
    private static final long serialVersionUID = 1L;

    public ConflictException() {
        this("Entity with the specified id already exists in the system.");
    }

    public ConflictException(Error error, long lsn, String partitionKeyRangeId, Map<String, String> responseHeaders) {
        super(409, error, responseHeaders);
        BridgeInternal.setLSN((DocumentClientException)this, (long)lsn);
        BridgeInternal.setPartitionKeyRangeId((DocumentClientException)this, (String)partitionKeyRangeId);
    }

    public ConflictException(String msg) {
        super(409, msg);
    }

    public ConflictException(String msg, String resourceAddress) {
        super(msg, null, null, 409, resourceAddress);
    }

    public ConflictException(String message, HttpResponseHeaders headers, String requestUri) {
        this(message, null, headers, requestUri);
    }

    public ConflictException(Exception innerException) {
        this("Entity with the specified id already exists in the system.", innerException, null, null);
    }

    public ConflictException(Error error, Map<String, String> headers) {
        super(409, error, headers);
    }

    public ConflictException(String message, Exception innerException, HttpResponseHeaders headers, String requestUri) {
        super(String.format("%s: %s", "Entity with the specified id already exists in the system.", message), innerException, HttpUtils.asMap((HttpResponseHeaders)headers), 409, requestUri);
    }
}

