/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.microsoft.sqlserver.jdbc;

import org.apache.hadoop.shaded.com.microsoft.sqlserver.jdbc.SQLServerException;
import org.apache.hadoop.shaded.com.microsoft.sqlserver.jdbc.StreamDone;
import org.apache.hadoop.shaded.com.microsoft.sqlserver.jdbc.StreamError;
import org.apache.hadoop.shaded.com.microsoft.sqlserver.jdbc.StreamRetStatus;
import org.apache.hadoop.shaded.com.microsoft.sqlserver.jdbc.TDSParser;
import org.apache.hadoop.shaded.com.microsoft.sqlserver.jdbc.TDSReader;

class TDSTokenHandler {
    final String logContext;
    private StreamError databaseError;

    final StreamError getDatabaseError() {
        return this.databaseError;
    }

    TDSTokenHandler(String logContext) {
        this.logContext = logContext;
    }

    boolean onSSPI(TDSReader tdsReader) throws SQLServerException {
        TDSParser.throwUnexpectedTokenException(tdsReader, this.logContext);
        return false;
    }

    boolean onLoginAck(TDSReader tdsReader) throws SQLServerException {
        TDSParser.throwUnexpectedTokenException(tdsReader, this.logContext);
        return false;
    }

    boolean onFeatureExtensionAck(TDSReader tdsReader) throws SQLServerException {
        TDSParser.throwUnexpectedTokenException(tdsReader, this.logContext);
        return false;
    }

    boolean onEnvChange(TDSReader tdsReader) throws SQLServerException {
        tdsReader.getConnection().processEnvChange(tdsReader);
        return true;
    }

    boolean onRetStatus(TDSReader tdsReader) throws SQLServerException {
        new StreamRetStatus().setFromTDS(tdsReader);
        return true;
    }

    boolean onRetValue(TDSReader tdsReader) throws SQLServerException {
        TDSParser.throwUnexpectedTokenException(tdsReader, this.logContext);
        return false;
    }

    boolean onDone(TDSReader tdsReader) throws SQLServerException {
        StreamDone doneToken = new StreamDone();
        doneToken.setFromTDS(tdsReader);
        return true;
    }

    boolean onError(TDSReader tdsReader) throws SQLServerException {
        if (null == this.databaseError) {
            this.databaseError = new StreamError();
            this.databaseError.setFromTDS(tdsReader);
        } else {
            new StreamError().setFromTDS(tdsReader);
        }
        return true;
    }

    boolean onInfo(TDSReader tdsReader) throws SQLServerException {
        TDSParser.ignoreLengthPrefixedToken(tdsReader);
        return true;
    }

    boolean onOrder(TDSReader tdsReader) throws SQLServerException {
        TDSParser.ignoreLengthPrefixedToken(tdsReader);
        return true;
    }

    boolean onColMetaData(TDSReader tdsReader) throws SQLServerException {
        TDSParser.throwUnexpectedTokenException(tdsReader, this.logContext);
        return false;
    }

    boolean onRow(TDSReader tdsReader) throws SQLServerException {
        TDSParser.throwUnexpectedTokenException(tdsReader, this.logContext);
        return false;
    }

    boolean onNBCRow(TDSReader tdsReader) throws SQLServerException {
        TDSParser.throwUnexpectedTokenException(tdsReader, this.logContext);
        return false;
    }

    boolean onColInfo(TDSReader tdsReader) throws SQLServerException {
        TDSParser.ignoreLengthPrefixedToken(tdsReader);
        return true;
    }

    boolean onTabName(TDSReader tdsReader) throws SQLServerException {
        TDSParser.ignoreLengthPrefixedToken(tdsReader);
        return true;
    }

    void onEOF(TDSReader tdsReader) throws SQLServerException {
        if (null != this.getDatabaseError()) {
            SQLServerException.makeFromDatabaseError(tdsReader.getConnection(), null, this.getDatabaseError().getMessage(), this.getDatabaseError(), false);
        }
    }

    boolean onFedAuthInfo(TDSReader tdsReader) throws SQLServerException {
        tdsReader.getConnection().processFedAuthInfo(tdsReader, this);
        return true;
    }
}

