/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.Schedulable;

public final class ComputeFairShares {
    private static final int COMPUTE_FAIR_SHARES_ITERATIONS = 25;

    private ComputeFairShares() {
    }

    public static void computeShares(Collection<? extends Schedulable> schedulables, Resource totalResources, String type) {
        ComputeFairShares.computeSharesInternal(schedulables, totalResources, type, false);
    }

    public static void computeSteadyShares(Collection<? extends FSQueue> queues, Resource totalResources, String type) {
        ComputeFairShares.computeSharesInternal(queues, totalResources, type, true);
    }

    private static void computeSharesInternal(Collection<? extends Schedulable> allSchedulables, Resource totalResources, String type, boolean isSteadyShare) {
        Schedulable sched;
        long maxShare;
        ArrayList<Schedulable> schedulables = new ArrayList<Schedulable>();
        long takenResources = ComputeFairShares.handleFixedFairShares(allSchedulables, schedulables, isSteadyShare, type);
        if (schedulables.isEmpty()) {
            return;
        }
        long totalMaxShare = 0L;
        Iterator iterator = schedulables.iterator();
        while (iterator.hasNext() && (totalMaxShare = ComputeFairShares.safeAdd(maxShare = (sched = (Schedulable)iterator.next()).getMaxShare().getResourceValue(type), totalMaxShare)) != Long.MAX_VALUE) {
        }
        long totalResource = Math.max(totalResources.getResourceValue(type) - takenResources, 0L);
        totalResource = Math.min(totalMaxShare, totalResource);
        double rMax = 1.0;
        while (ComputeFairShares.resourceUsedWithWeightToResourceRatio(rMax, schedulables, type) < totalResource) {
            rMax *= 2.0;
        }
        double left = 0.0;
        double right = rMax;
        for (int i = 0; i < 25; ++i) {
            double mid = (left + right) / 2.0;
            long plannedResourceUsed = ComputeFairShares.resourceUsedWithWeightToResourceRatio(mid, schedulables, type);
            if (plannedResourceUsed == totalResource) {
                right = mid;
                break;
            }
            if (plannedResourceUsed < totalResource) {
                left = mid;
                continue;
            }
            right = mid;
        }
        for (Schedulable sched2 : schedulables) {
            Resource target = isSteadyShare ? ((FSQueue)sched2).getSteadyFairShare() : sched2.getFairShare();
            target.setResourceValue(type, ComputeFairShares.computeShare(sched2, right, type));
        }
    }

    private static long resourceUsedWithWeightToResourceRatio(double w2rRatio, Collection<? extends Schedulable> schedulables, String type) {
        Schedulable sched;
        long share;
        long resourcesTaken = 0L;
        Iterator<? extends Schedulable> iterator = schedulables.iterator();
        while (iterator.hasNext() && (resourcesTaken = ComputeFairShares.safeAdd(resourcesTaken, share = ComputeFairShares.computeShare(sched = iterator.next(), w2rRatio, type))) != Long.MAX_VALUE) {
        }
        return resourcesTaken;
    }

    private static long computeShare(Schedulable sched, double w2rRatio, String type) {
        double share = (double)sched.getWeight() * w2rRatio;
        share = Math.max(share, (double)sched.getMinShare().getResourceValue(type));
        share = Math.min(share, (double)sched.getMaxShare().getResourceValue(type));
        return (long)share;
    }

    private static long handleFixedFairShares(Collection<? extends Schedulable> schedulables, Collection<Schedulable> nonFixedSchedulables, boolean isSteadyShare, String type) {
        long totalResource = 0L;
        for (Schedulable schedulable : schedulables) {
            long fixedShare = ComputeFairShares.getFairShareIfFixed(schedulable, isSteadyShare, type);
            if (fixedShare < 0L) {
                nonFixedSchedulables.add(schedulable);
                continue;
            }
            Resource target = isSteadyShare ? ((FSQueue)schedulable).getSteadyFairShare() : schedulable.getFairShare();
            target.setResourceValue(type, fixedShare);
            totalResource = ComputeFairShares.safeAdd(totalResource, fixedShare);
        }
        return totalResource;
    }

    private static long getFairShareIfFixed(Schedulable sched, boolean isSteadyShare, String type) {
        if (sched.getMaxShare().getResourceValue(type) <= 0L) {
            return 0L;
        }
        if (!isSteadyShare && sched instanceof FSQueue && !((FSQueue)sched).isActive()) {
            return 0L;
        }
        if (sched.getWeight() <= 0.0f) {
            long minShare = sched.getMinShare().getResourceValue(type);
            return minShare <= 0L ? 0L : minShare;
        }
        return -1L;
    }

    private static long safeAdd(long a, long b) {
        try {
            return Math.addExact(a, b);
        }
        catch (ArithmeticException ae) {
            return Long.MAX_VALUE;
        }
    }
}

