/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.locks;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.LockServiceDestroyedException;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.MessageWithReply;
import org.apache.geode.distributed.internal.PooledDistributionMessage;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.locks.DLockGrantor;
import org.apache.geode.distributed.internal.locks.DLockService;
import org.apache.geode.distributed.internal.locks.LockGrantorDestroyedException;
import org.apache.geode.distributed.internal.locks.LockGrantorId;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class NonGrantorDestroyedProcessor
extends ReplyProcessor21 {
    private static final Logger logger = LogService.getLogger();
    private NonGrantorDestroyedReplyMessage reply;

    static boolean send(String serviceName, LockGrantorId theLockGrantorId, DistributionManager dm) {
        InternalDistributedMember recipient = theLockGrantorId.getLockGrantorMember();
        NonGrantorDestroyedProcessor processor = new NonGrantorDestroyedProcessor(dm, recipient);
        NonGrantorDestroyedMessage.send(serviceName, recipient, dm, processor);
        try {
            processor.waitForRepliesUninterruptibly();
        }
        catch (ReplyException e) {
            e.handleCause();
        }
        return processor.informedGrantor();
    }

    private NonGrantorDestroyedProcessor(DistributionManager dm, InternalDistributedMember grantor) {
        super(dm, grantor);
    }

    @Override
    public void process(DistributionMessage msg) {
        try {
            Assert.assertTrue(msg instanceof NonGrantorDestroyedReplyMessage, "NonGrantorDestroyedProcessor is unable to process message of type " + msg.getClass());
            this.reply = (NonGrantorDestroyedReplyMessage)msg;
        }
        finally {
            super.process(msg);
        }
    }

    public boolean informedGrantor() {
        return this.reply != null && this.reply.isOK();
    }

    @Override
    protected boolean allowReplyFromSender() {
        return true;
    }

    public static class NonGrantorDestroyedReplyMessage
    extends ReplyMessage {
        public static final byte OK = 0;
        public static final byte NOT_GRANTOR = 1;
        private byte replyCode;

        public static void send(MessageWithReply destroyedMsg, byte replyCode, DistributionManager dm) {
            NonGrantorDestroyedReplyMessage m = new NonGrantorDestroyedReplyMessage();
            m.processorId = destroyedMsg.getProcessorId();
            m.setRecipient(destroyedMsg.getSender());
            m.replyCode = replyCode;
            if (dm.getId().equals(destroyedMsg.getSender())) {
                m.setSender(destroyedMsg.getSender());
                m.dmProcess(dm);
            } else {
                dm.putOutgoing(m);
            }
        }

        public boolean isOK() {
            return this.replyCode == 0;
        }

        public static String replyCodeToString(int replyCode) {
            String s = null;
            switch (replyCode) {
                case 0: {
                    s = "OK";
                    break;
                }
                case 1: {
                    s = "NOT_GRANTOR";
                    break;
                }
                default: {
                    s = "UNKNOWN:" + replyCode;
                }
            }
            return s;
        }

        @Override
        public int getDSFID() {
            return -70;
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            this.replyCode = in.readByte();
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            out.writeByte(this.replyCode);
        }

        @Override
        public String toString() {
            return "NonGrantorDestroyedReplyMessage; sender=" + this.getSender() + "; processorId=" + this.processorId + "; replyCode=" + NonGrantorDestroyedReplyMessage.replyCodeToString(this.replyCode) + ")";
        }
    }

    public static class NonGrantorDestroyedMessage
    extends PooledDistributionMessage
    implements MessageWithReply {
        private int processorId;
        private String serviceName;

        protected static void send(String serviceName, InternalDistributedMember grantor, DistributionManager dm, ReplyProcessor21 proc) {
            Assert.assertTrue(grantor != null, "Cannot send NonGrantorDestroyedMessage to null grantor");
            NonGrantorDestroyedMessage msg = new NonGrantorDestroyedMessage();
            msg.serviceName = serviceName;
            msg.processorId = proc.getProcessorId();
            msg.setRecipient(grantor);
            if (logger.isTraceEnabled(LogMarker.DLS_VERBOSE)) {
                logger.trace(LogMarker.DLS_VERBOSE, "NonGrantorDestroyedMessage sending {} to {}", (Object)msg, (Object)grantor);
            }
            if (grantor.equals(dm.getId())) {
                msg.setSender(dm.getId());
                msg.processLocally(dm);
            } else {
                dm.putOutgoing(msg);
            }
        }

        @Override
        public int getProcessorId() {
            return this.processorId;
        }

        private void reply(byte replyCode, DistributionManager dm) {
            NonGrantorDestroyedReplyMessage.send(this, replyCode, dm);
        }

        @Override
        protected void process(ClusterDistributionManager dm) {
            this.basicProcess(dm);
        }

        protected void processLocally(DistributionManager dm) {
            this.basicProcess(dm);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void basicProcess(DistributionManager dm) {
            boolean replied = false;
            try {
                DLockGrantor grantor;
                DLockService svc = DLockService.getInternalServiceNamed(this.serviceName);
                if (svc != null && svc.isCurrentlyOrIsMakingLockGrantor() && (grantor = DLockGrantor.waitForGrantor(svc)) != null) {
                    grantor.handleDepartureOf(this.getSender());
                    if (!grantor.isDestroyed()) {
                        this.reply((byte)0, dm);
                        replied = true;
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                if (logger.isTraceEnabled(LogMarker.DLS_VERBOSE)) {
                    logger.trace(LogMarker.DLS_VERBOSE, "Processing of NonGrantorDestroyedMessage resulted in InterruptedException", (Throwable)e);
                }
            }
            catch (LockServiceDestroyedException e) {
                if (logger.isTraceEnabled(LogMarker.DLS_VERBOSE)) {
                    logger.trace(LogMarker.DLS_VERBOSE, "Processing of NonGrantorDestroyedMessage resulted in LockServiceDestroyedException", (Throwable)e);
                }
            }
            catch (LockGrantorDestroyedException e) {
                if (logger.isTraceEnabled(LogMarker.DLS_VERBOSE)) {
                    logger.trace(LogMarker.DLS_VERBOSE, "Processing of NonGrantorDestroyedMessage resulted in LockGrantorDestroyedException", (Throwable)e);
                }
            }
            finally {
                if (!replied) {
                    this.reply((byte)1, dm);
                }
            }
        }

        public int getDSFID() {
            return 123;
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            this.processorId = in.readInt();
            this.serviceName = DataSerializer.readString(in);
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            out.writeInt(this.processorId);
            DataSerializer.writeString(this.serviceName, out);
        }

        @Override
        public String toString() {
            return "NonGrantorDestroyedMessage (serviceName='" + this.serviceName + "' processorId=" + this.processorId + ")";
        }
    }
}

