/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentCount;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.ConstantArgumentCount;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.Signature;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.StructuredType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.util.Preconditions;

@Internal
public final class ComparableTypeStrategy
implements InputTypeStrategy {
    private final StructuredType.StructuredComparison requiredComparison;
    private final ConstantArgumentCount argumentCount;

    public ComparableTypeStrategy(ConstantArgumentCount argumentCount, StructuredType.StructuredComparison requiredComparison) {
        Preconditions.checkArgument((boolean)argumentCount.getMinCount().map(c -> c >= 1).orElse(false), (String)"Comparable type strategy requires at least one argument. Actual minimal argument count: %s", (Object[])new Object[]{argumentCount.getMinCount().map(Objects::toString).orElse("<None>")});
        Preconditions.checkArgument((requiredComparison != StructuredType.StructuredComparison.NONE ? 1 : 0) != 0);
        this.requiredComparison = requiredComparison;
        this.argumentCount = argumentCount;
    }

    @Override
    public ArgumentCount getArgumentCount() {
        return this.argumentCount;
    }

    @Override
    public Optional<List<DataType>> inferInputTypes(CallContext callContext, boolean throwOnFailure) {
        List<DataType> argumentDataTypes = callContext.getArgumentDataTypes();
        if (argumentDataTypes.size() == 1) {
            LogicalType argType = argumentDataTypes.get(0).getLogicalType();
            if (!LogicalTypeChecks.areComparable(argType, argType, this.requiredComparison)) {
                return callContext.fail(throwOnFailure, "Type '%s' should support %s comparison with itself.", argType, this.comparisonToString());
            }
        } else {
            for (int i = 0; i < argumentDataTypes.size() - 1; ++i) {
                LogicalType secondType;
                LogicalType firstType = argumentDataTypes.get(i).getLogicalType();
                if (LogicalTypeChecks.areComparable(firstType, secondType = argumentDataTypes.get(i + 1).getLogicalType(), this.requiredComparison)) continue;
                return callContext.fail(throwOnFailure, "All types in a comparison should support %s comparison with each other. Can not compare %s with %s", this.comparisonToString(), firstType, secondType);
            }
        }
        return Optional.of(argumentDataTypes);
    }

    private String comparisonToString() {
        return this.requiredComparison == StructuredType.StructuredComparison.EQUALS ? "'EQUALS'" : "both 'EQUALS' and 'ORDER'";
    }

    @Override
    public List<Signature> getExpectedSignatures(FunctionDefinition definition) {
        return Collections.singletonList(Signature.of(Signature.Argument.ofGroupVarying("COMPARABLE")));
    }
}

