/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.util.Preconditions;

@Internal
public final class ArgumentMappingTypeStrategy
implements TypeStrategy {
    private final int pos;
    private final Function<DataType, Optional<DataType>> mapper;

    public ArgumentMappingTypeStrategy(int pos, Function<DataType, Optional<DataType>> mapper) {
        Preconditions.checkArgument((pos >= 0 ? 1 : 0) != 0);
        Preconditions.checkNotNull(mapper);
        this.pos = pos;
        this.mapper = mapper;
    }

    @Override
    public Optional<DataType> inferType(CallContext callContext) {
        List<DataType> argumentDataTypes = callContext.getArgumentDataTypes();
        if (this.pos >= argumentDataTypes.size()) {
            return Optional.empty();
        }
        return this.mapper.apply(argumentDataTypes.get(this.pos));
    }
}

