/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.aliyun.oss;

import com.aliyun.oss.model.ListObjectsV2Result;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import java.util.List;
import org.slf4j.Logger;

public final class OSSListResult {
    private ObjectListing v1Result;
    private ListObjectsV2Result v2Result;

    protected OSSListResult(ObjectListing v1, ListObjectsV2Result v2) {
        this.v1Result = v1;
        this.v2Result = v2;
    }

    public static OSSListResult v1(ObjectListing result) {
        return new OSSListResult(result, null);
    }

    public static OSSListResult v2(ListObjectsV2Result result) {
        return new OSSListResult(null, result);
    }

    public boolean isV1() {
        return this.v1Result != null;
    }

    public ObjectListing getV1() {
        return this.v1Result;
    }

    public ListObjectsV2Result getV2() {
        return this.v2Result;
    }

    public List<OSSObjectSummary> getObjectSummaries() {
        if (this.isV1()) {
            return this.v1Result.getObjectSummaries();
        }
        return this.v2Result.getObjectSummaries();
    }

    public boolean isTruncated() {
        if (this.isV1()) {
            return this.v1Result.isTruncated();
        }
        return this.v2Result.isTruncated();
    }

    public List<String> getCommonPrefixes() {
        if (this.isV1()) {
            return this.v1Result.getCommonPrefixes();
        }
        return this.v2Result.getCommonPrefixes();
    }

    public void logAtDebug(Logger log) {
        List<String> prefixes = this.getCommonPrefixes();
        List<OSSObjectSummary> summaries = this.getObjectSummaries();
        log.debug("Prefix count = {}; object count={}", (Object)prefixes.size(), (Object)summaries.size());
        for (OSSObjectSummary summary : summaries) {
            log.debug("Summary: {} {}", (Object)summary.getKey(), (Object)summary.getSize());
        }
        for (String prefix : prefixes) {
            log.debug("Prefix: {}", (Object)prefix);
        }
    }
}

