/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.aliyun.oss;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.aliyun.oss.AliyunOSSFileSystemStore;
import org.apache.hadoop.fs.aliyun.oss.ReadBuffer;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliyunOSSFileReaderTask
implements Runnable {
    public static final Logger LOG = LoggerFactory.getLogger(AliyunOSSFileReaderTask.class);
    private String key;
    private AliyunOSSFileSystemStore store;
    private ReadBuffer readBuffer;
    private static final int MAX_RETRIES = 3;
    private RetryPolicy retryPolicy;

    public AliyunOSSFileReaderTask(String key, AliyunOSSFileSystemStore store, ReadBuffer readBuffer) {
        this.key = key;
        this.store = store;
        this.readBuffer = readBuffer;
        RetryPolicy defaultPolicy = RetryPolicies.retryUpToMaximumCountWithFixedSleep(3, 3L, TimeUnit.SECONDS);
        HashMap<Class<? extends Exception>, RetryPolicy> policies = new HashMap<Class<? extends Exception>, RetryPolicy>();
        policies.put(IOException.class, defaultPolicy);
        policies.put(IndexOutOfBoundsException.class, RetryPolicies.TRY_ONCE_THEN_FAIL);
        policies.put(NullPointerException.class, RetryPolicies.TRY_ONCE_THEN_FAIL);
        this.retryPolicy = RetryPolicies.retryByException(defaultPolicy, policies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int retries = 0;
        this.readBuffer.lock();
        try {
            while (true) {
                try (InputStream in = this.store.retrieve(this.key, this.readBuffer.getByteStart(), this.readBuffer.getByteEnd());){
                    IOUtils.readFully(in, this.readBuffer.getBuffer(), 0, this.readBuffer.getBuffer().length);
                    this.readBuffer.setStatus(ReadBuffer.STATUS.SUCCESS);
                    break;
                }
                catch (Exception e) {
                    LOG.warn("Exception thrown when retrieve key: " + this.key + ", exception: " + e);
                    try {
                        RetryPolicy.RetryAction rc = this.retryPolicy.shouldRetry(e, retries++, 0, true);
                        if (rc.action == RetryPolicy.RetryAction.RetryDecision.RETRY) {
                            Thread.sleep(rc.delayMillis);
                            continue;
                        }
                        break;
                    }
                    catch (Exception ex) {
                        LOG.warn("Exception thrown when call shouldRetry, exception " + ex);
                        break;
                    }
                }
            }
            if (this.readBuffer.getStatus() != ReadBuffer.STATUS.SUCCESS) {
                this.readBuffer.setStatus(ReadBuffer.STATUS.ERROR);
            }
            this.readBuffer.signalAll();
        }
        finally {
            this.readBuffer.unlock();
        }
    }
}

