/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.cli;

import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.client.cli.CliResultView;
import org.apache.flink.table.client.cli.CliUtils;
import org.apache.flink.table.client.cli.TerminalUtils;
import org.apache.flink.table.client.gateway.ResultDescriptor;
import org.apache.flink.table.client.gateway.SqlExecutionException;
import org.apache.flink.table.client.gateway.TypedResult;
import org.apache.flink.table.client.gateway.result.ChangelogResult;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.utils.print.PrintStyle;
import org.apache.flink.table.utils.print.RowDataToStringConverter;
import org.jline.keymap.KeyMap;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.jline.utils.InfoCmp;

public class CliChangelogResultView
extends CliResultView<ResultChangelogOperation> {
    private static final int DEFAULT_MAX_ROW_COUNT = 1000;
    private static final int DEFAULT_REFRESH_INTERVAL = 0;
    private static final int DEFAULT_REFRESH_INTERVAL_PLAIN = 3;
    private static final int MIN_REFRESH_INTERVAL = 0;
    private LocalTime lastRetrieval;
    private int scrolling;
    private final ChangelogResult collectResult;

    public CliChangelogResultView(Terminal terminal, ResultDescriptor resultDescriptor) {
        this(terminal, resultDescriptor, (ChangelogResult)resultDescriptor.createResult());
    }

    @VisibleForTesting
    public CliChangelogResultView(Terminal terminal, ResultDescriptor resultDescriptor, ChangelogResult collectResult) {
        super(terminal, resultDescriptor, PrintStyle.tableauWithTypeInferredColumnWidths((ResolvedSchema)resultDescriptor.getResultSchema(), (RowDataToStringConverter)resultDescriptor.getRowDataStringConverter(), (int)resultDescriptor.maxColumnWidth(), (boolean)false, (boolean)true));
        this.collectResult = collectResult;
        this.refreshInterval = TerminalUtils.isPlainTerminal(terminal) ? 3 : 0;
        this.previousResults = null;
        this.results = new LinkedList();
    }

    @Override
    protected String[] getRow(String[] resultRow) {
        return Arrays.copyOfRange(resultRow, 1, resultRow.length);
    }

    @Override
    void cleanUpQuery() {
        this.collectResult.close();
    }

    @Override
    protected void display() {
        if (this.scrolling > 0) {
            this.selectedRow = -1;
        }
        this.scrollDown(this.scrolling);
        this.scrolling = 0;
        super.display();
    }

    @Override
    protected void refresh() {
        TypedResult<List<RowData>> result;
        try {
            result = this.collectResult.retrieveChanges();
        }
        catch (SqlExecutionException e) {
            this.close(e);
            return;
        }
        switch (result.getType()) {
            case EMPTY: {
                break;
            }
            case EOS: {
                this.stopRetrieval(false);
                break;
            }
            default: {
                List<RowData> changes = result.getPayload();
                for (RowData change : changes) {
                    String[] row = this.tableauStyle.rowFieldsToString(change);
                    if (this.results.size() >= 1000) {
                        this.results.remove(0);
                    }
                    this.results.add(row);
                    ++this.scrolling;
                }
            }
        }
        this.resetAllParts();
        this.lastRetrieval = LocalTime.now();
    }

    @Override
    protected KeyMap<ResultChangelogOperation> getKeys() {
        KeyMap<ResultChangelogOperation> keys = new KeyMap<ResultChangelogOperation>();
        keys.setAmbiguousTimeout(200L);
        keys.bind(ResultChangelogOperation.QUIT, "q", "Q", KeyMap.esc(), KeyMap.ctrl('c'));
        keys.bind(ResultChangelogOperation.REFRESH, "r", "R", KeyMap.key(this.terminal, InfoCmp.Capability.key_f5));
        keys.bind(ResultChangelogOperation.UP, "w", "W", KeyMap.key(this.terminal, InfoCmp.Capability.key_up));
        keys.bind(ResultChangelogOperation.DOWN, "s", "S", KeyMap.key(this.terminal, InfoCmp.Capability.key_down));
        keys.bind(ResultChangelogOperation.LEFT, "a", "A", KeyMap.key(this.terminal, InfoCmp.Capability.key_left));
        keys.bind(ResultChangelogOperation.RIGHT, "d", "D", KeyMap.key(this.terminal, InfoCmp.Capability.key_right));
        keys.bind(ResultChangelogOperation.OPEN, "o", "O", "\r");
        keys.bind(ResultChangelogOperation.INC_REFRESH, (CharSequence)"+");
        keys.bind(ResultChangelogOperation.DEC_REFRESH, (CharSequence)"-");
        return keys;
    }

    @Override
    protected void evaluate(ResultChangelogOperation operation, String binding) {
        switch (operation) {
            case QUIT: {
                this.close();
                break;
            }
            case REFRESH: {
                this.refresh();
                break;
            }
            case UP: {
                this.selectRowUp();
                break;
            }
            case DOWN: {
                this.selectRowDown();
                break;
            }
            case OPEN: {
                this.openRow();
                break;
            }
            case LEFT: {
                this.scrollLeft();
                break;
            }
            case RIGHT: {
                this.scrollRight();
                break;
            }
            case INC_REFRESH: {
                this.increaseRefreshInterval();
                break;
            }
            case DEC_REFRESH: {
                this.decreaseRefreshInterval(0);
            }
        }
    }

    @Override
    protected String getTitle() {
        return "SQL Query Result (Changelog)";
    }

    @Override
    protected List<AttributedString> computeHeaderLines() {
        AttributedStringBuilder statusLine = new AttributedStringBuilder();
        statusLine.style(AttributedStyle.INVERSE);
        String left = this.isRetrieving() ? " Refresh: " + (String)((Tuple2)CliChangelogResultView.REFRESH_INTERVALS.get((int)this.refreshInterval)).f0 : " Table program finished.";
        String right = this.lastRetrieval == null ? "Updated: Unknown " : "Updated: " + this.lastRetrieval.format(CliUtils.TIME_FORMATTER) + " ";
        int middleSpace = this.getWidth() - left.length() - right.length();
        statusLine.append(left);
        CliUtils.repeatChar(statusLine, ' ', middleSpace);
        statusLine.append(right);
        return Arrays.asList(statusLine.toAttributedString(), AttributedString.EMPTY);
    }

    @Override
    protected List<AttributedString> computeMainHeaderLines() {
        ArrayList<String> columnNames = new ArrayList<String>(this.columnWidths.length);
        columnNames.add("op");
        columnNames.addAll(this.resultDescriptor.getResultSchema().getColumnNames());
        AttributedStringBuilder schemaHeader = new AttributedStringBuilder();
        IntStream.range(0, columnNames.size()).forEach(idx -> {
            schemaHeader.style(AttributedStyle.DEFAULT);
            schemaHeader.append(' ');
            schemaHeader.style(AttributedStyle.DEFAULT.underline());
            CliUtils.normalizeColumn(schemaHeader, (String)columnNames.get(idx), this.columnWidths[idx]);
        });
        return Collections.singletonList(schemaHeader.toAttributedString());
    }

    @Override
    protected List<AttributedString> computeFooterLines() {
        return CliUtils.formatTwoLineHelpOptions(this.getWidth(), this.getHelpOptions());
    }

    private List<Tuple2<String, String>> getHelpOptions() {
        ArrayList<Tuple2<String, String>> options = new ArrayList<Tuple2<String, String>>();
        options.add(Tuple2.of((Object)"Q", (Object)"Quit"));
        options.add(Tuple2.of((Object)"R", (Object)"Refresh"));
        options.add(Tuple2.of((Object)"+", (Object)"Inc Refresh"));
        options.add(Tuple2.of((Object)"-", (Object)"Dec Refresh"));
        options.add(Tuple2.of((Object)"O", (Object)"Open Row"));
        return options;
    }

    public static enum ResultChangelogOperation {
        QUIT,
        REFRESH,
        UP,
        DOWN,
        OPEN,
        LEFT,
        RIGHT,
        INC_REFRESH,
        DEC_REFRESH;

    }
}

